package com.instabug.library.diagnostics.customtraces.settings

import androidx.annotation.VisibleForTesting
import com.instabug.library.diagnostics.DiagnosticsConstants.CUSTOM_TRACES
import com.instabug.library.diagnostics.DiagnosticsConstants.MAX_COUNT
import com.instabug.library.diagnostics.DiagnosticsConstants.RECORD_FEATURE_TRACE
import com.instabug.library.diagnostics.DiagnosticsConstants.RECORD_LAUNCH_TRACE
import com.instabug.library.diagnostics.customtraces.di.CustomTracesServiceLocator
import com.instabug.library.settings.PersistableSettings
import com.instabug.library.settings.SettingsManager
import org.json.JSONObject

object CustomTracesSettingsResolver {

    const val CUSTOM_TRACES_DEFAULT_AVAILABILITY = false
    const val LAUNCH_TRACES_DEFAULT_AVAILABILITY = false
    const val FEATURE_TRACES_DEFAULT_AVAILABILITY = false
    const val DEFAULT_MAX_COUNT = 15

    var customTracesSettings: CustomTracesSettings? = null
        get() {
            if (field == null) {
                customTracesSettings = CustomTracesSettings(
                    enabled = PersistableSettings.getInstance()
                        ?.getBoolean(CUSTOM_TRACES, CUSTOM_TRACES_DEFAULT_AVAILABILITY)
                        ?: CUSTOM_TRACES_DEFAULT_AVAILABILITY,
                    maxCount = SettingsManager.getInstance().customTracesCount,
                    recordLaunchTrace = PersistableSettings.getInstance()
                        ?.getBoolean(RECORD_LAUNCH_TRACE, LAUNCH_TRACES_DEFAULT_AVAILABILITY)
                        ?: LAUNCH_TRACES_DEFAULT_AVAILABILITY,
                    recordFeatureTrace = PersistableSettings.getInstance()
                        ?.getBoolean(RECORD_FEATURE_TRACE, FEATURE_TRACES_DEFAULT_AVAILABILITY)
                        ?: FEATURE_TRACES_DEFAULT_AVAILABILITY
                )

            }
            return field ?: CustomTracesSettings()
        }
        @VisibleForTesting
        set

    fun resolve(customTraces: JSONObject?) {
        customTraces?.let {
            customTracesSettings = CustomTracesSettings(
                enabled =
                PersistableSettings.getInstance()
                    ?.getBoolean(CUSTOM_TRACES, CUSTOM_TRACES_DEFAULT_AVAILABILITY)
                    ?: CUSTOM_TRACES_DEFAULT_AVAILABILITY,
                maxCount = customTraces.optInt(MAX_COUNT, DEFAULT_MAX_COUNT),
                recordLaunchTrace = PersistableSettings.getInstance()
                    ?.getBoolean(RECORD_LAUNCH_TRACE, LAUNCH_TRACES_DEFAULT_AVAILABILITY)
                    ?: LAUNCH_TRACES_DEFAULT_AVAILABILITY,
                recordFeatureTrace = PersistableSettings.getInstance()
                    ?.getBoolean(RECORD_FEATURE_TRACE, FEATURE_TRACES_DEFAULT_AVAILABILITY)
                    ?: FEATURE_TRACES_DEFAULT_AVAILABILITY
            )
            SettingsManager.getInstance()
                .saveCustomTracesCount(customTracesSettings?.maxCount ?: DEFAULT_MAX_COUNT)

            clearCacheIfNeeded()
        }
    }

     private fun clearCacheIfNeeded() {
        if (customTracesSettings?.enabled != true)
            CustomTracesServiceLocator.getCustomTracesManager().clearCache()

        if(customTracesSettings?.recordFeatureTrace != true)
            CustomTracesServiceLocator.getCustomTracesManager().clearTracesForFlag(RECORD_FEATURE_TRACE)

        if(customTracesSettings?.recordLaunchTrace != true)
            CustomTracesServiceLocator.getCustomTracesManager().clearTracesForFlag(RECORD_LAUNCH_TRACE)
    }

    fun resetCustomTracesSettings() {
        customTracesSettings = CustomTracesSettings()

        PersistableSettings.getInstance()
            ?.saveBoolean(CUSTOM_TRACES, CUSTOM_TRACES_DEFAULT_AVAILABILITY)
        PersistableSettings.getInstance()
            ?.saveBoolean(RECORD_LAUNCH_TRACE, LAUNCH_TRACES_DEFAULT_AVAILABILITY)
        PersistableSettings.getInstance()
            ?.saveBoolean(RECORD_FEATURE_TRACE, FEATURE_TRACES_DEFAULT_AVAILABILITY)
        SettingsManager.getInstance()
            .saveCustomTracesCount(customTracesSettings?.maxCount ?: DEFAULT_MAX_COUNT)
    }

}