package com.instabug.library.diagnostics.customtraces.cache

interface AttributesDBHelper {

    /**
     * Adds attribute to trace
     *
     * @param traceId to use as a foreign key
     * @param key attribute key
     * @param value attribute value
     *
     * @return true if attribute was inserted to db
     */
    fun addAttribute(traceId: Long, key: String, value: String): Boolean

    /**
     * Updates existing attribute
     *
     * @param traceId to use as in query
     * @param key attribute key
     * @param value attribute value
     *
     * @return true if attribute was updated
     */
    fun updateAttribute(traceId: Long, key: String, value: String): Boolean

    /**
     * Removes attribute from trace
     *
     * @param traceId to use in query
     * @param key attribute key
     * @param value attribute value
     *
     * @return true if attribute was removed from db
     */
    fun removeAttribute(traceId: Long, key: String): Boolean

    /**
     * Get all attributes for a trace
     *
     * @param traceId to use in query
     *
     * @return attributes map
     */
    fun getTraceAttributes(traceId: Long): HashMap<String, String>
}