/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.datahub.c;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.networkv2.BodyBufferHelper;
import com.instabug.library.sessionreplay.model.a;
import com.instabug.library.sessionreplay.model.b;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkLog
implements a,
c {
    public static final String CONTENT_TYPE = "content-type";
    public static final String JSON = "application/json";
    public static final String PROTOBUF = "application/protobuf";
    public static final String XML_1 = "application/xml";
    public static final String XML_2 = "text/xml";
    public static final String HTML = "text/html";
    public static final String PLAIN_TEXT = "text/plain";
    public static final int NETWORK_LOG_LIMIT = 100;
    public static final int SQL_RECORD_CHAR_LIMIT = 1000000;
    public static final String FAILED_TO_PARSE_NETWORK_LOG_TO_JSON = "Failed to parse Network Log to JSON:";
    public static final String REQUEST_BODY_EXCEEDS_THE_MAXIMUM_SIZE_OF_1_KB = "The request body has not been logged because it exceeds the maximum size of %s Kb";
    public static final String RESPONSE_BODY_EXCEEDS_THE_MAXIMUM_SIZE_OF_1_KB = "The response body has not been logged because it exceeds the maximum size of %s Kb";
    private static final int KB = 1024;
    @Nullable
    private String date;
    @Nullable
    private String url;
    @Nullable
    private String request;
    @Nullable
    private String response;
    @Nullable
    private String method;
    @Nullable
    private String requestHeaders;
    @Nullable
    private String responseHeaders;
    private long totalDuration;
    private int responseCode;
    private boolean userModified = false;

    /*
     * WARNING - void declaration
     */
    @NonNull
    private String validateSize(@NonNull String request, @NonNull String fallback) {
        Object object;
        int n2 = b.a(this);
        int n3 = n2 / 1024;
        if (!BodyBufferHelper.isBodySizeAllowed(request, (long)n2)) {
            void var2_4;
            Integer n4 = n3;
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n4;
            object = String.format((String)var2_4, object);
        }
        return object;
    }

    @Nullable
    public String getDate() {
        return this.date;
    }

    /*
     * WARNING - void declaration
     */
    public void setDate(@Nullable String date) {
        void var1_1;
        this.date = var1_1;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - void declaration
     */
    public void setUrl(@Nullable String url) {
        void var1_1;
        this.url = var1_1;
    }

    @Nullable
    public String getRequest() {
        return this.request;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequest(@Nullable String request) {
        void var1_1;
        this.request = request != null ? this.validateSize((String)var1_1, REQUEST_BODY_EXCEEDS_THE_MAXIMUM_SIZE_OF_1_KB) : null;
    }

    @Nullable
    public String getResponse() {
        return this.response;
    }

    /*
     * WARNING - void declaration
     */
    public void setResponse(@Nullable String response) {
        void var1_1;
        this.response = response != null ? this.validateSize((String)var1_1, RESPONSE_BODY_EXCEEDS_THE_MAXIMUM_SIZE_OF_1_KB) : null;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    /*
     * WARNING - void declaration
     */
    public void setMethod(@Nullable String method) {
        void var1_1;
        this.method = var1_1;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    /*
     * WARNING - void declaration
     */
    public void setResponseCode(int responseCode) {
        void var1_1;
        this.responseCode = var1_1;
    }

    @Nullable
    public String getRequestHeaders() {
        return this.requestHeaders;
    }

    @Nullable
    public String getResponseHeaders() {
        return this.responseHeaders;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestHeaders(@Nullable String requestHeaders) {
        void var1_1;
        this.requestHeaders = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setResponseHeaders(@Nullable String responseHeaders) {
        void var1_1;
        this.responseHeaders = var1_1;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    /*
     * WARNING - void declaration
     */
    public void setTotalDuration(long totalDuration) {
        void var1_1;
        this.totalDuration = var1_1;
    }

    public boolean isUserModified() {
        return this.userModified;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserModified(boolean userModified) {
        void var1_1;
        this.userModified = var1_1;
    }

    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION"})
    public boolean equals(Object o2) {
        NetworkLog networkLog;
        if (this_ == networkLog) {
            return true;
        }
        if (!(networkLog instanceof NetworkLog)) {
            return false;
        }
        networkLog = networkLog;
        if (((NetworkLog)((Object)this_)).responseCode != networkLog.responseCode) {
            return false;
        }
        String string2 = ((NetworkLog)((Object)this_)).date;
        if (string2 != null ? !string2.equals(networkLog.date) : networkLog.date != null) {
            return false;
        }
        string2 = ((NetworkLog)((Object)this_)).url;
        if (string2 != null ? !string2.equals(networkLog.url) : networkLog.url != null) {
            return false;
        }
        string2 = ((NetworkLog)((Object)this_)).request;
        if (string2 != null ? !string2.equals(networkLog.request) : networkLog.request != null) {
            return false;
        }
        string2 = ((NetworkLog)((Object)this_)).response;
        if (string2 != null ? !string2.equals(networkLog.response) : networkLog.response != null) {
            return false;
        }
        string2 = ((NetworkLog)((Object)this_)).method;
        if (string2 != null ? !string2.equals(networkLog.method) : networkLog.method != null) {
            return false;
        }
        if (((NetworkLog)((Object)this_)).totalDuration != networkLog.totalDuration) {
            return false;
        }
        string2 = ((NetworkLog)((Object)this_)).responseHeaders;
        if (string2 != null ? !string2.equals(networkLog.responseHeaders) : networkLog.responseHeaders != null) {
            return false;
        }
        if (((NetworkLog)((Object)this_)).userModified != networkLog.userModified) {
            return false;
        }
        String this_ = ((NetworkLog)((Object)this_)).requestHeaders;
        return this_ != null ? this_.equals(networkLog.requestHeaders) : networkLog.requestHeaders == null;
    }

    public int hashCode() {
        String string2 = this.date;
        int n2 = (string2 != null ? string2.hashCode() : 0) * 31;
        String string3 = this.url;
        int n3 = string3 != null ? string3.hashCode() : 0;
        n2 = (n2 + n3) * 31;
        String string4 = this.request;
        int n4 = string4 != null ? string4.hashCode() : 0;
        n2 = (n2 + n4) * 31;
        String string5 = this.response;
        int n5 = string5 != null ? string5.hashCode() : 0;
        n2 = (n2 + n5) * 31;
        String string6 = this.method;
        int n6 = string6 != null ? string6.hashCode() : 0;
        n2 = ((n2 + n6) * 31 + this.responseCode) * 31;
        String string7 = this.responseHeaders;
        int n7 = string7 != null ? string7.hashCode() : 0;
        n2 = (n2 + n7) * 31;
        String string8 = this.requestHeaders;
        int n8 = string8 != null ? string8.hashCode() : 0;
        return ((n2 + n8) * 31 + Long.valueOf(this.totalDuration).hashCode()) * 31 + this.userModified;
    }

    @NonNull
    public String toString() {
        return "NetworkLog{date='" + this.date + '\'' + ", url='" + this.url + '\'' + ", request='" + this.request + '\'' + ", method='" + this.method + '\'' + ", responseCode=" + this.responseCode + ", headers='" + this.requestHeaders + '\'' + ", response='" + this.response + '\'' + ", response_headers='" + this.responseHeaders + '\'' + ", totalDuration='" + this.totalDuration + '\'' + ", modifiedByUser='" + this.userModified + '\'' + '}';
    }

    public void insert() {
        CoreServiceLocator.getNetworkLogsDistributor().invoke(this);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public JSONObject toJsonObject() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        JSONObject jSONObject4;
        JSONObject jSONObject5;
        JSONObject jSONObject6 = jSONObject5;
        jSONObject6();
        jSONObject6.put("date", (Object)this.getDate());
        jSONObject6.put("method", (Object)this.getMethod());
        jSONObject6.put("status", this.getResponseCode());
        jSONObject6.put("url", (Object)this.getUrl());
        long l2 = this.getTotalDuration();
        jSONObject6.put("response_time", l2);
        jSONObject5.put("user_modified", this.isUserModified());
        JSONObject jSONObject7 = jSONObject4;
        try {
            jSONObject4 = new JSONObject(this.getRequestHeaders());
            jSONObject5.put("headers", (Object)jSONObject7);
        }
        catch (Exception exception) {
            jSONObject6.put("headers", (Object)this.getRequestHeaders());
        }
        JSONObject jSONObject8 = jSONObject6;
        JSONObject jSONObject9 = jSONObject3;
        try {
            jSONObject3 = new JSONObject(this.getResponseHeaders());
            jSONObject8.put("response_headers", (Object)jSONObject9);
        }
        catch (Exception exception) {
            jSONObject6.put("response_headers", (Object)this.getResponseHeaders());
        }
        JSONObject jSONObject10 = jSONObject6;
        JSONObject jSONObject11 = jSONObject2;
        try {
            jSONObject2 = new JSONObject(this.getRequest());
            jSONObject10.put("request", (Object)jSONObject11);
        }
        catch (Exception exception) {
            jSONObject6.put("request", (Object)this.getRequest());
        }
        JSONObject jSONObject12 = jSONObject6;
        JSONObject jSONObject13 = jSONObject;
        try {
            jSONObject = new JSONObject(this.getResponse());
            jSONObject12.put("response", (Object)jSONObject13);
        }
        catch (Exception exception) {
            jSONObject6.put("response", (Object)this.getResponse());
        }
        return jSONObject6;
    }

    public long getTimestamp() {
        String this_ = ((NetworkLog)((Object)this_)).date;
        return this_ != null ? Long.parseLong(this_) : 0L;
    }

    @Override
    @NonNull
    public String getLogType() {
        return "NETWORK_LOG";
    }

    @Override
    @Nullable
    public JSONObject getSrJsonRep() {
        String string2;
        NetworkLog networkLog;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        try {
            JSONObject jSONObject3 = ((NetworkLog)((Object)this_)).toJsonObject();
            jSONObject2 = jSONObject3;
            jSONObject = jSONObject3;
            networkLog = this_;
            string2 = "log_type";
        }
        catch (JSONException jSONException) {
            IBGDiagnostics.reportNonFatalAndLog(jSONException, FAILED_TO_PARSE_NETWORK_LOG_TO_JSON, "IBG-Core");
            return null;
        }
        JSONObject jSONObject4 = jSONObject2.put(string2, (Object)networkLog.getLogType());
        NetworkLog networkLog2 = this_;
        String this_ = "timestamp";
        long l2 = networkLog2.getTimestamp();
        jSONObject4.put(this_, l2);
        return jSONObject;
    }

    @Override
    @Nullable
    public JSONObject getDataHubRep() {
        try {
            return this.toJsonObject();
        }
        catch (JSONException jSONException) {
            IBGDiagnostics.reportNonFatalAndLog(jSONException, FAILED_TO_PARSE_NETWORK_LOG_TO_JSON, "IBG-Core");
            return null;
        }
    }
}

