package com.instabug.library.visualusersteps;

import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.SeekBar;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.ToggleButton;

import com.google.android.material.bottomnavigation.BottomNavigationItemView;
import com.google.android.material.internal.NavigationMenuItemView;
import com.google.android.material.tabs.TabLayout;
import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

import androidx.annotation.VisibleForTesting;
import androidx.appcompat.view.menu.ActionMenuItemView;
import androidx.appcompat.widget.SwitchCompat;
import androidx.appcompat.widget.Toolbar;

/**
 * Created by Barakat on 18/06/2019
 */
public class ViewsTypeDetector {

    static boolean isTextView(View view) {
        return !isInstabugView(view)
                && view instanceof TextView
                && !(view instanceof Button)
                && !(view instanceof EditText)
                && !(view instanceof ActionMenuItemView);
    }

    @VisibleForTesting
    public static boolean isInstabugView(View view) {
        return view.getClass().getName().contains("instabug");
    }

    static boolean isButtonView(View view) {
        return !isInstabugView(view)
                && view instanceof Button
                && !(view instanceof Switch)
                && !(view instanceof SwitchCompat)
                && !(view instanceof ToggleButton)
                && !(view instanceof CheckBox)
                && !(view instanceof RadioButton);
    }

    static boolean isImageView(View view) {
        return !isInstabugView(view)
                && view instanceof ImageView
                && !(view instanceof ImageButton);
    }

    static boolean isImageButton(View view) {
        return !isInstabugView(view)
                && view instanceof ImageButton;
    }

    static boolean isToolbar(View view) {
        return !isInstabugView(view)
                && (view instanceof Toolbar);
    }

    static boolean TabLayout(View view) {
        return !isInstabugView(view)
                && view instanceof TabLayout;
    }

    static boolean isNavItemView(View view) {
        return !isInstabugView(view)
                && (isNavigationMenuItemView(view)
                || isBottomNavigationItemView(view));
    }

    private static boolean isNavigationMenuItemView(View view) {
        try {
            return view instanceof NavigationMenuItemView;
        } catch (IllegalAccessError exception) {
            String message = exception.getMessage();
            if (message == null) {
                message = "IllegalAccessException for NavigationMenuItemView";
            }
            InstabugSDKLogger.e(Constants.LOG_TAG, message, exception);
            return false;
        }
    }

    private static boolean isBottomNavigationItemView(View view) {
        try {
            return view instanceof BottomNavigationItemView;
        } catch (IllegalAccessError exception) {
            String message = exception.getMessage();
            if (message == null) {
                message = "IllegalAccessException for BottomNavigationItemView";
            }
            InstabugSDKLogger.e(Constants.LOG_TAG, message, exception);
            return false;
        }
    }

    public static boolean isSeekbar(View view) {
        return (view instanceof SeekBar);
    }

    public static boolean isSwitch(View view) {
        return (view instanceof CompoundButton);
    }
}
