package com.instabug.library.util.threading

import android.os.Process
import java.util.concurrent.*

open class SingleThreadPoolExecutor @JvmOverloads constructor(
	identifier: String,
	keepAliveTime: Long = 60,
	unit: TimeUnit = TimeUnit.SECONDS,
	workQueue: BlockingQueue<Runnable> = LinkedBlockingQueue(),
	threadFactory: ThreadFactory = PriorityThreadFactory(identifier, Process.THREAD_PRIORITY_BACKGROUND)
) : ThreadPoolExecutor(
	1,
	1,
	keepAliveTime,
	unit,
	workQueue,
	threadFactory
) {
	private var identifier: String? = null
	private var listener: ThreadPoolIdleListener? = null

	open fun setIdentifier(identifier: String?): SingleThreadPoolExecutor {
		if (identifier != null) {
			this.identifier = identifier
		}
		return this
	}

	override fun execute(command: Runnable?) {
		super.execute(runDefensive(command))
	}

	open fun setThreadPoolIdleListener(listener: ThreadPoolIdleListener?): SingleThreadPoolExecutor {
		this.listener = listener
		return this
	}

	override fun afterExecute(r: Runnable?, t: Throwable?) {
		try {
			super.afterExecute(r, t)
			if (activeCount == 0 && listener != null) {
				listener?.onPoolReachIdleState(identifier)
			}
		} catch (e: Throwable) {
			defensiveLog(e)
			if (e is OutOfMemoryError) {
				reportOOM(e)
			}
		}
	}
}