package com.instabug.library.util.extenstions

import com.instabug.library.Constants
import com.instabug.library.util.InstabugSDKLogger

private val sqlStatementRegex =
    Regex(
        "(\\s*([\\\\0\\\\b\\'\\\"\\n\\r\\t\\%\\_\\\\]*\\s*(((select\\s*.+\\s*from\\s*.+)|(insert\\s*.+\\s*into\\s*.+)|(update\\s*.+\\s*set\\s*.+)|(delete\\s*.+\\s*from\\s*.+)|(drop\\s*.+)|(truncate\\s*.+)|(alter\\s*.+)|(exec\\s*.+)|(\\s*(all|any|not|and|between|in|like|or|some|contains|containsall|containskey)\\s*.+[\\=\\>\\<=\\!\\~]+.+)|(let\\s+.+[\\=]\\s*.*)|(begin\\s*.*\\s*end)|(\\s*[\\/\\*]+\\s*.*\\s*[\\*\\/]+)|(\\s*(\\-\\-)\\s*.*\\s+)|(\\s*(contains|containsall|containskey)\\s+.*)))(\\s*[\\;]\\s*)*)+)",
        RegexOption.IGNORE_CASE
    )

val String.isSQLStatement: Boolean
    get() = "$this ".contains(sqlStatementRegex)

internal fun String.prefixedWithT() = "T[${Thread.currentThread().name}] $this"

internal fun String.logVerbose(tag: String = Constants.LOG_TAG, withThread: Boolean = false) {
    val message = takeIf { withThread }
        ?.run { prefixedWithT() }
        ?: this
    InstabugSDKLogger.v(tag, message)
}

internal fun String.logVWithThreadName(tag: String = Constants.LOG_TAG) {
    logVerbose(tag, true)
}

internal fun String.logDebug(tag: String = Constants.LOG_TAG, withThread: Boolean = false) {
    val message = takeIf { withThread }
        ?.run { prefixedWithT() }
        ?: this
    InstabugSDKLogger.d(tag, message)
}

internal fun String.logDWithThreadName(tag: String = Constants.LOG_TAG) {
    logDebug(tag, true)
}

fun String.logError(throwable: Throwable? = null, tag: String = Constants.LOG_TAG) {
    throwable?.let { InstabugSDKLogger.e(tag, this, it) }
        ?: InstabugSDKLogger.e(tag, this)
}