package com.instabug.library.util

import androidx.annotation.VisibleForTesting
import java.io.Serializable

internal object UNINITIALIZED_VALUE

fun <T> nullRetryLazy(lock: Any? = null, initializer: () -> T): Lazy<T> =
    NulLRetryLazyImpl(initializer, lock)

@VisibleForTesting
class NulLRetryLazyImpl<out T>(
    initializer: () -> T,
    lock: Any? = null
) : Lazy<T>, Serializable {
    private var initializer: (() -> T)? = initializer

    @Volatile
    private var _value: Any? = UNINITIALIZED_VALUE
    private val lock = lock ?: this

    override val value: T
        get() {
            val _v1 = _value
            if (_v1 != null && _v1 !== UNINITIALIZED_VALUE) {
                @Suppress("UNCHECKED_CAST")
                return _v1 as T
            }

            return synchronized(lock) {
                val _v2 = _value
                if (_v2 != null && _v2 !== UNINITIALIZED_VALUE) {
                    @Suppress("UNCHECKED_CAST") (_v2 as T)
                } else {
                    val typedValue = initializer!!()
                    _value = typedValue
                    if (typedValue != null) initializer = null
                    typedValue
                }
            }
        }

    override fun isInitialized(): Boolean = _value !== UNINITIALIZED_VALUE

    override fun toString(): String =
        if (isInitialized()) value.toString() else "Lazy value not initialized yet."

    fun isInitializerNullified() = initializer == null
}

interface ParameterizedLazy<in R, out T> {
    fun get(initParam: R): T
    fun isInitialized(): Boolean
}

fun <R, T> parameterizedNullRetryLazy(
    lock: Any? = null,
    initializer: (R) -> T
): ParameterizedLazy<R, T> = ParameterizedNullRetryLazyImpl(initializer, lock)

private class ParameterizedNullRetryLazyImpl<in R, out T>(
    initializer: (R) -> T,
    lock: Any? = null
) : ParameterizedLazy<R, T>, Serializable {

    private var initializer: ((R) -> T)? = initializer

    @Volatile
    private var _value: Any? = UNINITIALIZED_VALUE
    private val lock = lock ?: this

    override fun get(initParam: R): T {
        val _v1 = _value
        if (_v1 != null && _v1 !== UNINITIALIZED_VALUE) {
            @Suppress("UNCHECKED_CAST")
            return _v1 as T
        }
        return synchronized(lock) {
            val _v2 = _value
            if (_v2 != null && _v2 !== UNINITIALIZED_VALUE) {
                @Suppress("UNCHECKED_CAST")
                (_v2 as T)
            } else {
                val typedValue = initializer!!(initParam)
                _value = typedValue
                if (typedValue != null) initializer = null
                typedValue
            }
        }
    }

    override fun isInitialized(): Boolean = _value !== UNINITIALIZED_VALUE

    override fun toString(): String =
        if (isInitialized()) _value.toString() else "Parameterized Lazy value not initialized yet."
}