package com.instabug.library.tracking;

import android.view.MotionEvent;

import com.instabug.library.usersteps.MotionEventRecognizer;

public class InstabugTouchEventsTracker {
    private static InstabugTouchEventsTracker INSTANCE;

    private InstabugTouchEventsTracker() {
    }

    /**
     * Returns the current singleton instance of this class.
     *
     * @return singleton instance of InstabugTouchEventsTracker.
     */
    public static InstabugTouchEventsTracker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugTouchEventsTracker();
        }
        return INSTANCE;
    }

    void trackTouchEvent(MotionEvent ev) {
        MotionEventRecognizer.getInstance().recognize(ev);
    }


}
