package com.instabug.library.tracking

import android.app.Activity
import androidx.annotation.VisibleForTesting

object IBGWindowCallbacksHandler {

    private val _registeredActivities: MutableList<Int> = mutableListOf()

    val registeredActivities: List<Int>
        get() = _registeredActivities


    @JvmStatic
    fun registerWindowCallbacksIfNeeded(activity: Activity) {
        activity.window?.callback
            ?.takeUnless { originalCallbacks -> originalCallbacks is InstabugWindowCallbacks }
            ?.takeUnless { _registeredActivities.contains(activity.hashCode()) }
            ?.let { originalCallbacks ->
                activity.window?.callback = InstabugWindowCallbacks(originalCallbacks)
            }?.also { _registeredActivities.add(activity.hashCode()) }
    }

    @JvmStatic
    fun unregisterWindowCallbacks(activity: Activity) {
        takeIf { _registeredActivities.contains(activity.hashCode()) }
            ?.also { _registeredActivities.remove(activity.hashCode()) }
            ?.let { (activity.window?.callback as? InstabugWindowCallbacks)?.originalWindowCallbacks }
            ?.also { originalCallbacks -> activity.window?.callback = originalCallbacks }
    }

    @VisibleForTesting
    fun clear() {
        _registeredActivities.clear()
    }
}