package com.instabug.library.sessionreplay

//region Constants
const val SR_LOG_TAG = "IBG-SR"
// endregion

//region SRLog Keys
const val LOG_TYPE_KEY = "log_type"
const val TIMESTAMP_KEY = "timestamp"

//endregion

//region configurations keys
const val SR_KEY = "session_replay"
const val SR_ENABLED_KEY = "enabled"
const val SR_SYNC_INTERVAL_KEY = "sync_interval_min"
const val SR_NETWORK_KEY = "network"
const val SR_INSTABUG_LOG_KEY = "instabug_log"
const val SR_SCREENSHOTS_KEY = "screenshots"
const val SR_SCREENSHOTS_COMPRESSION_KEY = "screenshots_compression"
const val SR_USER_STEPS_KEY = "user_steps"
const val SR_MAX_SDK_MB_KEY = "max_sdk_mb"
const val SR_MAX_LOGS_KEY = "max_logs"
const val SR_SAMPLING_RATE_KEY = "sampling_rate"
const val SR_MAX_SESSION_MB_KEY = "max_session_mb"
const val SR_MAX_SCREENSHOTS_MP_PER_SESSION_KEY = "max_session_screenshots_mb"
const val SR_MONITORING_AVAILABILITY_KEY = "monitoring_metadata_enabled"
const val NETWORK_LOG_LIMIT_KEY = "network_log_char_limit"
const val INSTABUG_LOG_LIMIT_KEY = "instabug_log_char_limit"
const val SR_SESSION_LINK_PREFIX_KEY = "url"
const val SR_CALLBACK_KEY = "callback_enabled"

//endregion

//region preferences

const val SR_ENABLED_P_KEY = "session_replay_enabled"
const val SR_ENABLED_DEFAULT = false
const val SR_NETWORK_ENABLED_P_KEY = "session_replay_network"
const val SR_NETWORK_ENABLED_DEFAULT = true

const val NETWORK_LIMIT_P_KEY = "session_replay_network_limit"
const val NETWORK_LIMIT_DEFAULT = 10240

const val SR_INSTABUG_LOG_P_KEY = "session_replay_instabug_log"
const val SR_INSTABUG_LOG_DEFAULT = true

const val INSTABUG_LOG_LIMIT_P_KEY = "session_replay_instabug_log_limit"
const val INSTABUG_LOG_LIMIT_DEFAULT = 500

const val SR_USER_STEPS_ENABLED_P_KEY = "session_replay_user_steps"
const val SR_USER_STEPS_ENABLED_DEFAULT = true

const val SR_SCREENSHOTS_ENABLED_P_KEY = "session_replay_screenshots"
const val SR_SCREENSHOTS_ENABLED_DEFAULT = true

const val SR_SCREENSHOTS_COMPRESSION_P_KEY = "session_replay_screenshots_compression"
const val SR_SCREENSHOTS_COMPRESSION_DEFAULT = 0.25f

const val SR_MAX_SDK_SIZE_P_KEY = "session_replay_max_sdk_mb"
const val SR_MAX_SDK_SIZE_DEFAULT = 50.0f

const val SR_MAX_LOGS_P_KEY = "session_replay_max_logs"
const val SR_MAX_LOGS_DEFAULT = 500
const val SR_SAMPLING_RATE_P_KEY = "session_replay_sampling_rate"
const val SR_SAMPLING_RATE_DEFAULT = 30

const val SR_MAX_SESSION_SIZE_P_KEY = "session_replay_max_session_mb"
const val SR_MAX_SESSION_SIZE_DEFAULT = 15.0f

const val SR_MAX_SCREENSHOTS_SIZE_PER_SESSION_P_KEY = "session_replay_max_session_screenshots_mb"
const val SR_MAX_SCREENSHOTS_SIZE_PER_SESSION_DEFAULT = 2.0f

const val SR_MONITORING_AVAILABILITY_P_KEY = "session_replay_monitoring_available"
const val SR_MONITORING_AVAILABILITY_DEFAULT = true

const val SR_SESSION_LINK_PREFIX_P_KEY = "sr_session_link"
const val SR_SESSION_LINK_PREFIX_DEFAULT = "broken_link"

const val SR_CALLBACK_ENABLED_P_KEY = "session_replay_callback_enabled"
const val SR_CALLBACK_ENABLED_DEFAULT = true
const val RN_USER_EVALUATION_TIME_MILLIS = 2000L

object SrPreferences {
    val srAvailable = SR_ENABLED_P_KEY to SR_ENABLED_DEFAULT
    val srNetworkEnabled = SR_NETWORK_ENABLED_P_KEY to SR_NETWORK_ENABLED_DEFAULT
    val networkLimit = NETWORK_LIMIT_P_KEY to NETWORK_LIMIT_DEFAULT
    val srInstabugLogEnabled = SR_INSTABUG_LOG_P_KEY to SR_INSTABUG_LOG_DEFAULT
    val instabugLogsLimit = INSTABUG_LOG_LIMIT_P_KEY to INSTABUG_LOG_LIMIT_DEFAULT
    val srUserStepsEnabled = SR_USER_STEPS_ENABLED_P_KEY to SR_USER_STEPS_ENABLED_DEFAULT
    val screenshotsEnabled = SR_SCREENSHOTS_ENABLED_P_KEY to SR_SCREENSHOTS_ENABLED_DEFAULT
    val screenshotsCompression =
        SR_SCREENSHOTS_COMPRESSION_P_KEY to SR_SCREENSHOTS_COMPRESSION_DEFAULT
    val srMaxSDKSize = SR_MAX_SDK_SIZE_P_KEY to SR_MAX_SDK_SIZE_DEFAULT
    val srMaxLogs = SR_MAX_LOGS_P_KEY to SR_MAX_LOGS_DEFAULT
    val srSamplingRate = SR_SAMPLING_RATE_P_KEY to SR_SAMPLING_RATE_DEFAULT
    val maxSessionSize = SR_MAX_SESSION_SIZE_P_KEY to SR_MAX_SESSION_SIZE_DEFAULT
    val maxScreenshotsSizePerSession =
        SR_MAX_SCREENSHOTS_SIZE_PER_SESSION_P_KEY to SR_MAX_SCREENSHOTS_SIZE_PER_SESSION_DEFAULT
    val monitoringAvailability =
        SR_MONITORING_AVAILABILITY_P_KEY to SR_MONITORING_AVAILABILITY_DEFAULT
    val sessionLinkPrefix = SR_SESSION_LINK_PREFIX_P_KEY to SR_SESSION_LINK_PREFIX_DEFAULT
    val callbackEnabled = SR_CALLBACK_ENABLED_P_KEY to SR_CALLBACK_ENABLED_DEFAULT
}
//endregion

//region Error Messages
const val SOMETHING_WENT_WRONG_WHILE_SAVING_SR_SCREENSHOT_ERROR_MESSAGE =
    "Something went wrong while saving session replay screenshot"

//endregion

//region Shareable Link

const val SESSION_SHAREABLE_LINK_FORMAT = "%s/%s?utm_source=sdk"

//endregion