package com.instabug.library.sessionprofiler.model.timeline;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 Created by tarek on 3/4/18.
 */

public class ScreenOrientationMode extends TimelinePoint {

    private String value;

    public ScreenOrientationMode(String mode) {
        this.value = mode;
    }

    static Queue<TimelinePoint> fromJSONArray(JSONArray jsonArray) throws
            JSONException {
        Queue<TimelinePoint> screenOrientationModes = new ConcurrentLinkedQueue<>();

        for (int i = 0; i < jsonArray.length(); i++) {
            screenOrientationModes.add(fromJSONObject(jsonArray.getJSONObject(i)));
        }
        return screenOrientationModes;
    }

    private static ScreenOrientationMode fromJSONObject(JSONObject jsonObject) throws
            JSONException {
        ScreenOrientationMode screenOrientationMode = new ScreenOrientationMode(jsonObject
                .getString(KEY_VALUE));
        screenOrientationMode.setTime(jsonObject.getDouble(KEY_TIME));
        return screenOrientationMode;
    }

    public String getValue() {
        return value;
    }

    @Override
    protected JSONObject toJSONObject() throws JSONException {
        return getTimelinePointJSONObject(value);
    }
}
