package com.instabug.library.sessionV3.sync

import com.instabug.library.sessionV3.di.IBGSessionServiceLocator

interface IBGSessionsSyncManager {
    fun sync(batchingFilter: SessionBatchingFilter = AllFilter)
}

object IBGSessionsSyncMangerImpl : IBGSessionsSyncManager {
    private val syncJob by lazy { IBGSessionServiceLocator.syncJob }
    private val executor by lazy { IBGSessionServiceLocator.sessionExecutor }
    private val batchEvaluator by lazy { IBGSessionServiceLocator.batchEvaluator }
    private val configurations by lazy { IBGSessionServiceLocator.sessionConfigurations }
    override fun sync(batchingFilter: SessionBatchingFilter) {
        executor.execute {
            if (configurations.isV3SessionEnabled) {
                batchEvaluator.evaluate(batchingFilter)
                syncJob.start()
            }
        }
    }
}
