package com.instabug.library.networkv2;

/**
 * Created by tarek on 9/1/17.
 */


import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;

public class Multipart {

    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    private final static String charset = "UTF-8";
    private OutputStream outputStream;
    private PrintWriter writer;
    private final static int maxBufferSize = 1024 * 1024;

    /**
     * This constructor initializes a new HTTP POST request with content type
     * is set to multipart/form-data
     *
     * @param httpConn
     * @throws IOException
     */
    public Multipart(HttpURLConnection httpConn) throws IOException {

        // creates a unique boundary based on time stamp
        boundary = "--" + System.currentTimeMillis();
        httpConn.setUseCaches(false);
        httpConn.setDoOutput(true);    // indicates POST method
        httpConn.setDoInput(true);
        httpConn.setChunkedStreamingMode(maxBufferSize);
        httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        outputStream = httpConn.getOutputStream();
        writer = new PrintWriter(new OutputStreamWriter(outputStream, charset),
                true);
    }

    /**
     * Adds a form field to the request
     *
     * @param name  field name
     * @param value field value
     */
    public void addFormField(String name, String value) {
        writer.append("--").append(boundary).append(LINE_FEED);
        writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"")
                .append(LINE_FEED);
        writer.append(LINE_FEED);
        writer.append(value).append(LINE_FEED);
        writer.flush();
    }

    /**
     * Adds a upload file section to the request
     *
     * @param fieldName  name attribute in <input type="file" name="..." />
     * @param uploadFile a File to be uploaded
     * @throws IOException
     */
    public void addFilePart(String fieldName, String uploadFile, String fileName, String fileType)
            throws IOException {
        writer.append("--").append(boundary).append(LINE_FEED)
                .append("Content-Disposition: file; name=\"").append(fieldName)
                .append("\"; filename=\"").append(fileName).append("\"").append(LINE_FEED)
                .append("Content-Type: ").append(fileType).append(LINE_FEED)
                .append(LINE_FEED)
                .flush();

        FileInputStream inputStream = new FileInputStream(uploadFile);
        try {
            byte[] buffer = new byte[maxBufferSize];
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
            writer.flush();
        } finally {
            inputStream.close();
        }
    }

    /**
     * Adds a header field to the request.
     *
     * @param name  - name of the header field
     * @param value - value of the header field
     */
    public void addHeaderField(String name, String value) {
        writer.append(name + ": " + value).append(LINE_FEED);
        writer.flush();
    }

    /**
     * Completes the request.
     */
    public void finish() {
        writer.append(LINE_FEED).flush();
        writer.append("--").append(boundary).append("--")
                .append(LINE_FEED);
        writer.close();
    }

}
