package com.instabug.library.networkinterception.config

import com.instabug.library.featuresflags.configs.FeatureFlagsConfigsHandler
import com.instabug.library.internal.crossplatform.ICPConfigurationsProvider
import org.json.JSONObject

class NetworkInterceptionConfigurationHandler(
    private val configurationProvider: IBGNetworkInterceptionConfigurationProvider,
    private val cpConfigurationsProvider: ICPConfigurationsProvider
) : FeatureFlagsConfigsHandler {

    override fun handleConfigs(featuresResponse: JSONObject) {
        featuresResponse.optJSONObject(KEY_BE_NETWORK_CONFIG)?.also { networkObject ->
            handleW3cConfigurations(networkObject)
        } ?: configurationProvider.reset()
        cpConfigurationsProvider.onFeaturesStateChanged()
    }

    private fun handleW3cConfigurations(networkObject: JSONObject) {
        networkObject.optDouble(
            KEY_BE_W3C_EXTERNAL_TRACE_ID_AVAILABLE,
            DEFAULT_W3C_EXTERNAL_TRACE_ID_PERCENTAGE
        ).let(configurationProvider::setW3CNetworkExternalTraceIdFeatureAvailabilityPercentage)

        networkObject.optBoolean(
            KEY_BE_ATTACHING_GENERATE_W3C_TRACE_ID_AVAILABLE,
            DEFAULT_GENERATED_W3C_ATTACHING_AVAILABLE
        ).let { configurationProvider.isAttachingGeneratedW3CExternalTraceIdFeatureAvailable = it }

        networkObject.optBoolean(
            KEY_BE_ATTACHING_CAPTURED_W3C_TRACE_ID_AVAILABLE,
            DEFAULT_CAPTURED_W3C_ATTACHING_AVAILABLE
        ).let { configurationProvider.isAttachingCapturedW3CExternalTraceIdFeatureAvailable = it }
    }
}
