package com.instabug.library.migration;

import android.content.Context;

import com.instabug.library.BuildConfig;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.StringUtility;

import java.io.File;
import java.lang.ref.WeakReference;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.reactivexport.Observable;
import io.reactivexport.ObservableEmitter;
import io.reactivexport.ObservableOnSubscribe;

public class VUSEncryptionMigration extends AbstractMigration {
    private static final String VUS_MIGRATION = "vus_encryption_migration";
    @Nullable
    private WeakReference<Context> context;

    public VUSEncryptionMigration() {
        super(VUS_MIGRATION);
    }

    @Override
    public int getMigrationVersion() {
        return 4;
    }

    @Override
    public void initialize(@NonNull Context context) {
        this.context = new WeakReference<>(context);
    }

    @Override
    public boolean shouldMigrate() {
        // return true if the current SDK version greater than the last SDK version
        String lastSDKVersion = SettingsManager.getInstance().getLastSDKVersion();

        if (BuildConfig.SDK_VERSION.length() < 5
                || BuildConfig.SDK_VERSION.equalsIgnoreCase(lastSDKVersion)) {
            return false;
        }

        if (BuildConfig.SDK_VERSION.contains("-")) {
            return StringUtility.compareVersion(String.valueOf(BuildConfig.SDK_VERSION.charAt(4)),
                    String.valueOf("8.0.0".charAt(4))) == 1
                    || !SettingsManager.getInstance().isSDKVersionSet();
        } else {
            return StringUtility.compareVersion(BuildConfig.SDK_VERSION, "8.0.0") == 1
                    || !SettingsManager.getInstance().isSDKVersionSet();
        }
    }

    @Override
    public Observable<AbstractMigration> migrate() {
        return Observable.create(new ObservableOnSubscribe<AbstractMigration>() {
            @Override
            public void subscribe(ObservableEmitter<AbstractMigration> emitter) {
                if (context != null && context.get() != null) {
                    AttachmentManager.deleteRecursive(
                            new File(AttachmentManager.getAttachmentDirectory(context.get()) + "/usersteps"));
                    CacheManager.getInstance().invalidateAllCaches();
                    emitter.onNext(VUSEncryptionMigration.this);
                    emitter.onComplete();
                }
            }
        });
    }

    @Override
    public void doPreMigration() {

    }

    @Override
    public void doAfterMigration() {
        SettingsManager.getInstance().setCurrentSDKVersion(BuildConfig.SDK_VERSION);
    }
}
