package com.instabug.library.migration;

import android.annotation.SuppressLint;
import android.content.Context;

import com.instabug.library.BuildConfig;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;

import androidx.annotation.NonNull;
import io.reactivexport.Observable;
import io.reactivexport.ObservableEmitter;
import io.reactivexport.ObservableOnSubscribe;

/**
 * Created by Tarek360 on 11/14/16.
 */

public class SDKBackwardMigration extends AbstractMigration {

    private static final String SDK_BACKWARD_MIGRATION = "sdk_backward_migration";

    SDKBackwardMigration() {
        super(SDK_BACKWARD_MIGRATION);
    }

    @Override
    public int getMigrationVersion() {
        return 4;
    }

    @Override
    public void initialize(@NonNull Context context) {

    }

    @Override
    @SuppressLint("NULL_DEREFERENCE")
    public boolean shouldMigrate() {
        // return true if the current SDK version greater than the last SDK version
        String lastSDKVersion = SettingsManager.getInstance().getLastSDKVersion();
        if (BuildConfig.SDK_VERSION.contains("-") || lastSDKVersion.contains("-")) {
            return StringUtility.compareVersion(String.valueOf(BuildConfig.SDK_VERSION.charAt(0)),
                    String.valueOf(lastSDKVersion.charAt(0))) == -1
                    || !SettingsManager.getInstance().isSDKVersionSet();
        } else {
            return StringUtility.compareVersion(BuildConfig.SDK_VERSION, lastSDKVersion) == -1
                    || !SettingsManager.getInstance().isSDKVersionSet();
        }
    }

    @Override
    public Observable<AbstractMigration> migrate() {
        return Observable.create(new ObservableOnSubscribe<AbstractMigration>() {
            @Override
            public void subscribe(ObservableEmitter<AbstractMigration> emitter) {
                CacheManager.getInstance().invalidateAllCaches();
                emitter.onNext(SDKBackwardMigration.this);
                emitter.onComplete();
            }
        });
    }

    @Override
    public void doPreMigration() {

    }

    @Override
    public void doAfterMigration() {
        SettingsManager.getInstance().setCurrentSDKVersion(BuildConfig.SDK_VERSION);
    }
}
