package com.instabug.library.logscollection

import com.instabug.library.sessionreplay.SRLogReceiver.Factory.createStoreLogReceiver
import com.instabug.library.sessionreplay.model.SRLog
import com.instabug.library.util.extenstions.runOrLogError

const val ERROR_WHILE_DISTRIBUTE_LOGS_TO_RECEIVERS = "Error while distribute logs to receivers"

/**
 * Basic contract for logs distributors.
 * A log distributor is the object handling the distribution of a log model to all interested
 * parties.
 */
fun interface LogDistributor<T> {
    operator fun invoke(log: T)

    companion object Factory {
        @JvmStatic
        fun <T : SRLog> createBasicLogDistributorFor(vararg receivers: LogReceiver<T>) =
            BasicLogDistributor(createStoreLogReceiver(), *receivers)
    }
}

/**
 * A basic realization of [LogDistributor].
 * Generically accepts any type and a list of receivers for that specific type.
 * @constructor takes a list of [LogReceiver]s.
 */
class BasicLogDistributor<T>(vararg receivers: LogReceiver<T>) : LogDistributor<T> {
    private val _receivers: List<LogReceiver<T>> = receivers.toList()
    override fun invoke(log: T) {
        runOrLogError(errorMessage = ERROR_WHILE_DISTRIBUTE_LOGS_TO_RECEIVERS) {
            _receivers.forEach { receiver -> receiver(log) }
        }
    }
}