package com.instabug.library.internal.video;

import static com.instabug.library.broadcast.SDKInvokedBroadcast.SDIInvokedListener;
import static com.instabug.library.internal.video.InternalAutoScreenRecorderHelper.setStaticIntentData;
import static com.instabug.library.internal.video.InternalAutoScreenRecorderHelper.setStaticResultCode;
import android.Manifest;
import android.annotation.TargetApi;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.instabug.library.Constants;
import com.instabug.library.Feature;
import com.instabug.library._InstabugActivity;
import com.instabug.library.broadcast.SDKInvokedBroadcast;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.internal.InstabugMediaProjectionIntent;
import com.instabug.library.screenshot.ScreenshotCaptor;
import com.instabug.library.screenshot.ScreenshotManager;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StatusBarUtils;

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
public class RequestPermissionActivity extends AppCompatActivity implements _InstabugActivity, SDIInvokedListener {
    static final String SEND_DATA_TO_RECORDING_SERVICE_EVENT = "SendDataToRecordingService";
    private static final int CREATE_SCREEN_CAPTURE = 2020;
    private static final int REQUEST_SCREEN_RECORDING_MIC_PERMISSION = 2022;
    public static final int REQUEST_MEDIA_PROJECTION_PERMISSION = 2030;
    private static final int CREATE_SCREENSHOT = 101;
    protected static final String KEY_IS_VIDEO = "isVideo";
    protected static final String KEY_IS_INITIAL = "isInitial";
    public static final String KEY_IS_PERMISSION_GRANDTED = "isPermissionGranted";
    private SDKInvokedBroadcast sdkInvokedBroadcast = new SDKInvokedBroadcast(this);
    boolean isVideo = true;
    boolean isInitial = true;
    @Nullable
    static ScreenshotCaptor.CapturingCallback screenshotCapturingListener;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (Build.VERSION.SDK_INT >= 21) {
            StatusBarUtils.darkenStatusBarColor(this, InstabugCore.getPrimaryColor());
        }

        if (savedInstanceState == null) {
            MediaProjectionManager manager =
                    (MediaProjectionManager) getSystemService(MEDIA_PROJECTION_SERVICE);
            isVideo = getIntent().getBooleanExtra(KEY_IS_VIDEO, true);
            isInitial = getIntent().getBooleanExtra(KEY_IS_INITIAL, true);
            Intent intent = manager.createScreenCaptureIntent();
            if (isVideo) {
                if (SettingsManager.getInstance().getAutoScreenRecordingAudioCapturingState() == Feature.State.ENABLED) {
                    requestAudioRecordingPermission();
                } else {
                    requestScreenRecording();
                }
            } else {
                requestScreenShot(intent);
            }
        }
    }

    private void requestScreenShot(Intent intent) {
        if (InstabugMediaProjectionIntent.isMediaProjectionIntentReadyToUse()) {
            if (!isInitial) {
                intent = new Intent();
                intent.putExtra(KEY_IS_PERMISSION_GRANDTED, true);
                setResult(REQUEST_MEDIA_PROJECTION_PERMISSION, intent);
            }
            ScreenshotManager.INSTANCE.onActivityResult(
                    InstabugMediaProjectionIntent.getStaticResultCode(),
                    InstabugMediaProjectionIntent.getMediaProjectionIntent(),
                    isInitial,
                    screenshotCapturingListener
            );
            finish();
        } else if (InstabugMediaProjectionIntent.canStartMediaProjectionFGService(this)) {
            startActivityForResult(intent, CREATE_SCREENSHOT);
        }
    }

    private void requestScreenRecording() {
        if (InstabugMediaProjectionIntent.isMediaProjectionIntentReadyToUse()) {
            ScreenRecordingServiceData screenRecordingServiceData = new ScreenRecordingServiceData(this, InstabugMediaProjectionIntent.getStaticResultCode(), InstabugMediaProjectionIntent.getMediaProjectionIntent(), false);
            // record here
            ScreenRecordingServiceEventBus.postEvent(SEND_DATA_TO_RECORDING_SERVICE_EVENT, screenRecordingServiceData);

            finish();
        } else if (InstabugMediaProjectionIntent.canStartMediaProjectionFGService(this)) {
            MediaProjectionManager manager = (MediaProjectionManager) getSystemService(MEDIA_PROJECTION_SERVICE);
            Intent screenCaptureIntent = manager.createScreenCaptureIntent();
            startActivityForResult(screenCaptureIntent, CREATE_SCREEN_CAPTURE);
        }
    }

    private void requestAudioRecordingPermission() {
        boolean isAudioPermissionGranted = ContextCompat.checkSelfPermission(this,
                Manifest.permission.RECORD_AUDIO) == PackageManager.PERMISSION_GRANTED;

        if (!isAudioPermissionGranted) {
            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.RECORD_AUDIO},
                    REQUEST_SCREEN_RECORDING_MIC_PERMISSION);
        } else {
            requestScreenRecording();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            if (requestCode == CREATE_SCREEN_CAPTURE) {
                if (resultCode == RESULT_OK) {
                    setStaticIntentData(data);
                    setStaticResultCode(resultCode);
                    ScreenRecordingServiceData screenRecordingServiceData = new ScreenRecordingServiceData(this, InstabugMediaProjectionIntent.getStaticResultCode(), InstabugMediaProjectionIntent.getMediaProjectionIntent(), false);
                    ScreenRecordingServiceEventBus.postEvent(SEND_DATA_TO_RECORDING_SERVICE_EVENT, screenRecordingServiceData);
                } else if (resultCode == RESULT_CANCELED) {
                    SettingsManager.getInstance().setAutoScreenRecordingDenied(true);
                    ScreenRecordingEventBus.getInstance().post(new ScreenRecordingEvent(ScreenRecordingEvent.RECORDING_PERMISSION_DENIED, null));
                }
            } else if (requestCode == CREATE_SCREENSHOT) {
                if (resultCode == RESULT_OK) {
                    setStaticIntentData(data);
                    setStaticResultCode(resultCode);
                    SettingsManager.getInstance().setProcessingForeground(true);
                    if (!isInitial) {
                        Intent intent = new Intent();
                        intent.putExtra(KEY_IS_PERMISSION_GRANDTED, true);
                        setResult(REQUEST_MEDIA_PROJECTION_PERMISSION, intent);
                    }
                    ScreenshotManager.INSTANCE.onActivityResult(resultCode, data, isInitial, screenshotCapturingListener);
                } else if (screenshotCapturingListener != null) {
                    screenshotCapturingListener.onCapturingFailure(new Exception("User declined media-projection permission"));
                }
            }
        } catch (Exception e) {
            if (screenshotCapturingListener != null) {
                screenshotCapturingListener.onCapturingFailure(e);
            }
            InstabugSDKLogger.e(Constants.LOG_TAG, "something went wrong while request media-projection permission " + e.getMessage());
        } finally {
            finish();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions,
                                           int[] grantResults) {

        if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            switch (requestCode) {
                case REQUEST_SCREEN_RECORDING_MIC_PERMISSION:
                    requestScreenRecording();
                    break;
                default:
                    super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        } else {
            if (requestCode == REQUEST_SCREEN_RECORDING_MIC_PERMISSION) {
                requestScreenRecording();
            }
        }
    }

    @Override
    public void finish() {
        super.finish();
        overridePendingTransition(0, 0);
    }

    @Override
    public void onSDKInvoked(boolean isInvoked) {
        if (isInvoked) {
            finish();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(getApplicationContext()).registerReceiver
                (sdkInvokedBroadcast,
                        new IntentFilter(SDKInvokedBroadcast.SDK_INVOKED));
    }

    @Override
    protected void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance(getApplicationContext()).unregisterReceiver
                (sdkInvokedBroadcast);
    }

    @Override
    protected void onStart() {
        super.onStart();
        SettingsManager.getInstance().setRequestPermissionScreenShown(true);
    }

    @Override
    protected void onStop() {
        super.onStop();
        SettingsManager.getInstance().setRequestPermissionScreenShown(false);
        finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        RequestPermissionActivity.screenshotCapturingListener = null;
    }


}
