package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import androidx.annotation.VisibleForTesting
import com.instabug.library.core.InstabugCore

/**
 * This class is responsible of DB migration when DB version changes
 **/
object MigrationEngine {

    @JvmStatic
    fun onCreate(db: SQLiteDatabase) {
        DBDestructiveMigration(db).createDBTables()
    }

    @JvmStatic
    fun onUpgrade(db: SQLiteDatabase?, oldVersion: Int) {
        db?.let {
            try {
                getTargetMigration(it).migrate(oldVersion)
            } catch (e: Exception) {
                DBDestructiveMigration(db).migrate()
                InstabugCore.reportError(e, "Couldn't run migration on DB version $oldVersion")
            }
        }
    }

    @JvmStatic
    fun onDowngrade(db: SQLiteDatabase) {
        DBDestructiveMigration(db).migrate()
    }

    // ---- ONLY change the returned migration here ---- //
    @VisibleForTesting
    fun getTargetMigration(it: SQLiteDatabase) = DBMigrationV18(it)
}
