package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.*
import com.instabug.library.model.common.SessionVersion

private const val ALTER_TABLE_QUERY = "ALTER TABLE %s ADD COLUMN %s%s DEFAULT NULL"

class Migration_37_38 : Migration {
    override fun migrate(db: SQLiteDatabase?) {
        db?.apply {
            addUUIDToANRs()
            addUUIDToCrashes()
            addUUIDToNDK()
            execSQL(
                "ALTER TABLE ${APMSessionEntry.TABLE_NAME} " +
                        "ADD COLUMN ${APMSessionEntry.COLUMN_CORE_VERSION} " +
                        "$TEXT_TYPE DEFAULT '${SessionVersion.V2}'"
            )
        }
    }

    private fun SQLiteDatabase.addUUIDToANRs() =
        ALTER_TABLE_QUERY.format(
            AnrEntry.TABLE_NAME,
            AnrEntry.COLUMN_UUID,
            TEXT_TYPE
        ).let { query -> execSQL(query) }

    private fun SQLiteDatabase.addUUIDToCrashes() =
        ALTER_TABLE_QUERY.format(
            CrashEntry.TABLE_NAME,
            CrashEntry.COLUMN_UUID,
            TEXT_TYPE
        ).let { query -> execSQL(query) }

    private fun SQLiteDatabase.addUUIDToNDK() =
        ALTER_TABLE_QUERY.format(
            NDKCrashEntry.TABLE_NAME,
            NDKCrashEntry.COLUMN_UUID,
            TEXT_TYPE
        ).let { query -> execSQL(query) }
}
