package com.instabug.library.internal.storage.cache.db;

import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_12;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_14;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_15;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_16;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_17;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_18;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_19;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_20;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_21;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_22;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_23;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_24;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_25;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_26;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_27;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_28;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_29;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_30;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_31;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_32;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_33;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_34;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_35;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_36;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_37;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_38;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_39;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_40;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_41;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_42;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_43;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_44;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_45;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_46;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_47;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_48;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_49;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_50;
import static com.instabug.library.internal.storage.cache.db.InstabugDBVersions.DATABASE_VERSION_51;

import android.database.sqlite.SQLiteDatabase;

import com.instabug.library.Constants;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.db.migrations.CompositeMigration;
import com.instabug.library.internal.storage.cache.db.migrations.DestructiveMigration;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_12_14;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_14_15;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_15_16;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_17_18;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_18_19;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_19_20;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_20_21;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_21_22;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_22_23;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_23_24;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_24_25;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_25_26;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_26_27;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_27_28;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_28_29;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_29_30;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_30_31;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_31_32;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_32_33;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_33_34;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_34_35;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_35_36;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_36_37;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_37_38;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_38_39;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_39_40;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_40_41;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_41_42;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_42_43;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_43_44;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_44_45;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_45_46;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_46_47;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_47_48;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_48_49;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_49_50;
import com.instabug.library.internal.storage.cache.db.migrations.Migration_50_51;
import com.instabug.library.util.InstabugSDKLogger;

/**
 * Responsible for determining which migration should be run. It can handle can handle more than
 * 1 version (e.g. migrate from 3 to 4 and 4 to 5). If there are no migrations provided it will
 * fallback to a {@link DestructiveMigration}
 * <p>
 * Schemas are defined in {@link InstabugDbContract}. Any changes to these schemas will require
 * a migration.
 *
 * @see InstabugDBVersions
 */

public class MigrationEngine {


    public static void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        /*
         * FIXME: remove this condition after removing old migration method
         * @see {@link InstabugDbHelper#updateTablesOnSchemaChanges(SQLiteDatabase, int, int)}
         */
        if (oldVersion < DATABASE_VERSION_17 && newVersion <= DATABASE_VERSION_17) return;
        try {
            InstabugSDKLogger.d(Constants.LOG_TAG, "Migrating database from v" + oldVersion + " to v" + newVersion);
            switch (newVersion) {
                case DATABASE_VERSION_14:
                    upgradeTo_v14(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_15:
                    upgradeTo_v15(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_16:
                    upgradeTo_v16(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_18:
                    upgradeTo_v18(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_19:
                    upgradeTo_v19(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_20:
                    upgradeTo_v20(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_21:
                    upgradeTo_v21(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_22:
                    upgradeTo_v22(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_23:
                    upgradeTo_v23(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_24:
                    upgradeTo_v24(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_25:
                    upgradeTo_v25(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_26:
                    upgradeTo_V26(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_27:
                    upgradeTo_V27(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_28:
                    upgradeTo_V28(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_29:
                    upgradeTo_v29(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_30:
                    upgradeToV30(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_31:
                    upgradeToV31(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_32:
                    upgradeToV32(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_33:
                    upgradeToV33(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_34:
                    upgradeToV34(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_35:
                    upgradeToV35(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_36:
                    upgradeToV36(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_37:
                    upgradeToV37(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_38:
                    upgradeToV38(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_39:
                    upgradeToV39(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_40:
                    upgradeToV40(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_41:
                    upgradeToV41(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_42:
                    upgradeToV42(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_43:
                    upgradeToV43(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_44:
                    upgradeToV44(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_45:
                    upgradeToV45(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_46:
                    upgradeToV46(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_47:
                    upgradeToV47(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_48:
                    upgradeToV48(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_49:
                    upgradeToV49(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_50:
                    upgradeToV50(db, oldVersion, newVersion);
                    break;
                case DATABASE_VERSION_51:
                    upgradeToV51(db, oldVersion, newVersion);
                    break;
                default:
                    fallbackToDestructiveMigration(db, oldVersion, newVersion);
            }
        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, e.getClass().getSimpleName(), e);
            IBGDiagnostics.reportNonFatal(e, "Error while running database migration from version: " + oldVersion + " to version: " + newVersion);
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    static void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        fallbackToDestructiveMigration(db, oldVersion, newVersion);
    }

    private static void upgradeTo_v14(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion == DATABASE_VERSION_12) {
            new Migration_12_14().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeTo_v15(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new Migration_14_15().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeTo_v16(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new Migration_15_16().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeTo_v18(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18())
                        .migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18())
                        .migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18())
                        .migrate(db);
                break;
            case DATABASE_VERSION_17:
                new Migration_17_18().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeTo_v19(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new Migration_18_19().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeTo_v20(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new Migration_19_20().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeTo_v21(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21()

                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new Migration_20_21()
                        .migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeTo_v22(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(new Migration_20_21(), new Migration_21_22())
                        .migrate(db);
                break;
            case DATABASE_VERSION_21:
                new Migration_21_22().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeTo_v23(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new Migration_22_23().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeTo_v24(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new Migration_23_24().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeTo_v25(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new Migration_24_25().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }

    }

    private static void upgradeTo_V26(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new CompositeMigration(
                        new Migration_24_25(),
                        new Migration_25_26())
                        .migrate(db);
                break;
            case DATABASE_VERSION_25:
                new Migration_25_26().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }

    }

    private static void upgradeTo_V27(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new CompositeMigration(
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_25:
                new CompositeMigration(
                        new Migration_25_26(),
                        new Migration_26_27()
                ).migrate(db);
                break;
            case DATABASE_VERSION_26:
                new Migration_26_27().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }

    }

    private static void upgradeTo_V28(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new CompositeMigration(
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28())
                        .migrate(db);
                break;
            case DATABASE_VERSION_25:
                new CompositeMigration(
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28()).migrate(db);
                break;
            case DATABASE_VERSION_26:
                new CompositeMigration(
                        new Migration_26_27(),
                        new Migration_27_28())
                        .migrate(db);
                break;
            case DATABASE_VERSION_27:
                new Migration_27_28()
                        .migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }

    }

    private static void upgradeTo_v29(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new CompositeMigration(
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_25:
                new CompositeMigration(
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_26:
                new CompositeMigration(
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_27:
                new CompositeMigration(
                        new Migration_27_28(),
                        new Migration_28_29()
                ).migrate(db);
                break;
            case DATABASE_VERSION_28:
                new Migration_28_29().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV30(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new CompositeMigration(
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_25:
                new CompositeMigration(
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_26:
                new CompositeMigration(
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_27:
                new CompositeMigration(
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30()
                ).migrate(db);
                break;
            case DATABASE_VERSION_28:
                new CompositeMigration(new Migration_28_29(),
                        new Migration_29_30()).migrate(db);
                break;
            case DATABASE_VERSION_29:
                new Migration_29_30().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV31(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new CompositeMigration(
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_25:
                new CompositeMigration(
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_26:
                new CompositeMigration(
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_27:
                new CompositeMigration(
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()
                ).migrate(db);
                break;
            case DATABASE_VERSION_28:
                new CompositeMigration(
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31()).migrate(db);
                break;
            case DATABASE_VERSION_29:
                new CompositeMigration(new Migration_29_30(),
                        new Migration_30_31()).migrate(db);
                break;
            case DATABASE_VERSION_30:
                new Migration_30_31().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV32(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new CompositeMigration(
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_25:
                new CompositeMigration(
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_26:
                new CompositeMigration(
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_27:
                new CompositeMigration(
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_28:
                new CompositeMigration(
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_29:
                new CompositeMigration(new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_30:
                new CompositeMigration(new Migration_30_31(), new Migration_31_32()
                ).migrate(db);
                break;
            case DATABASE_VERSION_31:
                new Migration_31_32().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV33(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new CompositeMigration(
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_25:
                new CompositeMigration(
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_26:
                new CompositeMigration(
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_27:
                new CompositeMigration(
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_28:
                new CompositeMigration(
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_29:
                new CompositeMigration(
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_30:
                new CompositeMigration(
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_31:
                new CompositeMigration(
                        new Migration_31_32(),
                        new Migration_32_33()
                ).migrate(db);
                break;
            case DATABASE_VERSION_32:
                new Migration_32_33().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV34(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new CompositeMigration(
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_25:
                new CompositeMigration(
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_26:
                new CompositeMigration(
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_27:
                new CompositeMigration(
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_28:
                new CompositeMigration(
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_29:
                new CompositeMigration(
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_30:
                new CompositeMigration(
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_31:
                new CompositeMigration(
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34()
                ).migrate(db);
                break;
            case DATABASE_VERSION_32:
                new CompositeMigration(
                        new Migration_32_33(),
                        new Migration_33_34())
                        .migrate(db);
                break;
            case DATABASE_VERSION_33:
                new Migration_33_34().migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV35(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case DATABASE_VERSION_12:
                new CompositeMigration(
                        new Migration_12_14(),
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_14:
                new CompositeMigration(
                        new Migration_14_15(),
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_15:
                new CompositeMigration(
                        new Migration_15_16(),
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_17:
                new CompositeMigration(
                        new Migration_17_18(),
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_18:
                new CompositeMigration(
                        new Migration_18_19(),
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_19:
                new CompositeMigration(
                        new Migration_19_20(),
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_20:
                new CompositeMigration(
                        new Migration_20_21(),
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_21:
                new CompositeMigration(
                        new Migration_21_22(),
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_22:
                new CompositeMigration(
                        new Migration_22_23(),
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_23:
                new CompositeMigration(
                        new Migration_23_24(),
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_24:
                new CompositeMigration(
                        new Migration_24_25(),
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_25:
                new CompositeMigration(
                        new Migration_25_26(),
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_26:
                new CompositeMigration(
                        new Migration_26_27(),
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_27:
                new CompositeMigration(
                        new Migration_27_28(),
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_28:
                new CompositeMigration(
                        new Migration_28_29(),
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_29:
                new CompositeMigration(
                        new Migration_29_30(),
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_30:
                new CompositeMigration(
                        new Migration_30_31(),
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_31:
                new CompositeMigration(
                        new Migration_31_32(),
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_32:
                new CompositeMigration(
                        new Migration_32_33(),
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_33:
                new CompositeMigration(
                        new Migration_33_34(),
                        new Migration_34_35()
                ).migrate(db);
                break;
            case DATABASE_VERSION_34:
                new CompositeMigration(
                        new Migration_34_35()
                ).migrate(db);
                break;
            default:
                fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV36(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= 12 && oldVersion <= 34) {
            upgradeToV35(db, oldVersion, newVersion);
            new Migration_35_36().migrate(db);
        } else if (oldVersion == 35) {
            new Migration_35_36().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV37(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= 12 && oldVersion <= 35) {
            upgradeToV36(db, oldVersion, newVersion);
            new Migration_36_37().migrate(db);
        } else if (oldVersion == 36) {
            new Migration_36_37().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV38(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_36) {
            upgradeToV37(db, oldVersion, newVersion);
            new Migration_37_38().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_37) {
            new Migration_37_38().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV39(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_37) {
            upgradeToV38(db, oldVersion, newVersion);
            new Migration_38_39().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_38) {
            new Migration_38_39().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV40(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_38) {
            upgradeToV39(db, oldVersion, newVersion);
            new Migration_39_40().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_39) {
            new Migration_39_40().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV41(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_39) {
            upgradeToV40(db, oldVersion, newVersion);
            new Migration_40_41().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_40) {
            new Migration_40_41().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV42(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_40) {
            upgradeToV41(db, oldVersion, newVersion);
            new Migration_41_42().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_41) {
            new Migration_41_42().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV43(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_41) {
            upgradeToV42(db, oldVersion, newVersion);
            new Migration_42_43().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_42) {
            new Migration_42_43().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV44(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_42) {
            upgradeToV43(db, oldVersion, newVersion);
            new Migration_43_44().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_43) {
            new Migration_43_44().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV45(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_43) {
            upgradeToV44(db, oldVersion, newVersion);
            new Migration_44_45().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_44) {
            new Migration_44_45().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV46(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_44) {
            upgradeToV45(db, oldVersion, newVersion);
            new Migration_45_46().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_45) {
            new Migration_45_46().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV47(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_45) {
            upgradeToV46(db, oldVersion, newVersion);
            new Migration_46_47().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_46) {
            new Migration_46_47().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV48(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_46) {
            upgradeToV47(db, oldVersion, newVersion);
            new Migration_47_48().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_47) {
            new Migration_47_48().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV49(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_47) {
            upgradeToV48(db, oldVersion, newVersion);
            new Migration_48_49().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_48) {
            new Migration_48_49().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV50(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_48) {
            upgradeToV49(db, oldVersion, newVersion);
            new Migration_49_50().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_49) {
            new Migration_49_50().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }

    private static void upgradeToV51(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion >= DATABASE_VERSION_12 && oldVersion <= DATABASE_VERSION_49) {
            upgradeToV50(db, oldVersion, newVersion);
            new Migration_50_51().migrate(db);
        } else if (oldVersion == DATABASE_VERSION_50) {
            new Migration_50_51().migrate(db);
        } else {
            fallbackToDestructiveMigration(db, oldVersion, newVersion);
        }
    }


    private static void fallbackToDestructiveMigration(SQLiteDatabase db, int oldVersion, int newVersion) {
        InstabugSDKLogger.e(Constants.LOG_TAG,
                "Did not migrate from v" + oldVersion + " to v" + newVersion + ". "
                        + "Falling back to destructive migration");
        new DestructiveMigration().migrate(db);
    }
}
