package com.instabug.library.internal.storage.cache.db;

import android.annotation.SuppressLint;
import android.content.Context;

import androidx.annotation.VisibleForTesting;

import com.instabug.library.Constants;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;

/**
 * Created by Tarek360 on 2/28/17.
 */

public class DatabaseManager {

    private static DatabaseManager instance;

    private static SQLiteDatabaseWrapper databaseWrapper;

    @VisibleForTesting
    public static synchronized void init(Context context) {
        if (instance == null) {
            instance = new DatabaseManager();
            databaseWrapper = new SQLiteDatabaseWrapper(InstabugDbHelper.getInstance(context));
        }
    }

    @SuppressLint("RESOURCE_LEAK")
    public static synchronized DatabaseManager getInstance() throws IllegalStateException {
        if (instance == null) {
            if (Instabug.getApplicationContext() != null) {
                InstabugSDKLogger.v(Constants.LOG_TAG, "Initializing database manager");
                DatabaseManager.init(Instabug.getApplicationContext());
            } else {
                // todo fix me (https://instabug.atlassian.net/browse/MOB-6262)
                throw new IllegalStateException(DatabaseManager.class.getSimpleName()
                        + " is not initialized, call init(..) method first.");
            }
        }
        return instance;
    }

    public synchronized SQLiteDatabaseWrapper openDatabase() {
        databaseWrapper.open();
        return databaseWrapper;
    }

    @SuppressLint("ERADICATE_FIELD_NOT_NULLABLE")
    @VisibleForTesting
    public static synchronized void tearDown() {
        if (databaseWrapper != null) {
            databaseWrapper.closeDB();
            databaseWrapper = null;
        }
        instance = null;
    }

    public static synchronized void clearAll() {
        SQLiteDatabaseWrapper sqLiteDatabase = getInstance().openDatabase();
        sqLiteDatabase.execSQL(InstabugDbContract.AttachmentEntry.DELETE_ALL);
        sqLiteDatabase.execSQL(InstabugDbContract.CrashEntry.DELETE_ALL);
        sqLiteDatabase.execSQL(InstabugDbContract.ExperimentsEntry.DELETE_ALL);
    }

    public synchronized boolean deleteDatabase(Context context) {
        return databaseWrapper.deleteDatabase(context);
    }
}
