package com.instabug.library.internal.dataretention.files;

import com.instabug.library.internal.dataretention.core.Record;
import com.instabug.library.util.TimeUtils;

import java.io.File;

import androidx.annotation.NonNull;

public class FileRecord implements Record<File> {

    private final File file;

    public FileRecord(@NonNull File file) {
        this.file = file;
    }

    @NonNull
    @Override
    public File get() {
        return file;
    }

    public long getAge() {
        return TimeUtils.currentTimeMillis() - file.lastModified();
    }
}
