package com.instabug.library.diagnostics.sdkEvents.mappers

import com.instabug.library.diagnostics.mappers.DiagnosticsRequestParam
import com.instabug.library.diagnostics.mappers.RequestParameterResolver
import com.instabug.library.diagnostics.sdkEvents.cache.SDKEventsCachingManager
import com.instabug.library.diagnostics.sdkEvents.configurations.SDKEventConfigs
import com.instabug.library.diagnostics.sdkEvents.configurations.SDKEventConfigs.Companion.SDK_EVENTS_KEY
import com.instabug.library.diagnostics.sdkEvents.di.SDKEventsServiceLocator
import com.instabug.library.networkv2.request.RequestParameter
import org.json.JSONArray

internal class SDKEventsRequestParameterResolver : RequestParameterResolver<JSONArray> {

    private val sdkEventsCachingManager: SDKEventsCachingManager
        get() = SDKEventsServiceLocator.sdkEventsCachingManager
    private val sdkEventConfigs: SDKEventConfigs
        get() = SDKEventsServiceLocator.sdkEventConfigs

    override fun toRequestParameter(): DiagnosticsRequestParam<JSONArray> =
        synchronized(SDK_EVENTS_KEY) {
            getSDKEvents().let {
                RequestParameter(SDK_EVENTS_KEY, it ?: JSONArray()) to (it == null)
            }
        }

    private fun getSDKEvents() = sdkEventsCachingManager
        .takeIf { sdkEventConfigs.isEnabled }
        ?.getAllEvents()
        ?.takeUnless { it.isEmpty() }
        ?.filter { it.count > 0 }
        ?.let(::sdkEventsToJsonArray)
}