package com.instabug.library.core

import androidx.annotation.VisibleForTesting
import com.instabug.library.InstabugState
import com.instabug.library.core.eventbus.InstabugStateEventBus
import com.instabug.library.diagnostics.customtraces.IBGPendingTraceHandler
import io.reactivexport.disposables.Disposable

object IBGStateEventBusSubscriber {

    var disposable: Disposable? = null

    @JvmStatic
    fun subscribeToIBGState() {
        if(disposable == null) {
            disposable = InstabugStateEventBus.getInstance().subscribe {
                handleIBGState(it)
            }
        }
    }

    @VisibleForTesting
    fun handleIBGState(state: InstabugState) {
        when(state) {
            InstabugState.ENABLED -> {
                IBGPendingTraceHandler.flushTraces()
            }
            else -> return
        }
    }

    @JvmStatic
    fun unsubscribeFromIBGState() {
        disposable?.dispose()
        disposable = null
    }
}