/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.d;
import com.instabug.library.datahub.c;
import com.instabug.library.datahub.g;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.filestore.j;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.sessionreplay.model.a;
import com.instabug.library.sessionreplay.model.b;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InstabugLog {
    public static final int INSTABUG_LOG_LIMIT = 1000;

    public static void v(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.v", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.V).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void d(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.d", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.D).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void i(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.i", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.I).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void e(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.e", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.E).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void w(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.w", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.W).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void wtf(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.wtf", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.WTF).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void clearLogs() {
        InstabugLog.clearLogMessages();
    }

    public static String getLogs() {
        return InstabugLog.getLogMessages();
    }

    private static synchronized void addLog(LogMessage logMessage) {
        LogMessage logMessage2;
        CoreServiceLocator.getIbgLogsDistributor().invoke(logMessage2);
    }

    private static void clearLogMessages() {
        CoreServiceLocator.getIbgLogStore().clear();
    }

    private static String getLogMessages() {
        String string2;
        block6: {
            com.instabug.library.internal.filestore.a a5;
            string2 = "[]";
            g g5 = CoreServiceLocator.getIbgLogStore();
            j j5 = new j();
            com.instabug.library.internal.filestore.a a6 = a5;
            a5 = new com.instabug.library.internal.filestore.a();
            a6 = (JSONArray)g5.a(j5, a6).get();
            if (a6 == null) break block6;
            try {
                string2 = a6.toString();
            }
            catch (ExecutionException executionException) {
                InstabugCore.reportError(executionException, "Error retrieving log messages from store");
                InstabugSDKLogger.e("IBG-Core", "Error retrieving log messages from store", executionException);
            }
            catch (InterruptedException interruptedException) {
                InstabugSDKLogger.e("IBG-Core", "Error while getting log messages", interruptedException);
                Thread.currentThread().interrupt();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugCore.reportError(outOfMemoryError, "Couldn't parse Instabug logs due to an OOM");
                InstabugSDKLogger.e("IBG-Core", "Couldn't parse Instabug logs due to an OOM", outOfMemoryError);
            }
        }
        return string2;
    }

    private static long getDate() {
        return InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds();
    }

    private static boolean isInstabugLogsDisabled() {
        return d.c().b((Object)"INSTABUG_LOGS") == Feature.State.DISABLED;
    }

    public static class LogMessage
    implements a,
    c {
        static final String KEY_LOG_MESSAGE = "log_message";
        static final String KEY_LOG_MESSAGE_LEVEL = "log_message_level";
        static final String KEY_LOG_MESSAGE_DATE = "log_message_date";
        public static final String FAILED_TO_PARSE_INSTABUG_LOG_TO_JSON = "Failed to parse Instabug Log to JSON:";
        public static final String TRIMMING_SUSFIX = "...";
        public static final String NULL_LOG = "null";
        @Nullable
        private String logMessage;
        @Nullable
        private LogLevel logMessageLevel;
        private long logMessageDate;

        @NonNull
        private String validateSize(@Nullable String logMessage) {
            String string2;
            if (logMessage == null) {
                return NULL_LOG;
            }
            int n5 = b.a(this);
            if (string2.length() > n5) {
                string2 = string2.substring(0, n5) + TRIMMING_SUSFIX;
            }
            return string2;
        }

        /*
         * WARNING - void declaration
         */
        public static LogMessage generateLogMessage(String message, LogLevel level) {
            void var1_1;
            String string2;
            return new LogMessage().setLogMessage(string2).setLogMessageLevel((LogLevel)var1_1).setLogMessageDate(InstabugLog.getDate());
        }

        @Nullable
        String getLogMessage() {
            return this.logMessage;
        }

        /*
         * WARNING - void declaration
         */
        LogMessage setLogMessage(String logMessage) {
            void var1_1;
            LogMessage logMessage2 = this;
            logMessage2.logMessage = logMessage2.validateSize((String)var1_1);
            return logMessage2;
        }

        @Nullable
        LogLevel getLogMessageLevel() {
            return this.logMessageLevel;
        }

        /*
         * WARNING - void declaration
         */
        LogMessage setLogMessageLevel(LogLevel logMessageLevel) {
            void var1_1;
            this.logMessageLevel = var1_1;
            return this;
        }

        long getLogMessageDate() {
            return this.logMessageDate;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        public LogMessage setLogMessageDate(long logMessageDate) {
            void var1_1;
            this.logMessageDate = var1_1;
            return this;
        }

        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public JSONObject toJson() {
            JSONObject jSONObject;
            block8: {
                JSONObject jSONObject2;
                jSONObject = jSONObject2;
                jSONObject();
                String string2 = KEY_LOG_MESSAGE;
                jSONObject2.put(string2, (Object)((LogMessage)((Object)this_)).getLogMessage());
                if (((LogMessage)((Object)this_)).getLogMessageLevel() == null) break block8;
                jSONObject.put(KEY_LOG_MESSAGE_LEVEL, (Object)((LogMessage)((Object)this_)).getLogMessageLevel().toString());
            }
            JSONObject jSONObject3 = jSONObject;
            LogMessage logMessage = this_;
            String this_ = KEY_LOG_MESSAGE_DATE;
            long l5 = logMessage.getLogMessageDate();
            try {
                jSONObject3.put(this_, l5);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e("IBG-Core", "Error while parsing instabug logs", jSONException);
            }
            return jSONObject;
        }

        public long getTimestamp() {
            return this.getLogMessageDate();
        }

        @Override
        @NonNull
        public String getLogType() {
            return "IBG_LOG";
        }

        @Override
        @Nullable
        public JSONObject getSrJsonRep() {
            String string2;
            LogMessage logMessage;
            JSONObject jSONObject;
            JSONObject jSONObject2;
            try {
                JSONObject jSONObject3 = ((LogMessage)((Object)this_)).toJson();
                jSONObject2 = jSONObject3;
                jSONObject = jSONObject3;
                logMessage = this_;
                string2 = "log_type";
            }
            catch (JSONException jSONException) {
                IBGDiagnostics.reportNonFatalAndLog(jSONException, FAILED_TO_PARSE_INSTABUG_LOG_TO_JSON, "IBG-Core");
                return null;
            }
            JSONObject jSONObject4 = jSONObject2.put(string2, (Object)logMessage.getLogType());
            LogMessage logMessage2 = this_;
            String this_ = "timestamp";
            long l5 = logMessage2.getTimestamp();
            jSONObject4.put(this_, l5);
            return jSONObject;
        }

        @Override
        @Nullable
        public JSONObject getDataHubRep() {
            return this.toJson();
        }
    }

    public static final class LogLevel
    extends Enum<LogLevel> {
        public static final /* enum */ LogLevel V;
        public static final /* enum */ LogLevel D;
        public static final /* enum */ LogLevel I;
        public static final /* enum */ LogLevel E;
        public static final /* enum */ LogLevel W;
        public static final /* enum */ LogLevel WTF;
        private static final /* synthetic */ LogLevel[] $VALUES;
        private final String level;

        public static LogLevel[] values() {
            return (LogLevel[])$VALUES.clone();
        }

        public static LogLevel valueOf(String name) {
            String string2;
            return Enum.valueOf(LogLevel.class, string2);
        }

        /*
         * WARNING - void declaration
         */
        private LogLevel(String level) {
            void var3_3;
            this.level = var3_3;
        }

        static {
            LogLevel logLevel;
            LogLevel logLevel2;
            LogLevel logLevel3;
            LogLevel logLevel4;
            LogLevel logLevel5;
            LogLevel logLevel6;
            LogLevel logLevel7 = logLevel6;
            V = new LogLevel("v");
            LogLevel logLevel8 = logLevel5;
            D = new LogLevel("d");
            LogLevel logLevel9 = logLevel4;
            I = new LogLevel("i");
            LogLevel logLevel10 = logLevel3;
            E = new LogLevel("e");
            LogLevel logLevel11 = logLevel2;
            W = new LogLevel("w");
            LogLevel logLevel12 = logLevel;
            WTF = new LogLevel("wtf");
            $VALUES = new LogLevel[]{logLevel7, logLevel8, logLevel9, logLevel10, logLevel11, logLevel12};
        }

        @NonNull
        public String toString() {
            return this.level;
        }
    }
}

