/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.model.ConsoleLog;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Report {
    private static final int ITEMS_LIST_LIMIT = 10;
    private static final int FILES_LIST_LIMIT = 3;
    private ArrayList<String> tags;
    private ArrayList<ConsoleLog> consoleLogs;
    private ArrayList<InstabugLog.LogMessage> instabugLogs;
    @Nullable
    private String userData;
    private HashMap<String, String> userAttributes;
    private HashMap<Uri, String> fileAttachments;

    public Report() {
        HashMap hashMap;
        HashMap hashMap2;
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        Object this_ = arrayList3;
        arrayList3 = new ArrayList();
        v1.tags = this_;
        this_ = arrayList2;
        arrayList2 = new ArrayList();
        v1.consoleLogs = this_;
        this_ = arrayList;
        arrayList = new ArrayList();
        v1.instabugLogs = this_;
        this_ = hashMap2;
        hashMap2 = new HashMap();
        v1.userAttributes = this_;
        this_ = hashMap;
        hashMap = new HashMap();
        v1.fileAttachments = this_;
    }

    public ArrayList<InstabugLog.LogMessage> getInstabugLogs() {
        return this.instabugLogs;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstabugLogs(ArrayList<InstabugLog.LogMessage> instabugLogs) {
        void var1_1;
        this.instabugLogs = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addTag(String ... tag) {
        void var1_1;
        int n5;
        if (tag == null) {
            return;
        }
        for (n5 = 0; this.tags.size() < 10 && n5 < ((void)var1_1).length; ++n5) {
            this.tags.add((String)var1_1[n5]);
        }
        if (n5 < ((void)var1_1).length) {
            InstabugSDKLogger.w("IBG-Core", "Some tags were ignored. Maximum allowed tags count reached. Please note that you can add up to 10 tags.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addTag(ArrayList<String> tags) {
        void var1_1;
        int n5;
        if (tags == null) {
            return;
        }
        for (n5 = 0; this.tags.size() < 10 && n5 < var1_1.size(); ++n5) {
            this.tags.add((String)var1_1.get(n5));
        }
        if (n5 < var1_1.size()) {
            InstabugSDKLogger.w("IBG-Core", "Some tags were ignored. Maximum allowed tags count reached. Please note that you can add up to 10 tags.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) {
        if (this.fileAttachments.size() < 3) {
            void var2_2;
            void var1_1;
            this.fileAttachments.put((Uri)var1_1, (String)var2_2);
        } else {
            InstabugSDKLogger.w("IBG-Core", "File was ignored. Maximum allowed files count reached. Please note that you can add up to 10 files.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) {
        void var2_2;
        Uri uri;
        if (this.fileAttachments.size() >= 3) {
            InstabugSDKLogger.w("IBG-Core", "File was ignored. Maximum allowed files count reached. Please note that you can add up to 10 files.");
            return;
        }
        Context context = Instabug.getApplicationContext();
        if (context != null && AttachmentsUtility.isValidSize(((void)uri).length, 5.0) && (uri = AttachmentsUtility.getUriFromBytes(context, (byte[])uri, (String)var2_2)) != null) {
            this.fileAttachments.put(uri, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUserAttribute(@NonNull String key, String value) {
        void var2_2;
        void var1_1;
        if (this.userAttributes.size() >= 10) {
            InstabugSDKLogger.w("IBG-Core", "User attribute was ignored. Maximum allowed attributes count reached. Please note that you can add up to 10 user attributes.");
            return;
        }
        this.userAttributes.put((String)var1_1, (String)var2_2);
    }

    public void addUserAttributes(HashMap<String, String> userAttributes) {
        Iterator iterator;
        if (userAttributes == null) {
            return;
        }
        iterator = ((HashMap)((Object)iterator)).entrySet().iterator();
        while (this.userAttributes.size() < 10 && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null) continue;
            this.userAttributes.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (iterator.hasNext()) {
            InstabugSDKLogger.w("IBG-Core", "Some attributes were ignored. Maximum allowed attributes count reached. Please note that you can add up to 10 user attributes.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void appendToConsoleLogs(String logMessage) {
        void var1_1;
        ConsoleLog consoleLog;
        if (((Report)((Object)this_)).consoleLogs.size() >= 10) {
            InstabugSDKLogger.w("IBG-Core", "Console log was ignored. Maximum allowed logs count reached. Please note that you can add up to 10 log messages.");
            return;
        }
        Report report = this_;
        ConsoleLog this_ = consoleLog;
        this_();
        consoleLog.setMessage((String)var1_1);
        consoleLog.setTimeStamp(System.currentTimeMillis());
        report.consoleLogs.add(this_);
    }

    /*
     * WARNING - void declaration
     */
    public void logVerbose(String logMessage) {
        if (InstabugCore.getFeatureState("INSTABUG_LOGS") == Feature.State.ENABLED) {
            void var1_1;
            InstabugLog.v((String)var1_1);
            this.instabugLogs.add(InstabugLog.LogMessage.generateLogMessage((String)var1_1, InstabugLog.LogLevel.V));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logDebug(String logMessage) {
        if (InstabugCore.getFeatureState("INSTABUG_LOGS") == Feature.State.ENABLED) {
            void var1_1;
            InstabugLog.d((String)var1_1);
            this.instabugLogs.add(InstabugLog.LogMessage.generateLogMessage((String)var1_1, InstabugLog.LogLevel.D));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logInfo(String logMessage) {
        if (InstabugCore.getFeatureState("INSTABUG_LOGS") == Feature.State.ENABLED) {
            void var1_1;
            InstabugLog.i((String)var1_1);
            this.instabugLogs.add(InstabugLog.LogMessage.generateLogMessage((String)var1_1, InstabugLog.LogLevel.I));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logWarn(String logMessage) {
        if (InstabugCore.getFeatureState("INSTABUG_LOGS") == Feature.State.ENABLED) {
            void var1_1;
            InstabugLog.w((String)var1_1);
            this.instabugLogs.add(InstabugLog.LogMessage.generateLogMessage((String)var1_1, InstabugLog.LogLevel.W));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logError(String logMessage) {
        if (InstabugCore.getFeatureState("INSTABUG_LOGS") == Feature.State.ENABLED) {
            void var1_1;
            InstabugLog.e((String)var1_1);
            this.instabugLogs.add(InstabugLog.LogMessage.generateLogMessage((String)var1_1, InstabugLog.LogLevel.E));
        }
    }

    public List<String> getTags() {
        return this.tags;
    }

    public ArrayList<ConsoleLog> getConsoleLog() {
        return this.consoleLogs;
    }

    @Nullable
    public String getUserData() {
        return this.userData;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserData(@NonNull String userData) {
        void var1_1;
        this.userData = StringUtility.trimString((String)var1_1, 1000);
    }

    public HashMap<String, String> getUserAttributes() {
        return this.userAttributes;
    }

    public HashMap<Uri, String> getFileAttachments() {
        return this.fileAttachments;
    }

    /*
     * WARNING - void declaration
     */
    public void addConsoleLogs(ArrayList<ConsoleLog> consoleLogArrayList) {
        void var1_1;
        int n5;
        if (consoleLogArrayList == null) {
            return;
        }
        for (n5 = 0; this.consoleLogs.size() <= 10 && n5 < var1_1.size(); ++n5) {
            this.consoleLogs.add((ConsoleLog)var1_1.get(n5));
        }
        if (n5 < var1_1.size()) {
            InstabugSDKLogger.w("IBG-Core", "Some console logs were ignored. Maximum allowed logs count reached. Please note that you can add up to 10 log messages.");
        }
    }

    public static interface OnReportCreatedListener {
        public void onReportCreated(Report var1);
    }
}

