/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.dbv2;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.dbv2.IBGContentValues;
import com.instabug.library.internal.storage.cache.dbv2.IBGCursor;
import com.instabug.library.internal.storage.cache.dbv2.IBGWhereArg;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.Arrays;
import java.util.List;

public class IBGDbManager {
    @VisibleForTesting
    public static SQLiteOpenHelper dbHelper;
    @Nullable
    private static IBGDbManager instance;
    @Nullable
    private Boolean databaseTransactionsEnabled;
    @Nullable
    private SQLiteDatabase database;

    public static synchronized void init(com.instabug.library.internal.storage.cache.dbv2.a helper) {
        if (instance == null) {
            com.instabug.library.internal.storage.cache.dbv2.a a5;
            instance = new IBGDbManager();
            dbHelper = a5;
        }
    }

    @SuppressLint(value={"RESOURCE_LEAK"})
    public static synchronized IBGDbManager getInstance() throws IllegalStateException {
        if (instance == null) {
            if (Instabug.getApplicationContext() != null) {
                IBGDbManager.init(new com.instabug.library.internal.storage.cache.dbv2.a(Instabug.getApplicationContext()));
            } else {
                throw new IllegalStateException("IBG-Core is not initialized, call init(..) method first.");
            }
        }
        return instance;
    }

    private IBGDbManager() {
    }

    private synchronized void openDatabase() {
        SQLiteDatabase sQLiteDatabase = this.database;
        if (sQLiteDatabase == null || !sQLiteDatabase.isOpen()) {
            this.database = dbHelper.getWritableDatabase();
        }
    }

    private synchronized boolean databaseInitializedAndOpen() {
        IBGDbManager this_ = this_.database;
        return this_ != null && this_.isOpen();
    }

    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static synchronized void tearDown() {
        Object object = dbHelper;
        if (object != null) {
            object.close();
            dbHelper = null;
        }
        if ((object = instance) != null) {
            object = object.database;
            if (object != null) {
                object.close();
                IBGDbManager.instance.database = null;
            }
            instance = null;
        }
    }

    private synchronized boolean isDatabaseTransactionsEnabled() {
        if (((IBGDbManager)this).databaseTransactionsEnabled == null && Instabug.getApplicationContext() != null) {
            ((IBGDbManager)this).databaseTransactionsEnabled = InstabugCore.isDatabaseTransactionDisabled(Instabug.getApplicationContext()) ^ true;
        }
        return (this = ((IBGDbManager)this).databaseTransactionsEnabled) != null ? (Boolean)this : false;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void logOperationFailedWarning(String message) {
        IBGDbManager this_ = this_.database;
        if (this_ == null) {
            InstabugSDKLogger.e("IBG-Core", "Attempted to do operation on an uninitialized database. Falling back silently");
        } else if (!this_.isOpen()) {
            InstabugSDKLogger.e("IBG-Core", "Attempted to do operation on a closed database. Falling back silently");
        } else {
            void var1_1;
            InstabugSDKLogger.w("IBG-Core", (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(IBGDbManager x02, String x12) {
        void var1_1;
        x02.logOperationFailedWarning((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long insert(@NonNull String table, @Nullable String nullColumnHack, @NonNull IBGContentValues values) {
        void var3_3;
        void var2_2;
        void var1_1;
        Long l5 = (Long)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)l5), (String)var1_1, (String)var2_2, (IBGContentValues)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ IBGContentValues c;
            final /* synthetic */ IBGDbManager d;
            {
                void var1_1;
                this.d = var1_1;
                this.a = string2;
                this.b = string3;
                this.c = iBGContentValues;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Long a() {
                a a5 = this;
                a5.d.openDatabase();
                try {
                    if (a5.d.databaseInitializedAndOpen()) {
                        a a6 = this;
                        String string2 = a6.a;
                        String string3 = a6.b;
                        return this.d.database.insertOrThrow(string2, string3, this.c.toContentValues());
                    }
                    IBGDbManager.access$300(this.d, "DB insertion failed, database not initialized");
                    return -1L;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB insertion failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB insertion failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    return -1L;
                }
                catch (Exception exception) {
                    IBGDiagnostics.reportNonFatal(exception, "DB insertion failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB insertion failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    return -1L;
                }
            }
        });
        return l5 == null ? -1L : l5;
    }

    /*
     * WARNING - void declaration
     */
    public long insertWithOnConflict(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull IBGContentValues values) {
        void var3_3;
        void var2_2;
        void var1_1;
        Long l5 = (Long)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)l5), (String)var1_1, (String)var2_2, (IBGContentValues)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ IBGContentValues c;
            final /* synthetic */ IBGDbManager d;
            {
                void var1_1;
                this.d = var1_1;
                this.a = string2;
                this.b = string3;
                this.c = iBGContentValues;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Long a() {
                b b5 = this;
                b5.d.openDatabase();
                try {
                    if (b5.d.databaseInitializedAndOpen()) {
                        b b6 = this;
                        String string2 = b6.a;
                        String string3 = b6.b;
                        return this.d.database.insertWithOnConflict(string2, string3, this.c.toContentValues(), 4);
                    }
                    IBGDbManager.access$300(this.d, "DB insertion with on conflict failed database is not initialized");
                    return -1L;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB insertion with on conflict failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB insertion with on conflict failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    return -1L;
                }
                catch (Exception exception) {
                    IBGDiagnostics.reportNonFatal(exception, "DB insertion with on conflict failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB insertion with on conflict failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    return -1L;
                }
            }
        });
        return l5 == null ? -1L : l5;
    }

    /*
     * WARNING - void declaration
     */
    public void execSQL(@NonNull String sql, @Nullable Object[] args) {
        void var2_2;
        void var1_1;
        PoolProvider.getDatabaseExecutor().execute(new Runnable(this, (String)var1_1, (Object[])var2_2){
            final /* synthetic */ String a;
            final /* synthetic */ Object[] b;
            final /* synthetic */ IBGDbManager c;
            {
                void var1_1;
                this.c = var1_1;
                this.a = string2;
                this.b = objectArray;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                c c5 = this;
                c5.c.openDatabase();
                try {
                    if (c5.c.databaseInitializedAndOpen()) {
                        c c6 = this;
                        String string2 = c6.a;
                        this.c.database.execSQL(string2, c6.b);
                        return;
                    }
                    IBGDbManager.access$300(this.c, "DB execution a sql failed");
                    return;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB execution a sql failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    IBGDbManager.access$300(this.c, "DB execution a sql failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    return;
                }
                catch (Exception exception) {
                    IBGDiagnostics.reportNonFatal(exception, "DB execution a sql failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    IBGDbManager.access$300(this.c, "DB execution a sql failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public long insertWithOnConflictReplace(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull IBGContentValues values) {
        void var3_3;
        void var2_2;
        void var1_1;
        Long l5 = (Long)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)l5), (String)var1_1, (String)var2_2, (IBGContentValues)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ IBGContentValues c;
            final /* synthetic */ IBGDbManager d;
            {
                void var1_1;
                this.d = var1_1;
                this.a = string2;
                this.b = string3;
                this.c = iBGContentValues;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Long a() {
                d d5 = this;
                d5.d.openDatabase();
                try {
                    if (d5.d.databaseInitializedAndOpen()) {
                        d d6 = this;
                        String string2 = d6.a;
                        String string3 = d6.b;
                        return this.d.database.insertWithOnConflict(string2, string3, this.c.toContentValues(), 5);
                    }
                    IBGDbManager.access$300(this.d, "DB insertion with on conflict replace failed");
                    return -1L;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB insertion with on conflict replace failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB insertion with on conflict replace failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    return -1L;
                }
                catch (Exception exception) {
                    IBGDiagnostics.reportNonFatal(exception, "DB insertion with on conflict replace failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB insertion with on conflict replace failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    return -1L;
                }
            }
        });
        return l5 == null ? -1L : l5;
    }

    /*
     * WARNING - void declaration
     */
    public int delete(@NonNull String table, @Nullable String whereClause, @Nullable List<IBGWhereArg> whereArgs) {
        void var3_3;
        void var2_2;
        void var1_1;
        Integer n5 = (Integer)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)n5), (String)var1_1, (String)var2_2, (List)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ List c;
            final /* synthetic */ IBGDbManager d;
            {
                void var1_1;
                this.d = var1_1;
                this.a = string2;
                this.b = string3;
                this.c = list;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Integer a() {
                e e5 = this;
                e5.d.openDatabase();
                try {
                    if (e5.d.databaseInitializedAndOpen()) {
                        e e6 = this;
                        String string2 = e6.a;
                        String string3 = e6.b;
                        return this.d.database.delete(string2, string3, IBGWhereArg.argsListToStringArray(this.c));
                    }
                    IBGDbManager.access$300(this.d, "DB deletion failed");
                    return 0;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB deletion failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB deletion failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    return 0;
                }
                catch (Exception exception) {
                    IBGDiagnostics.reportNonFatal(exception, "DB deletion failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB deletion failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                }
                return 0;
            }
        });
        return n5 == null ? 0 : n5;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public IBGCursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable List<IBGWhereArg> selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return (IBGCursor)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable(this, (String)var1_1, (String[])var2_2, (String)var3_3, (List)var4_4, (String)var5_5, (String)var6_6, (String)var7_7){
            final /* synthetic */ String a;
            final /* synthetic */ String[] b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            final /* synthetic */ String e;
            final /* synthetic */ String f;
            final /* synthetic */ String g;
            final /* synthetic */ IBGDbManager h;
            {
                void var1_1;
                this.h = var1_1;
                this.a = string2;
                this.b = stringArray;
                this.c = string3;
                this.d = list;
                this.e = string4;
                this.f = string5;
                this.g = string6;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IBGCursor a() {
                f f5 = this;
                f5.h.openDatabase();
                try {
                    if (f5.h.databaseInitializedAndOpen()) {
                        f f6 = this;
                        String string2 = f6.a;
                        String[] stringArray = f6.b;
                        String string3 = f6.c;
                        String[] stringArray2 = IBGWhereArg.argsListToStringArray(f6.d);
                        String string4 = f6.e;
                        String string5 = f6.f;
                        String string6 = f6.g;
                        return new IBGCursor(this.h.database.query(string2, stringArray, string3, stringArray2, string4, string5, string6));
                    }
                    IBGDbManager.access$300(this.h, "DB query faile");
                    return null;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB query failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    IBGDbManager.access$300(this.h, "DB query faile due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    return null;
                }
                catch (Exception exception) {
                    IBGDiagnostics.reportNonFatal(exception, "DB query failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    IBGDbManager.access$300(this.h, "DB query faile due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public int update(@NonNull String table, @NonNull IBGContentValues values, @Nullable String whereClause, @Nullable List<IBGWhereArg> whereArgs) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Integer n5 = (Integer)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)n5), (String)var1_1, (IBGContentValues)var2_2, (String)var3_3, (List)var4_4){
            final /* synthetic */ String a;
            final /* synthetic */ IBGContentValues b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            final /* synthetic */ IBGDbManager e;
            {
                void var1_1;
                this.e = var1_1;
                this.a = string2;
                this.b = iBGContentValues;
                this.c = string3;
                this.d = list;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Integer a() {
                g g5 = this;
                g5.e.openDatabase();
                try {
                    if (g5.e.databaseInitializedAndOpen()) {
                        g g6 = this;
                        String[] stringArray = g6.a;
                        ContentValues contentValues = g6.b.toContentValues();
                        String string2 = g6.c;
                        String[] stringArray2 = stringArray;
                        stringArray = IBGWhereArg.argsListToStringArray(this.d);
                        return this.e.database.update((String)stringArray2, contentValues, string2, stringArray);
                    }
                    IBGDbManager.access$300(this.e, "DB update failed");
                    return -1;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB update failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    IBGDbManager.access$300(this.e, "DB update failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    return -1;
                }
                catch (Exception exception) {
                    IBGDiagnostics.reportNonFatal(exception, "DB update failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    IBGDbManager.access$300(this.e, "DB update failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    return -1;
                }
            }
        });
        return n5 == null ? 0 : n5;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public IBGCursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable List<IBGWhereArg> selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return (IBGCursor)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable(this, (String)var1_1, (String[])var2_2, (String)var3_3, (List)var4_4, (String)var5_5, (String)var6_6, (String)var7_7, (String)var8_8){
            final /* synthetic */ String a;
            final /* synthetic */ String[] b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            final /* synthetic */ String e;
            final /* synthetic */ String f;
            final /* synthetic */ String g;
            final /* synthetic */ String h;
            final /* synthetic */ IBGDbManager i;
            {
                void var1_1;
                this.i = var1_1;
                this.a = string2;
                this.b = stringArray;
                this.c = string3;
                this.d = list;
                this.e = string4;
                this.f = string5;
                this.g = string6;
                this.h = string7;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IBGCursor a() {
                h h5 = this;
                h5.i.openDatabase();
                try {
                    if (h5.i.databaseInitializedAndOpen()) {
                        h h6 = this;
                        String string2 = h6.a;
                        String[] stringArray = h6.b;
                        String string3 = h6.c;
                        String[] stringArray2 = IBGWhereArg.argsListToStringArray(h6.d);
                        String string4 = h6.e;
                        String string5 = h6.f;
                        String string6 = h6.g;
                        String string7 = h6.h;
                        return new IBGCursor(this.i.database.query(string2, stringArray, string3, stringArray2, string4, string5, string6, string7));
                    }
                    IBGDbManager.access$300(this.i, "DB query failed");
                    return null;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB query failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    IBGDbManager.access$300(this.i, "DB query failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    return null;
                }
                catch (Exception exception) {
                    IBGDiagnostics.reportNonFatal(exception, "DB query failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    IBGDbManager.access$300(this.i, "DB query failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    return null;
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void beginTransaction() {
        IBGDbManager iBGDbManager = this;
        iBGDbManager.openDatabase();
        try {
            if (iBGDbManager.databaseInitializedAndOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.beginTransaction();
                return;
            }
            this.logOperationFailedWarning("DB transaction failed");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB transaction failed: " + outOfMemoryError.getMessage());
            this.logOperationFailedWarning("DB transaction failed due to: " + outOfMemoryError.getMessage());
            return;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB transaction failed: " + exception.getMessage());
            this.logOperationFailedWarning("DB transaction failed due to:" + exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void endTransaction() {
        try {
            if (this.databaseInitializedAndOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.endTransaction();
                return;
            }
            this.logOperationFailedWarning("DB end transaction not successful");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB end transaction not successful due to: " + outOfMemoryError.getMessage());
            this.logOperationFailedWarning("DB end transaction not successful due to: " + outOfMemoryError.getMessage());
            return;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB end transaction not successful due to: " + exception.getMessage());
            this.logOperationFailedWarning("DB end transaction not successful due to: " + exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void setTransactionSuccessful() {
        try {
            if (this.databaseInitializedAndOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.setTransactionSuccessful();
                return;
            }
            this.logOperationFailedWarning("DB transaction not successful");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB transaction not successful due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB transaction not successful due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB transaction not successful due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB transaction not successful due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public long queryNumEntries(@NonNull String tableName) {
        void var1_1;
        Long l5 = (Long)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)l5), (String)var1_1){
            final /* synthetic */ String a;
            final /* synthetic */ IBGDbManager b;
            {
                void var1_1;
                this.b = var1_1;
                this.a = string2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Long a() {
                i i5 = this;
                i5.b.openDatabase();
                try {
                    if (i5.b.databaseInitializedAndOpen()) {
                        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.b.database, (String)this.a);
                    }
                    IBGDbManager.access$300(this.b, "DB query num entries failed");
                    return -1L;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB query num entries failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
                    IBGDbManager.access$300(this.b, "DB query num entries failed due to: " + outOfMemoryError.getMessage());
                    return -1L;
                }
                catch (Exception exception) {
                    IBGDiagnostics.reportNonFatalAndLog(exception, "DB query num entries failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()), "IBG-Core");
                    IBGDbManager.access$300(this.b, "DB query num entries failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
                    return -1L;
                }
            }
        });
        return l5 == null ? -1L : l5;
    }

    public synchronized boolean deleteDatabase(Context context) {
        dbHelper.close();
        return context.deleteDatabase(dbHelper.getDatabaseName());
    }
}

