/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;

public abstract class InstabugBaseFragment
extends Fragment {
    @Nullable
    private View view;
    @Nullable
    private Activity activity;
    private boolean isStateRestored;

    @LayoutRes
    protected abstract int getLayout();

    protected abstract String getTitle();

    protected abstract void consumeNewInstanceSavedArguments();

    /*
     * WARNING - void declaration
     */
    public void onAttach(Activity activity) {
        void var1_1;
        super.onAttach((Activity)var1_1);
        this.activity = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        void var1_1;
        InstabugBaseFragment instabugBaseFragment = this;
        super.onCreate((Bundle)var1_1);
        if (instabugBaseFragment.getArguments() != null) {
            InstabugSDKLogger.v("IBG-Core", "Arguments found, calling consumeNewInstanceSavedArguments with " + this.getArguments());
            this.consumeNewInstanceSavedArguments();
        }
        this.isStateRestored = false;
    }

    /*
     * WARNING - void declaration
     */
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        void var2_2;
        void var1_1;
        InstabugBaseFragment instabugBaseFragment = this;
        instabugBaseFragment.view = var1_1.inflate(this.getLayout(), (ViewGroup)var2_2, false);
        instabugBaseFragment.setTitle(instabugBaseFragment.getTitle());
        return instabugBaseFragment.view;
    }

    protected abstract void restoreState(Bundle var1);

    /*
     * WARNING - void declaration
     */
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        void var2_2;
        void var1_1;
        super.onViewCreated((View)var1_1, (Bundle)var2_2);
        if (savedInstanceState != null) {
            InstabugSDKLogger.v("IBG-Core", "savedInstanceState found, calling restoreState");
            this.restoreState((Bundle)var2_2);
            this.isStateRestored = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onSaveInstanceState(@NonNull Bundle outState) {
        void var1_1;
        InstabugBaseFragment instabugBaseFragment = this;
        super.onSaveInstanceState((Bundle)var1_1);
        InstabugSDKLogger.v("IBG-Core", "onSaveInstanceState called, calling saveState");
        instabugBaseFragment.saveState((Bundle)var1_1);
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    protected abstract void saveState(Bundle var1);

    public boolean isStateRestored() {
        return this.isStateRestored;
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Activity getPreservedActivity() {
        InstabugSDKLogger.v("IBG-Core", "Returning preserved activity " + this.activity);
        return this.activity;
    }

    /*
     * WARNING - void declaration
     */
    public void setTitle(String title) {
        InstabugBaseFragment this_ = this_.view;
        if (this_ == null) {
            return;
        }
        if ((this_ = (TextView)this_.findViewById(R.id.instabug_fragment_title)) != null) {
            void var1_1;
            InstabugSDKLogger.v("IBG-Core", "Setting fragment title to \"" + (String)var1_1 + "\"");
            this_.setText((CharSequence)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String getLocalizedString(@StringRes int resourceId) {
        void var1_1;
        return LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(this.requireContext()), (int)var1_1, this.requireContext());
    }
}

