/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.model.Attachment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class AttachmentsUtility {
    public static final double MAX_FILE_SIZE_IN_MB = 5.0;

    public static File getVideoFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        Object object = AttachmentsUtility.getNewDirectory(context, "videos");
        Object object2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        object2 = "video-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    public static File getFilesAttachmentDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "attachments");
    }

    /*
     * WARNING - void declaration
     */
    public static File getNewDirectory(Context context, String directoryName) {
        void var1_1;
        Context context2;
        File file;
        File file2 = file;
        if (!new File(DiskUtils.getInstabugInternalDirectory(context2) + "/" + (String)var1_1 + "/").exists() && file2.mkdirs()) {
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static Pair<String, String> getFileNameAndSize(Context context, @Nullable Uri uri) {
        Context context2;
        block6: {
            String string2;
            if (uri == null) {
                return null;
            }
            if ((context2 = context2.getContentResolver().query((Uri)string2, null, null, null, null)) != null) {
                Pair pair;
                String string3;
                try {
                    if (!context2.moveToFirst()) break block6;
                    Context context3 = context2;
                    string2 = context3.getString(context3.getColumnIndexOrThrow("_display_name"));
                    string3 = context3.getString(context3.getColumnIndexOrThrow("_size"));
                }
                catch (Throwable throwable) {
                    context2.close();
                    throw throwable;
                }
                {
                    pair = new Pair((Object)string2, (Object)string3);
                    context2.close();
                }
                return pair;
            }
        }
        if (context2 != null) {
            context2.close();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @RequiresApi(api=19)
    public static InputStream getFileInputStreamFileFromUri(Context context, Uri fileUri) {
        try {
            void var1_1;
            return context.getContentResolver().openInputStream((Uri)var1_1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static String getGalleryImagePath(Activity activity, @Nullable Uri uri) {
        void var1_2;
        Cursor cursor;
        if (uri == null) {
            return null;
        }
        Cursor cursor2 = cursor;
        Cursor cursor3 = new String[1];
        cursor = cursor3;
        cursor3[0] = "_data";
        if ((cursor = cursor2.managedQuery((Uri)var1_2, (String[])cursor, null, null, null)) != null) {
            Cursor cursor4 = cursor;
            int n5 = cursor4.getColumnIndexOrThrow("_data");
            cursor4.moveToFirst();
            return cursor4.getString(n5);
        }
        return null;
    }

    @Nullable
    public static Uri getNewFileAttachmentUri(@Nullable Context context, Uri originalUri, @Nullable String fileNameWithExtension) {
        String string2;
        Context context2;
        if (originalUri != null && context2 != null && string2.getPath() != null) {
            Object object;
            block9: {
                File file;
                String string3;
                object = string2.getLastPathSegment();
                File file2 = AttachmentsUtility.getFilesAttachmentDirectory(context2);
                object = object == null ? "" : ((String)object).toLowerCase();
                if (string3 == null || SettingsManager.getInstance().getExtraAttachmentFiles() == null || !((AbstractMap)SettingsManager.getInstance().getExtraAttachmentFiles()).containsKey(string2)) {
                    string3 = object;
                }
                object = file;
                if (new File(file2, string3).exists()) {
                    File file3;
                    object = file3;
                    file3 = new File(file2, System.currentTimeMillis() + "_" + string3);
                }
                try {
                    if (!AttachmentsUtility.fileSizeIsNotValidWithLog((Uri)string2, 5.0)) break block9;
                    return null;
                }
                catch (IOException iOException) {
                    string2 = iOException.getMessage();
                    if (string2 == null) {
                        string2 = "Exception while copying attachment file";
                    }
                    InstabugSDKLogger.e("IBG-Core", string2, iOException);
                    return null;
                }
            }
            DiskUtils.copyFromUriIntoFile(context2, (Uri)string2, (File)object);
            context2 = Uri.fromFile((File)object);
            if (AttachmentsUtility.fileSizeIsNotValidWithLog((Uri)context2, 5.0)) {
                return null;
            }
            return context2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileAttachmentUri(@Nullable Context context, Uri originalUri, @Nullable String fileNameWithExtension, double fileSizeLimitInMbs) {
        String string2;
        Context context2;
        if (originalUri != null && context2 != null && string2.getPath() != null) {
            void var3_4;
            Object object;
            block9: {
                File file;
                String string3;
                object = string2.getLastPathSegment();
                File file2 = AttachmentsUtility.getFilesAttachmentDirectory(context2);
                object = object == null ? "" : ((String)object).toLowerCase();
                if (string3 == null || SettingsManager.getInstance().getExtraAttachmentFiles() == null || !((AbstractMap)SettingsManager.getInstance().getExtraAttachmentFiles()).containsKey(string2)) {
                    string3 = object;
                }
                object = file;
                if (new File(file2, string3).exists()) {
                    File file3;
                    object = file3;
                    file3 = new File(file2, System.currentTimeMillis() + "_" + string3);
                }
                try {
                    if (!AttachmentsUtility.fileSizeIsNotValidWithLog((Uri)string2, (double)var3_4)) break block9;
                    return null;
                }
                catch (IOException iOException) {
                    string2 = iOException.getMessage();
                    if (string2 == null) {
                        string2 = "Exception while copying attachment file";
                    }
                    InstabugSDKLogger.e("IBG-Core", string2, iOException);
                    return null;
                }
            }
            DiskUtils.copyFromUriIntoFile(context2, (Uri)string2, (File)object);
            context2 = Uri.fromFile((File)object);
            if (AttachmentsUtility.fileSizeIsNotValidWithLog((Uri)context2, (double)var3_4)) {
                return null;
            }
            return context2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean fileSizeIsNotValidWithLog(Uri fileUri, double maxFileSizeInMb) {
        void var1_1;
        if (!AttachmentsUtility.validateFileSize(fileUri, (double)var1_1)) {
            Uri uri;
            InstabugSDKLogger.w("IBG-Core", "Attachment file " + uri.toString() + " size exceeds than the limit " + (double)var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileAttachmentUri(@Nullable Context context, Uri originalUri) {
        void var1_1;
        return AttachmentsUtility.getNewFileAttachmentUri(context, (Uri)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getUriFromBytes(Context context, byte[] data, String fileName) {
        Object object;
        block5: {
            File file;
            void var2_3;
            object = AttachmentsUtility.getInternalAttachmentFile((Context)object, (String)var2_3);
            try {
                AttachmentsUtility.saveBytesToFile(data, (File)object);
                if (!FileUtils.encryptFile(((File)object).getPath())) break block5;
            }
            catch (IOException iOException) {
                if (iOException.getMessage() != null) {
                    InstabugSDKLogger.e("IBG-Core", "Error while getting uri: " + iOException.getMessage(), iOException);
                }
                return null;
            }
            File file2 = file;
            file = new File(FileUtils.getPathWithEncryptedFlag(((File)object).getPath()));
            object = file2;
        }
        return Uri.fromFile((File)object);
    }

    /*
     * WARNING - void declaration
     */
    private static File getInternalAttachmentFile(Context context, String fileName) {
        void var1_1;
        File file;
        Object object = AttachmentsUtility.getFilesInternalAttachmentDirectory(context);
        File file2 = file;
        if (new File((File)object, (String)var1_1).exists()) {
            File file3;
            file2 = file3;
            file3 = new File((File)object, System.currentTimeMillis() + "_" + (String)var1_1);
        }
        return file2;
    }

    public static File getFilesInternalAttachmentDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "internal-attachments");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"RESOURCE_LEAK"})
    private static void saveBytesToFile(byte[] data, File file) throws IOException {
        void var0_3;
        BufferedOutputStream bufferedOutputStream;
        block7: {
            FileOutputStream fileOutputStream;
            BufferedOutputStream bufferedOutputStream2;
            bufferedOutputStream = null;
            BufferedOutputStream bufferedOutputStream3 = bufferedOutputStream2;
            FileOutputStream fileOutputStream2 = fileOutputStream;
            try {
                void var1_4;
                fileOutputStream = new FileOutputStream((File)var1_4);
                bufferedOutputStream2 = new BufferedOutputStream(fileOutputStream2);
            }
            catch (Throwable throwable) {
                // empty catch block
                break block7;
            }
            try {
                byte[] byArray;
                ((OutputStream)bufferedOutputStream2).write(byArray);
            }
            catch (Throwable throwable) {
                bufferedOutputStream = bufferedOutputStream3;
                break block7;
            }
            bufferedOutputStream2.flush();
            ((OutputStream)bufferedOutputStream2).close();
            return;
        }
        if (bufferedOutputStream != null) {
            BufferedOutputStream bufferedOutputStream3 = bufferedOutputStream;
            bufferedOutputStream3.flush();
            ((OutputStream)bufferedOutputStream3).close();
        }
        throw var0_3;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"RESOURCE_LEAK"})
    public static File saveInputStreamToFile(Context context, InputStream inputStream, String fileName) {
        Object object;
        Object object2;
        block22: {
            block24: {
                block23: {
                    int n5;
                    FileOutputStream fileOutputStream;
                    File file;
                    block25: {
                        FileOutputStream fileOutputStream2;
                        File file2;
                        file = file2;
                        file2 = new File(AttachmentsUtility.getFilesAttachmentDirectory((Context)object2), (String)((Object)fileOutputStream));
                        object2 = null;
                        fileOutputStream = fileOutputStream2;
                        fileOutputStream2 = new FileOutputStream(file);
                        object2 = new byte[1024];
                        break block25;
                        catch (Throwable throwable) {
                            object = object2;
                            object2 = throwable;
                            break block22;
                        }
                        catch (Exception exception) {
                            object = object2;
                            object2 = exception;
                            break block23;
                        }
                        catch (IOException iOException) {
                            object = object2;
                            object2 = iOException;
                            break block24;
                        }
                    }
                    while ((n5 = ((InputStream)object).read((byte[])object2)) != -1) {
                        fileOutputStream.write((byte[])object2, 0, n5);
                    }
                    FileOutputStream fileOutputStream3 = fileOutputStream;
                    FileOutputStream fileOutputStream4 = fileOutputStream3;
                    FileOutputStream fileOutputStream5 = fileOutputStream3;
                    ((InputStream)object).close();
                    try {
                        fileOutputStream4.flush();
                        fileOutputStream5.close();
                        return file;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return file;
                    catch (Throwable throwable) {
                        object = fileOutputStream;
                        break block22;
                    }
                    catch (Exception exception) {
                        object = fileOutputStream;
                    }
                    catch (IOException iOException) {
                        object = fileOutputStream;
                        break block24;
                    }
                }
                InstabugSDKLogger.e("IBG-Core", object2.toString(), (Throwable)object2);
                if (object == null) return null;
                try {
                    Object object3 = object;
                    ((OutputStream)object3).flush();
                    ((FileOutputStream)object3).close();
                    return null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            }
            InstabugSDKLogger.e("IBG-Core", "IO exception: " + ((Throwable)object2).getMessage(), (Throwable)object2);
            if (object == null) return null;
            try {
                Object object4 = object;
                ((OutputStream)object4).flush();
                ((FileOutputStream)object4).close();
                return null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object == null) throw object2;
        try {
            Object object5 = object;
            ((OutputStream)object5).flush();
            ((FileOutputStream)object5).close();
            throw object2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        throw object2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(api=19)
    @Nullable
    public static File getFileFromContentProvider(Context context, @Nullable Uri uri, String fileName) {
        Context context2;
        InputStream inputStream;
        if (uri == null) {
            return null;
        }
        if ((inputStream = AttachmentsUtility.getFileInputStreamFileFromUri(context2, (Uri)inputStream)) != null) {
            void var2_2;
            return AttachmentsUtility.saveInputStreamToFile(context2, inputStream, (String)var2_2);
        }
        InstabugSDKLogger.e("IBG-Core", "Inputstream is null while reading file from content provider");
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateFileSize(Uri originalUri, double maxFileSize) {
        Throwable throwable222222;
        InputStream inputStream;
        block18: {
            void var1_4;
            double d5;
            long l5;
            Uri uri;
            if (Instabug.getApplicationContext() == null) {
                return false;
            }
            if (uri.getPath() == null) {
                return false;
            }
            if (uri.toString().contains("android.resource")) {
                block17: {
                    inputStream = null;
                    inputStream = Instabug.getApplicationContext().getContentResolver().openInputStream(uri);
                    if (inputStream != null) break block17;
                    boolean bl = false;
                    if (inputStream == null) return bl;
                    try {
                        inputStream.close();
                        return bl;
                    }
                    catch (IOException iOException) {}
                    return bl;
                }
                InputStream inputStream2 = inputStream;
                InputStream inputStream3 = inputStream2;
                l5 = inputStream2.available();
                try {
                    inputStream3.close();
                }
                catch (IOException iOException) {}
            } else {
                l5 = new File(uri.getPath()).length();
            }
            double d6 = l5;
            double d7 = d6 / 1048576.0;
            if (!(d5 > var1_4)) return AttachmentsUtility.isValidSize(d6, (double)var1_4);
            InstabugSDKLogger.w("IBG-Core", "External attachment file size is " + l5 + " bytes or " + d7 + " MBs > maxFileSize " + (double)var1_4);
            return false;
            {
                boolean bl;
                catch (Throwable throwable222222) {
                    break block18;
                }
                catch (IOException iOException) {}
                {
                    InstabugSDKLogger.w("IBG-Core", "External attachment file " + uri.getPath() + " couldn't be loaded to calculate its size");
                    bl = false;
                    if (inputStream == null) return bl;
                }
                try {
                    inputStream.close();
                    return bl;
                }
                catch (IOException iOException) {}
                return bl;
            }
        }
        if (inputStream == null) throw throwable222222;
        try {
            inputStream.close();
            throw throwable222222;
        }
        catch (IOException iOException) {}
        throw throwable222222;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValidSize(double sizeInBytes, double maxFileSize) {
        void var2_1;
        double d5;
        double d6 = sizeInBytes / 1048576.0;
        if (d5 > var2_1) {
            InstabugSDKLogger.w("IBG-Core", "External attachment file size is " + d6 + " MBs > maxFileSize " + (double)var2_1);
            return false;
        }
        return true;
    }

    public static void encryptAttachments(@Nullable List<Attachment> attachments) {
        InstabugSDKLogger.v("IBG-Core", "encryptAttachments");
        if (attachments != null) {
            Iterator<Attachment> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Attachment attachment = (Attachment)iterator.next();
                if (attachment.isEncrypted() || attachment.getLocalPath() == null) continue;
                Attachment attachment2 = attachment;
                attachment2.setEncrypted(InstabugCore.encrypt(attachment2.getLocalPath()));
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void encryptAttachmentsAndUpdateDb(@Nullable List<Attachment> attachments) {
        InstabugSDKLogger.v("IBG-Core", "encryptAttachmentsAndUpdateDb");
        if (attachments != null) {
            Iterator<Attachment> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                AttachmentsUtility.encryptAttachmentAndUpdateDb((Attachment)iterator.next());
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void encryptAttachmentAndUpdateDb(Attachment attachment) {
        Attachment attachment2;
        InstabugSDKLogger.v("IBG-Core", "encryptAttachmentAndUpdateDb");
        if (!attachment.isEncrypted() && attachment2.getLocalPath() != null) {
            ContentValues contentValues;
            Attachment attachment3 = attachment2;
            boolean bl = InstabugCore.encrypt(attachment3.getLocalPath());
            attachment3.setEncrypted(bl);
            ContentValues contentValues2 = contentValues;
            contentValues2();
            contentValues.put("encrypted", Boolean.valueOf(bl));
            AttachmentsDbHelper.update(attachment3.getId(), contentValues2);
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static boolean decryptAttachmentAndUpdateDb(Attachment attachment) {
        String string2;
        InstabugSDKLogger.v("IBG-Core", "decryptAttachmentAndUpdateDb");
        if (attachment.isEncrypted() && ((Attachment)((Object)string2)).getLocalPath() != null) {
            ContentValues contentValues;
            boolean bl = InstabugCore.decrypt(((Attachment)((Object)string2)).getLocalPath());
            ((Attachment)((Object)string2)).setEncrypted(bl ^ true);
            ContentValues contentValues2 = contentValues;
            contentValues = new ContentValues();
            if (bl) {
                Attachment attachment2 = string2;
                String string3 = FileUtils.getPathWithDecryptedFlag(((Attachment)((Object)string2)).getLocalPath());
                contentValues2.put("local_path", string3);
                attachment2.setLocalPath(string3);
                string3 = FileUtils.getFileName(attachment2.getLocalPath());
                if (string3 != null) {
                    ((Attachment)((Object)string2)).setName(string3);
                }
            }
            Attachment attachment3 = string2;
            string2 = "encrypted";
            contentValues2.put(string2, Boolean.valueOf(bl ^ true));
            AttachmentsDbHelper.update(attachment3.getId(), contentValues2);
            return bl;
        }
        return true;
    }

    public static void clearInternalAttachments(@Nullable Context context) {
        if (context != null) {
            Context context2;
            FileUtils.deleteDirectory(AttachmentsUtility.getFilesInternalAttachmentDirectory(context2));
        }
    }
}

