/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.view.MotionEvent;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.library.Feature;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.CurrentFragmentLifeCycleEventBus;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityConfigurationChange;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.d;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.sessionreplay.di.a;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.FragmentLifeCycleEvent;
import com.instabug.library.tracking.e;
import com.instabug.library.tracking.f;
import com.instabug.library.tracking.o;
import com.instabug.library.tracking.s;
import com.instabug.library.tracking.t;
import com.instabug.library.tracking.u;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.ref.WeakReference;
import java.util.concurrent.Future;

public class InstabugInternalTrackingDelegate {
    private static volatile InstabugInternalTrackingDelegate INSTANCE;
    private static final String FRAGMENT_NAV_HOST_NAME = "androidx.navigation.fragment.NavHostFragment";
    private boolean isRegistered = false;
    private final e currentActivityMonitor;
    private final o activityLifecycleListener;
    @Nullable
    private WeakReference<Fragment> lastResumedFragment;
    @Nullable
    private volatile WeakReference<Activity> currentActivity;
    @Nullable
    private volatile WeakReference<Activity> currentRealActivity;
    private int startedActivitiesNumber = 0;
    private final int platform = SettingsManager.getInstance().getCurrentPlatform();

    public static void init(@NonNull Application application) {
        if (INSTANCE == null) {
            Application application2;
            INSTANCE = new InstabugInternalTrackingDelegate(application2);
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private InstabugInternalTrackingDelegate(@NonNull Application application) {
        void var1_1;
        e e5;
        e e6 = e5;
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
        e e7 = e6;
        e7();
        instabugInternalTrackingDelegate.currentActivityMonitor = e7;
        instabugInternalTrackingDelegate.activityLifecycleListener = new o();
        e5.a((Application)var1_1);
        this.registerLifecycleListeners((Application)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void registerWindowCallbacksIfNeeded(Activity activity) {
        void var1_1;
        if (activity == null) {
            return;
        }
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = var1_1.getWindow();
        if (instabugInternalTrackingDelegate == null) {
            return;
        }
        if (!((instabugInternalTrackingDelegate = instabugInternalTrackingDelegate.getCallback()) instanceof u)) {
            InstabugSDKLogger.d("IBG-Core", "restore original window callback");
            var1_1.getWindow().setCallback((Window.Callback)new u((Window.Callback)instabugInternalTrackingDelegate));
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNavHostFragment(Fragment fragment) {
        void var1_1;
        if (fragment == null) {
            return false;
        }
        return FRAGMENT_NAV_HOST_NAME.equals(var1_1.getClass().getName());
    }

    private boolean isUserTrackingStepsEnable() {
        return d.c().b((Object)"TRACK_USER_STEPS") == Feature.State.ENABLED && ((Object)((Object)InstabugStateProvider.getInstance().getState())).equals((Object)InstabugState.ENABLED);
    }

    private boolean isInstabugInEnabledState() {
        return ((Object)((Object)InstabugStateProvider.getInstance().getState())).equals((Object)InstabugState.ENABLED);
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return activity instanceof _InstabugActivity ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            void var1_1;
            InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " created");
            t.a().a(var1_1.getClass().getName(), "APPLICATION_CREATED");
        }
    }

    public int getStartedActivitiesNumber() {
        return this.startedActivitiesNumber;
    }

    void handleActivityCreatedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", string2.getClass().getSimpleName() + " created");
                t.a().a(string2.getClass().getName(), "ACTIVITY_CREATED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isInstabugInEnabledState() && ((InstabugInternalTrackingDelegate)((Object)this_)).platform == 2) {
                void v02 = string2;
                String this_ = v02.getClass().getSimpleName();
                string2 = v02.getClass().getName();
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_CREATED", this_, string2, null);
            }
            CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.CREATED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityStartedEvent(Activity activity) {
        void var1_1;
        ++((InstabugInternalTrackingDelegate)this_).startedActivitiesNumber;
        if (((InstabugInternalTrackingDelegate)this_).isNotInstabugActivity((Activity)var1_1)) {
            if (((InstabugInternalTrackingDelegate)this_).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " started");
                t.a().a(var1_1.getClass().getName(), "ACTIVITY_STARTED");
            }
            if (((InstabugInternalTrackingDelegate)this_).isInstabugInEnabledState() && ((InstabugInternalTrackingDelegate)this_).platform == 2) {
                void v02 = var1_1;
                Object this_ = v02.getClass().getSimpleName();
                String string2 = v02.getClass().getName();
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_STARTED", (String)this_, string2, null);
            }
            if ((this_ = CoreServiceLocator.getScreenShotCaptorRegistry()) != null) {
                this_.b((Activity)var1_1);
            }
        }
        CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.STARTED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityResumedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " resumed");
                t.a().a(var1_1.getClass().getName(), "ACTIVITY_RESUMED");
            }
            if (this.isInstabugInEnabledState()) {
                void v02 = var1_1;
                String string2 = v02.getClass().getSimpleName();
                String string3 = v02.getClass().getName();
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_RESUMED", string2, string3, null);
            }
            CoreServiceLocator.getNavigableViewsTracker().c((Activity)var1_1);
            CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.RESUMED);
            this.registerWindowCallbacksIfNeeded((Activity)var1_1);
            f.b().b(var1_1.getClass().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentActivity(Activity activity) {
        void var1_1;
        ((InstabugInternalTrackingDelegate)((Object)this_)).currentRealActivity = new WeakReference<void>(var1_1);
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)var1_1)) {
            WeakReference<void> weakReference;
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            WeakReference<void> this_ = weakReference;
            weakReference = new WeakReference<void>(var1_1);
            instabugInternalTrackingDelegate.currentActivity = this_;
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityPausedEvent(Activity activity) {
        void var1_1;
        Object object = ((InstabugInternalTrackingDelegate)((Object)this_)).getCurrentActivity();
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)var1_1)) {
            if (object == null) {
                InstabugSDKLogger.w("IBG-Core", "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!var1_1.equals(object)) {
                InstabugSDKLogger.w("IBG-Core", "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " paused");
                t.a().a(var1_1.getClass().getName(), "ACTIVITY_PAUSED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isInstabugInEnabledState()) {
                void v02 = var1_1;
                String this_ = v02.getClass().getSimpleName();
                object = v02.getClass().getName();
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_PAUSED", this_, (String)object, null);
            }
            CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.PAUSED);
        }
        CoreServiceLocator.getNavigableViewsTracker().b((Activity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityStoppedEvent(Activity activity) {
        void var1_1;
        --((InstabugInternalTrackingDelegate)this_).startedActivitiesNumber;
        if (((InstabugInternalTrackingDelegate)this_).isNotInstabugActivity((Activity)var1_1)) {
            Object object;
            if (((InstabugInternalTrackingDelegate)this_).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " stopped");
                object = t.a().a(var1_1.getClass().getName(), "ACTIVITY_STOPPED");
                if (((InstabugInternalTrackingDelegate)this_).startedActivitiesNumber == 0) {
                    a.k().a((Future)object);
                }
            }
            if (((InstabugInternalTrackingDelegate)this_).isInstabugInEnabledState()) {
                void v02 = var1_1;
                Object this_ = v02.getClass().getSimpleName();
                object = v02.getClass().getName();
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_STOPPED", (String)this_, (String)object, null);
            }
            if ((this_ = CoreServiceLocator.getScreenShotCaptorRegistry()) != null) {
                this_.a((Activity)var1_1);
            }
        }
        CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.STOPPED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityDestroyedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            Object object;
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " destroyed");
                t.a().a(var1_1.getClass().getName(), "ACTIVITY_DESTROYED");
            }
            if (this.isInstabugInEnabledState()) {
                void v02 = var1_1;
                object = v02.getClass().getSimpleName();
                String string2 = v02.getClass().getName();
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_DESTROYED", (String)object, string2, null);
            }
            if ((object = this.getCurrentActivity()) != null && object == var1_1) {
                this.clearCurrentActivity();
            }
            CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.DESTROYED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentAttached(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                t.a().a(var1_1.getClass().getName(), activity.getClass().getName(), "FRAGMENT_ATTACHED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.ATTACHED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentViewCreated(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                t.a().a(var1_1.getClass().getName(), activity.getClass().getName(), "FRAGMENT_VIEW_CREATED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.VIEW_CREATED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentStarted(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                t.a().a(var1_1.getClass().getName(), activity.getClass().getName(), "FRAGMENT_STARTED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.STARTED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentResumed(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity;
            Activity activity2 = activity;
            activity = new WeakReference(var1_1);
            this.lastResumedFragment = activity2;
            activity2 = this.getCurrentActivity();
            if (activity2 != null && this.isUserTrackingStepsEnable()) {
                t.a().a(var1_1.getClass().getName(), activity2.getClass().getName(), "FRAGMENT_RESUMED");
            }
            if (var1_1.getActivity() != null) {
                this.registerWindowCallbacksIfNeeded((Activity)var1_1.getActivity());
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.RESUMED);
            f.b().c(var1_1.getClass().getName());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentPaused(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            this.lastResumedFragment = null;
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                t.a().a(var1_1.getClass().getName(), activity.getClass().getName(), "FRAGMENT_PAUSED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.PAUSED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentStopped(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                t.a().a(var1_1.getClass().getName(), activity.getClass().getName(), "FRAGMENT_STOPPED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.STOPPED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentDetached(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                t.a().a(var1_1.getClass().getName(), activity.getClass().getName(), "FRAGMENT_DETACHED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.DETACHED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onFragmentVisibilityChanged(boolean isVisible, Fragment fragment) {
        void var2_3;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string2)).isNavHostFragment((Fragment)var2_3)) {
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string2)).getCurrentActivity();
            if (activity != null && ((InstabugInternalTrackingDelegate)((Object)string2)).isUserTrackingStepsEnable()) {
                void var1_1;
                t.a().a(var2_3.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + (boolean)var1_1, "FRAGMENT_VISIBILITY_CHANGED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)string2)).isInstabugInEnabledState()) {
                void v02 = var2_3;
                String string2 = v02.getClass().getSimpleName();
                String string3 = v02.getClass().getName();
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("FRAGMENT_VISIBILITY_CHANGED", string2, string3, null);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void trackTouchEvent(MotionEvent event) {
        void var1_1;
        s.a().a((MotionEvent)var1_1);
    }

    @Nullable
    public Activity getCurrentActivity() {
        block4: {
            InstabugInternalTrackingDelegate this_;
            block3: {
                try {
                    if (this_.currentActivity != null) break block3;
                    this_ = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    InstabugCore.reportError(throwable, "Error while retrieving current activity");
                    return null;
                }
            }
            this_ = (Activity)this_.currentActivity.get();
        }
        return this_;
    }

    public void clearCurrentActivity() {
        block3: {
            if (this.currentActivity != null) break block3;
            return;
        }
        try {
            this.currentActivity.clear();
        }
        catch (Throwable throwable) {
            InstabugCore.reportError(throwable, "Error while clearing current activity");
        }
    }

    @Nullable
    public Activity getCurrentRealActivity() {
        block4: {
            InstabugInternalTrackingDelegate this_;
            block3: {
                try {
                    if (this_.currentRealActivity != null) break block3;
                    this_ = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    InstabugCore.reportError(throwable, "Error while retrieving current real activity");
                    return null;
                }
            }
            this_ = (Activity)this_.currentRealActivity.get();
        }
        return this_;
    }

    @Nullable
    public Activity getTargetActivity() {
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
        InstabugInternalTrackingDelegate this_ = null;
        Activity activity = instabugInternalTrackingDelegate.getCurrentActivity();
        if (activity != null && activity.getParent() != null) {
            this_ = activity.getParent();
            while (this_.getParent() != null) {
                this_ = this_.getParent();
            }
        } else if (activity != null) {
            this_ = activity;
        }
        return this_;
    }

    @Nullable
    public Object getLastSeenView() {
        WeakReference<Fragment> weakReference = this.lastResumedFragment;
        if (weakReference != null && weakReference.get() != null) {
            return this.lastResumedFragment.get();
        }
        return this.getTargetActivity();
    }

    /*
     * WARNING - void declaration
     */
    public void registerLifecycleListeners(Application application) {
        void var1_1;
        InstabugSDKLogger.d("IBG-Core", "Registering activity lifecycle listener");
        var1_1.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleListener);
        var1_1.registerComponentCallbacks((ComponentCallbacks)this.activityLifecycleListener);
        this.isRegistered = true;
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterLifecycleListeners(Application application) {
        void var1_1;
        InstabugSDKLogger.d("IBG-Core", "Unregistering activity lifecycle listener");
        var1_1.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleListener);
        var1_1.unregisterComponentCallbacks((ComponentCallbacks)this.activityLifecycleListener);
        this.isRegistered = false;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    /*
     * WARNING - void declaration
     */
    void handleConfigurationChanged(Configuration newConfig) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).getTargetActivity() == null) {
            return;
        }
        CurrentActivityConfigurationChange this_ = CurrentActivityConfigurationChange.getInstance();
        this_.setNewConfig((Configuration)var1_1);
        CurrentActivityConfigurationChange.getInstance().post(this_);
    }
}

