/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.annotation.SuppressLint;
import android.os.Build;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.instabug.library.Instabug;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class AccessibilityUtils {
    @NotNull
    public static final AccessibilityUtils INSTANCE = new AccessibilityUtils();

    private AccessibilityUtils() {
    }

    private final AccessibilityManager getAccessibilityManager() {
        AccessibilityUtils accessibilityUtils = Instabug.getApplicationContext();
        return (AccessibilityManager)(accessibilityUtils == null ? null : accessibilityUtils.getSystemService("accessibility"));
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static final boolean isTalkbackEnabled() {
        String string2;
        Object object = INSTANCE.getAccessibilityManager();
        if (object == null) return false;
        if ((object = object.getEnabledAccessibilityServiceList(1)) == null || object.isEmpty()) return false;
        object = object.iterator();
        do {
            if (!object.hasNext()) {
                return false;
            }
            string2 = ((AccessibilityServiceInfo)object.next()).getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.id");
        } while (!StringsKt.endsWith$default((String)string2, (String)"TalkBackService", (boolean)false, (int)2, null));
        return true;
    }

    @JvmStatic
    public static /* synthetic */ void isTalkbackEnabled$annotations() {
    }

    @JvmStatic
    @SuppressLint(value={"InlinedApi"})
    public static final void sendTextEvent(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Integer n10 = Build.VERSION.SDK_INT;
        if (!(n10 >= 16 && AccessibilityUtils.isTalkbackEnabled())) {
            n10 = null;
        }
        if (n10 != null) {
            ((Number)n10).intValue();
            n10 = AccessibilityEvent.obtain((int)16384);
            if (n10 != null) {
                String string2;
                n10.getText().add(string2);
                string2 = INSTANCE.getAccessibilityManager();
                if (string2 != null) {
                    string2.sendAccessibilityEvent((AccessibilityEvent)n10);
                }
            }
        }
    }
}

