/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.DialogFragment;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.instabug.library.PresentationManager;
import com.instabug.library.R;
import com.instabug.library.core.CurrentFragmentLifeCycleEventBus;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ActivityLifecycleSubscriber;
import com.instabug.library.core.eventbus.DefaultActivityLifeCycleEventHandler;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.screenshot.ScreenshotCaptor;
import com.instabug.library.screenshot.e;
import com.instabug.library.screenshot.instacapture.s;
import com.instabug.library.screenshot.instacapture.t;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.FragmentLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.view.ViewUtils;
import io.reactivexport.disposables.Disposable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class ExtraScreenshotHelper
implements DefaultActivityLifeCycleEventHandler {
    @Nullable
    private WeakReference<WindowManager> windowManagerWeakReference;
    @Nullable
    private WeakReference<ImageButton> captureBtnWeakReference;
    private boolean isCaptureBtnShown = false;
    @Nullable
    @VisibleForTesting
    ActivityLifecycleSubscriber currentActivityLifeCycleSubscriber;
    @Nullable
    private Disposable fragmentsLifeCycleSubscriber;
    @Nullable
    private OnCaptureListener onCaptureListener;

    /*
     * WARNING - void declaration
     */
    @MainThread
    private void show(@NonNull Activity hostActivity) {
        void var1_1;
        this.show((Activity)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    private void show(@NonNull Activity hostActivity, @Nullable Window window) {
        if (!this.isCaptureBtnShown && !SettingsManager.getInstance().isProcessingForeground()) {
            WindowManager windowManager;
            void var1_1;
            ImageButton imageButton = this.createCaptureButton((Activity)var1_1);
            ViewCompat.setElevation((View)imageButton, (float)ViewUtils.convertDpToPx(var1_1.getApplicationContext(), 5.0f));
            if (windowManager != null) {
                ((ViewGroup)windowManager.getDecorView()).addView((View)imageButton, (ViewGroup.LayoutParams)this.createCaptureButtonContainer((Activity)var1_1));
            } else {
                WeakReference<WindowManager> weakReference;
                windowManager = var1_1.getWindowManager();
                windowManager.addView((View)imageButton, (ViewGroup.LayoutParams)this.getButtonWindowLayoutParams());
                WeakReference<WindowManager> weakReference2 = weakReference;
                weakReference = new WeakReference<WindowManager>(windowManager);
                this.windowManagerWeakReference = weakReference2;
            }
            this.isCaptureBtnShown = true;
            imageButton.setOnClickListener(arg_0 -> this.lambda$show$0((Activity)var1_1, arg_0));
            this.captureBtnWeakReference = new WeakReference<ImageButton>(imageButton);
            return;
        }
    }

    private ImageButton createCaptureButton(Activity hostActivity) {
        Drawable drawable2;
        ImageButton imageButton;
        ExtraScreenshotHelper extraScreenshotHelper = imageButton;
        new ImageButton((Context)drawable2).setId(R.id.instabug_extra_screenshot_button);
        extraScreenshotHelper.setScaleType(ImageView.ScaleType.CENTER);
        int n10 = R.string.ibg_extra_screenshot_button_content_description;
        extraScreenshotHelper.setContentDescription(LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(extraScreenshotHelper.getContext()), n10, extraScreenshotHelper.getContext()));
        Drawable drawable3 = ContextCompat.getDrawable((Context)hostActivity, (int)R.drawable.ibg_core_bg_white_oval);
        drawable2 = AppCompatResources.getDrawable((Context)drawable2, (int)R.drawable.ibg_core_ic_screenshot);
        if (drawable3 != null) {
            extraScreenshotHelper.setBackgroundDrawable(Colorizer.getPrimaryColorTintedDrawable(drawable3));
        }
        if (drawable2 != null) {
            extraScreenshotHelper.setImageDrawable(drawable2);
        }
        return extraScreenshotHelper;
    }

    /*
     * WARNING - void declaration
     */
    private FrameLayout.LayoutParams createCaptureButtonContainer(Activity hostActivity) {
        FrameLayout.LayoutParams layoutParams;
        ExtraScreenshotHelper extraScreenshotHelper = layoutParams;
        new FrameLayout.LayoutParams(-2, -2, 81).setMargins(0, 0, 0, 20);
        if (ScreenUtility.hasNavBar((Context)hostActivity) && Build.VERSION.SDK_INT >= 21) {
            void var1_1;
            ((FrameLayout.LayoutParams)extraScreenshotHelper).bottomMargin += ScreenUtility.getBottomInsets((Activity)var1_1);
        }
        return extraScreenshotHelper;
    }

    private WindowManager.LayoutParams getButtonWindowLayoutParams() {
        new WindowManager.LayoutParams().flags = 8;
        new WindowManager.LayoutParams().height = -2;
        new WindowManager.LayoutParams().width = -2;
        new WindowManager.LayoutParams().gravity = 81;
        new WindowManager.LayoutParams().format = -3;
        new WindowManager.LayoutParams().y = 20;
        return new WindowManager.LayoutParams();
    }

    /*
     * WARNING - void declaration
     */
    private void captureExtraScreenshot(Activity hostActivity, @Nullable OnCaptureListener onCaptureListener) {
        void var1_1;
        void var2_2;
        ScreenshotCaptor.CapturingCallback capturingCallback = ((ExtraScreenshotHelper)((Object)capturingCallback)).createCapturingListener((OnCaptureListener)var2_2);
        e.a.a(s.a(new t(1, (Activity)var1_1, capturingCallback)));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private ScreenshotCaptor.CapturingCallback createCapturingListener(@Nullable OnCaptureListener onCaptureListener) {
        void var1_1;
        return new ScreenshotCaptor.CapturingCallback((OnCaptureListener)var1_1){
            final /* synthetic */ OnCaptureListener a;
            {
                this.a = onCaptureListener;
            }

            @Override
            public void onCapturingSuccess(@NonNull Bitmap bitmap) {
                ExtraScreenshotHelper.access$000(ExtraScreenshotHelper.this, bitmap, this.a);
            }

            @Override
            public void onCapturingFailure(@NonNull Throwable throwable) {
                OnCaptureListener onCaptureListener = this.a;
                if (onCaptureListener != null) {
                    onCaptureListener.onExtraScreenshotError(throwable);
                }
                ExtraScreenshotHelper.this.reset();
                InstabugSDKLogger.e("IBG-Core", "Error while capturing screenshot: " + throwable.getMessage());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void saveBitmap(Bitmap bitmap, @Nullable OnCaptureListener onCaptureListener) {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            void var2_2;
            BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback;
            BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback2;
            void v02 = onSaveBitmapCallback2;
            onSaveBitmapCallback2 = onSaveBitmapCallback;
            onSaveBitmapCallback = new BitmapUtils.OnSaveBitmapCallback(this, (OnCaptureListener)var2_2){
                final /* synthetic */ OnCaptureListener a;
                {
                    this.a = onCaptureListener;
                }

                @Override
                public void onSuccess(Uri uri) {
                    InstabugSDKLogger.v("IBG-Core", "Saving screenshot file to: " + uri.toString());
                    OnCaptureListener onCaptureListener = onCaptureListener.a;
                    if (onCaptureListener != null) {
                        onCaptureListener.onExtraScreenshotCaptured(uri);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    InstabugSDKLogger.e("IBG-Core", "Error while saving screenshot: " + throwable.getMessage());
                }
            };
            BitmapUtils.saveBitmap((Bitmap)v02, (Context)activity, onSaveBitmapCallback2);
        }
    }

    private void reset() {
        this.hide();
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
        }
    }

    @MainThread
    private void hide() {
        block4: {
            block7: {
                block6: {
                    ImageButton imageButton;
                    block5: {
                        imageButton = this.captureBtnWeakReference;
                        if (imageButton == null || !this.isCaptureBtnShown) break block4;
                        if ((imageButton = (ImageButton)imageButton.get()) == null) {
                            return;
                        }
                        WeakReference<WindowManager> weakReference = this.windowManagerWeakReference;
                        if (weakReference == null || weakReference.get() == null) break block5;
                        WindowManager windowManager = (WindowManager)this.windowManagerWeakReference.get();
                        ImageButton imageButton2 = imageButton;
                        imageButton2.setOnClickListener(null);
                        windowManager.removeView((View)imageButton2);
                        break block6;
                    }
                    if (!(imageButton.getParent() instanceof ViewGroup)) break block7;
                    ViewGroup viewGroup = (ViewGroup)imageButton.getParent();
                    ImageButton imageButton3 = imageButton;
                    imageButton3.setOnClickListener(null);
                    viewGroup.removeView((View)imageButton3);
                }
                ExtraScreenshotHelper extraScreenshotHelper = this;
                extraScreenshotHelper.isCaptureBtnShown = false;
                extraScreenshotHelper.captureBtnWeakReference = null;
                extraScreenshotHelper.windowManagerWeakReference = null;
                return;
            }
            return;
        }
    }

    private void subscribeToCurranActivityLifeCycle() {
        if (this.currentActivityLifeCycleSubscriber == null) {
            this.currentActivityLifeCycleSubscriber = CoreServiceLocator.createActivityLifecycleSubscriber(this);
        }
        this.currentActivityLifeCycleSubscriber.subscribe();
    }

    private void subscribeToFragmentsLifecycle() {
        if (this.fragmentsLifeCycleSubscriber == null) {
            this.fragmentsLifeCycleSubscriber = CurrentFragmentLifeCycleEventBus.getInstance().subscribe(event -> {
                void var1_1;
                if (event == FragmentLifeCycleEvent.RESUMED) {
                    this.handleFragmentResumed();
                } else if (var1_1 == FragmentLifeCycleEvent.DETACHED) {
                    this.handleFragmentDetached();
                }
            });
        }
    }

    private void handleFragmentResumed() {
        Window window = null;
        Object object = InstabugCore.getLastSeenView();
        if (object instanceof BottomSheetDialogFragment) {
            if ((object = (DialogFragment)object).getDialog() != null && object.isResumed() && !object.isRemoving() && !object.isDetached()) {
                window = object.getDialog().getWindow();
            }
            if ((object = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity()) != null && window != null) {
                ExtraScreenshotHelper extraScreenshotHelper = this;
                extraScreenshotHelper.hide();
                extraScreenshotHelper.show((Activity)object, window);
            }
            return;
        }
    }

    private void handleFragmentDetached() {
        WeakReference<WindowManager> weakReference = this.windowManagerWeakReference;
        if (weakReference == null || weakReference.get() == null) {
            this.reset();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$show$0(Activity hostActivity, View v10) {
        void var1_1;
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.hide();
        extraScreenshotHelper.captureExtraScreenshot((Activity)var1_1, extraScreenshotHelper.onCaptureListener);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ExtraScreenshotHelper x02, Bitmap x12, OnCaptureListener x22) {
        void var2_2;
        void var1_1;
        x02.saveBitmap((Bitmap)var1_1, (OnCaptureListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"NULL_DEREFERENCE"})
    public void init(OnCaptureListener onCaptureListener) {
        void var1_1;
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.onCaptureListener = var1_1;
        extraScreenshotHelper.subscribeToCurranActivityLifeCycle();
        extraScreenshotHelper.subscribeToFragmentsLifecycle();
        InvocationManager.getInstance().switchOffInvocation();
        PresentationManager.getInstance().setInInstabugContext(true);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void release() {
        Object object = this.captureBtnWeakReference;
        if (object != null && (object = (View)((Reference)object).get()) != null) {
            object.setOnClickListener(null);
        }
        this.onCaptureListener = null;
        this.windowManagerWeakReference = null;
        this.captureBtnWeakReference = null;
        object = this.currentActivityLifeCycleSubscriber;
        if (object != null) {
            object.unsubscribe();
            this.currentActivityLifeCycleSubscriber = null;
        }
        if ((object = this.fragmentsLifeCycleSubscriber) != null) {
            object.dispose();
            this.fragmentsLifeCycleSubscriber = null;
        }
        PresentationManager.getInstance().setInInstabugContext(false);
        InvocationManager.getInstance().switchOnInvocation();
    }

    @Override
    public void handleActivityResumed() {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
        } else {
            InstabugSDKLogger.v("IBG-Core", "Couldn't handle resume event current activity equal null");
        }
    }

    @Override
    public void handleActivityPaused() {
        this.hide();
    }

    public void cancel() {
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.hide();
        extraScreenshotHelper.release();
    }

    public static interface OnCaptureListener {
        public void onExtraScreenshotCaptured(Uri var1);

        public void onExtraScreenshotError(Throwable var1);
    }
}

