/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ActivityLifecycleSubscriber;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.DefaultActivityLifeCycleEventHandler;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.internal.InstabugMediaProjectionIntent;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.video.RequestPermissionActivity;
import com.instabug.library.internal.video.ScreenRecordingContract;
import com.instabug.library.internal.video.ScreenRecordingFileHolder;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.model.session.SessionState;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import io.reactivexport.disposables.Disposable;
import io.reactivexport.functions.Consumer;
import java.io.File;

public class InternalAutoScreenRecorderHelper
implements ScreenRecordingContract,
DefaultActivityLifeCycleEventHandler {
    @Nullable
    private static InternalAutoScreenRecorderHelper INSTANCE;
    private ScreenRecordingFileHolder fileHolder;
    private Disposable sessionDisposable;
    @Nullable
    private ActivityLifecycleSubscriber activityLifeCycleSubscriber;
    private boolean isCrashOccurred;

    public InternalAutoScreenRecorderHelper() {
        ScreenRecordingFileHolder screenRecordingFileHolder;
        InternalAutoScreenRecorderHelper internalAutoScreenRecorderHelper = this_;
        internalAutoScreenRecorderHelper.activityLifeCycleSubscriber = null;
        internalAutoScreenRecorderHelper.isCrashOccurred = false;
        ScreenRecordingFileHolder this_ = screenRecordingFileHolder;
        screenRecordingFileHolder = new ScreenRecordingFileHolder();
        internalAutoScreenRecorderHelper.fileHolder = this_;
        internalAutoScreenRecorderHelper.subscribeToSessionEvents();
        internalAutoScreenRecorderHelper.subscribeToActivityLifeCycleEvents();
    }

    private void subscribeToSessionEvents() {
        Disposable disposable = this.sessionDisposable;
        if (disposable == null || disposable.isDisposed()) {
            this.sessionDisposable = SessionStateEventBus.getInstance().subscribe(new Consumer(){

                public void a(SessionState sessionState) {
                    if (sessionState == SessionState.FINISH && !InternalAutoScreenRecorderHelper.this.isCrashOccurred() && InternalAutoScreenRecorderHelper.this.isEnabled()) {
                        AutoScreenRecordingEventBus.getInstance().post(ScreenRecordingService.Action.STOP_DELETE);
                        SettingsManager.getInstance().setAutoScreenRecordingDenied(false);
                        InternalAutoScreenRecorderHelper.this.unsubscribeFromSessionEvents();
                    }
                }
            });
        }
    }

    private void unsubscribeFromSessionEvents() {
        if (!this.sessionDisposable.isDisposed()) {
            this.sessionDisposable.dispose();
        }
    }

    private void subscribeToActivityLifeCycleEvents() {
        if (this.activityLifeCycleSubscriber == null) {
            this.activityLifeCycleSubscriber = CoreServiceLocator.createActivityLifecycleSubscriber(this);
            this.activityLifeCycleSubscriber.subscribe();
        }
    }

    public static InternalAutoScreenRecorderHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalAutoScreenRecorderHelper();
        }
        return INSTANCE;
    }

    @VisibleForTesting
    static void release() {
        Object object = INSTANCE;
        if (object != null && (object = ((InternalAutoScreenRecorderHelper)object).activityLifeCycleSubscriber) != null) {
            object.unsubscribe();
        }
        INSTANCE = null;
    }

    static void setStaticIntentData(@Nullable Intent staticIntentData) {
        InstabugMediaProjectionIntent.setMediaProjectionIntent(staticIntentData);
    }

    static void setStaticResultCode(int staticResultCode) {
        InstabugMediaProjectionIntent.setStaticResultCode(staticResultCode);
    }

    public boolean isCrashOccurred() {
        return this.isCrashOccurred;
    }

    /*
     * WARNING - void declaration
     */
    public void setCrashOccurred(boolean isCrashOccurred) {
        void var1_1;
        this.isCrashOccurred = var1_1;
    }

    @Override
    public void handleActivityResumed() {
        if (this.isEnabled() && !SettingsManager.getInstance().isProcessingForeground()) {
            this.subscribeToSessionEvents();
            new Handler().postDelayed(() -> InternalAutoScreenRecorderHelper.getInstance().start(), 700L);
        }
    }

    public void start() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (!SettingsManager.getInstance().isScreenCurrentlyRecorded() && !SettingsManager.getInstance().isAutoScreenRecordingDenied() && internalAutoScreenRecorderHelper.isEnabled()) {
            InternalAutoScreenRecorderHelper internalAutoScreenRecorderHelper = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
            if (internalAutoScreenRecorderHelper != null && !(internalAutoScreenRecorderHelper instanceof _InstabugActivity) && SettingsManager.getInstance().isAppOnForeground() && InstabugStateProvider.getInstance().getState() == InstabugState.ENABLED && !InstabugCore.isForegroundBusy()) {
                Intent intent;
                InternalAutoScreenRecorderHelper internalAutoScreenRecorderHelper2 = internalAutoScreenRecorderHelper;
                Intent intent2 = intent;
                intent = new Intent((Context)internalAutoScreenRecorderHelper, RequestPermissionActivity.class);
                internalAutoScreenRecorderHelper2.startActivity(intent2);
                internalAutoScreenRecorderHelper2.overridePendingTransition(0, 0);
            }
            return;
        }
    }

    @Override
    @Nullable
    public Uri getAutoScreenRecordingFileUri() {
        return this.fileHolder.getAutoScreenRecordingFileUri();
    }

    @Override
    public void delete() {
        this.fileHolder.delete();
    }

    @Override
    public void clear() {
        this.fileHolder.clear();
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.getInstance().isAutoScreenRecordingEnabled();
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoScreenRecordingFile(File autoScreenRecordingFile) {
        void var1_1;
        this.fileHolder.setAutoScreenRecordingFile((File)var1_1);
    }
}

