/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.OnSdkInvokedCallback;
import com.instabug.library.Platform;
import com.instabug.library.a0;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.plugin.c;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.experiments.a;
import com.instabug.library.internal.orchestrator.Action;
import com.instabug.library.internal.orchestrator.ActionsOrchestrator;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.servicelocator.application.b;
import com.instabug.library.internal.storage.ProcessedBytes;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributeCacheManager;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.model.Report;
import com.instabug.library.model.common.Session;
import com.instabug.library.model.v3Session.IBGInMemorySession;
import com.instabug.library.o;
import com.instabug.library.sessionV3.configurations.IBGSessionCrashesConfigurations;
import com.instabug.library.sessionV3.di.f;
import com.instabug.library.sessionV3.manager.i;
import com.instabug.library.sessionV3.sync.SessionBatchingFilter;
import com.instabug.library.sessionV3.sync.e;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.settings.d;
import com.instabug.library.tracking.ComposeLifeCycleMonitor;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.tracking.g;
import com.instabug.library.tracking.s0;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.j;
import com.instabug.library.v;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

public class InstabugCore {
    public static boolean isFeaturesFetchedBefore() {
        return o.c().f();
    }

    public static Feature.State getFeatureState(String feature) {
        String string2;
        return o.c().b((Object)string2);
    }

    public static boolean isFeatureAvailable(String feature) {
        String string2;
        return o.c().c((Object)string2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isDatabaseTransactionDisabled(@NonNull Context context) {
        Context context2;
        return o.c().c(context2);
    }

    public static boolean isExperimentalFeatureAvailable(String feature) {
        String string2;
        return o.c().d(string2);
    }

    @Nullable
    public static LinkedHashMap<Uri, String> getExtraAttachmentFiles() {
        return SettingsManager.getInstance().getExtraAttachmentFiles();
    }

    public static String getSDKVersion() {
        return "12.4.0";
    }

    public static int getStartedActivitiesCount() {
        return s0.b().getCount();
    }

    public static void startVitalComponents(@Nullable Application application) {
        if (application != null) {
            Application application2;
            s0.b().a();
            InstabugInternalTrackingDelegate.init(application2);
        }
    }

    public static int getPrimaryColor() {
        return SettingsManager.getInstance().getPrimaryColor();
    }

    public static InstabugColorTheme getTheme() {
        return SettingsManager.getInstance().getTheme();
    }

    public static String getIdentifiedUserEmail() {
        return com.instabug.library.user.g.f();
    }

    @Nullable
    public static String getEnteredEmail() {
        return com.instabug.library.user.g.d();
    }

    public static void setEnteredEmail(String enteredEmail) {
        com.instabug.library.user.g.e(enteredEmail);
    }

    @Nullable
    public static String getIdentifiedUsername() {
        return com.instabug.library.user.g.g();
    }

    public static String getUserData() {
        return SettingsManager.getInstance().getUserData();
    }

    public static void setIdentifiedUserEmail(String userEmail) {
        com.instabug.library.user.g.g(userEmail);
    }

    public static void setEnteredUsername(String enteredUsername) {
        com.instabug.library.user.g.f(enteredUsername);
    }

    @Nullable
    public static String getEnteredUsername() {
        return com.instabug.library.user.g.e();
    }

    @Nullable
    public static OnSdkInvokedCallback getOnSdkInvokedCallback() {
        return SettingsManager.getInstance().getOnSdkInvokedCallback();
    }

    public static String getTagsAsString() {
        return SettingsManager.getInstance().getTagsAsString();
    }

    public static void setLastContactedAt(long time) {
        long l10;
        SettingsManager.getInstance().setLastContactedAt(l10);
    }

    public static boolean isUserLoggedOut() {
        return SettingsManager.getInstance().isUserLoggedOut();
    }

    public static boolean isForegroundBusy() {
        return SettingsManager.getInstance().isPromptOptionsScreenShown() || SettingsManager.getInstance().isRequestPermissionScreenShown() || SettingsManager.getInstance().isOnboardingShowing() || c.h();
    }

    /*
     * WARNING - void declaration
     */
    public static void setFeatureState(String feature, Feature.State state) {
        void var1_1;
        String string2;
        o.c().a(string2, (Feature.State)var1_1);
    }

    public static int getSessionCount() {
        return SettingsManager.getInstance().getSessionsCount();
    }

    public static long getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt().getTime();
    }

    public static Plugin getXPlugin(Class clazz) {
        return c.a(clazz);
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    @Nullable
    public static Activity getTargetActivity() {
        return InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
    }

    @Nullable
    public static Object getLastSeenView() {
        return InstabugInternalTrackingDelegate.getInstance().getLastSeenView();
    }

    public static boolean isFeatureEnabled(String feature) {
        String string2;
        return o.c().b((Object)string2) == Feature.State.ENABLED;
    }

    public static void setPushNotificationState(Feature.State state) {
        Feature.State state2;
        o.c().a("PUSH_NOTIFICATION", state2);
    }

    public static void setBugReportingState(Feature.State state) {
        Feature.State state2;
        o.c().a("BUG_REPORTING", state2);
        if (state == Feature.State.DISABLED) {
            AutoScreenRecordingEventBus.getInstance().post(ScreenRecordingService.Action.STOP_DELETE);
        } else {
            InternalAutoScreenRecorderHelper.getInstance().start();
        }
    }

    public static void setMessagingState(Feature.State state) {
        Feature.State state2;
        o.c().a("IN_APP_MESSAGING", state2);
    }

    public static void setRepliesState(Feature.State state) {
        Feature.State state2;
        o.c().a("REPLIES", state2);
    }

    public static boolean encryptBeforeMarshmallow(@NonNull String filePath) {
        if (Build.VERSION.SDK_INT < 23) {
            String string2;
            return InstabugCore.encrypt(string2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean encrypt(@NonNull String filePath) {
        void var0_3;
        try {
            return FileUtils.encryptFile(filePath);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        InstabugSDKLogger.e("IBG-Core", "Can't Encrypt attachment", (Throwable)var0_3);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean decrypt(@NonNull String filePath) {
        void var0_3;
        try {
            return FileUtils.decryptFile(filePath);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        InstabugSDKLogger.e("IBG-Core", "Can't Decrypt attachment", (Throwable)var0_3);
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProcessedBytes decryptOnTheFly(String filePath) {
        void var0_3;
        block5: {
            byte[] byArray;
            File file;
            Object object;
            try {
                if (FileUtils.isEncryptedFile(filePath)) {
                    return FileUtils.decryptOnTheFly((String)object);
                }
                File file2 = new File((String)object);
                file = file2;
                byArray = new byte[(int)file2.length()];
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                break block5;
            }
            catch (Exception exception) {
                // empty catch block
                break block5;
            }
            object = byArray;
            {
                FileUtils.read(file, byArray);
                return new ProcessedBytes((byte[])object, true);
            }
        }
        InstabugSDKLogger.e("IBG-Core", "Can't Decrypt attachment", (Throwable)var0_3);
        return new ProcessedBytes(new byte[0], false);
    }

    public static void setAutoScreenRecordingEnabled(boolean autoScreenRecordingEnabled) {
        boolean bl;
        SettingsManager.getInstance().setAutoScreenRecordingEnabled(bl);
    }

    public static boolean isAutoScreenRecordingEnabled() {
        return SettingsManager.getInstance().isAutoScreenRecordingEnabled();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Plugin> void setPluginState(Class<T> clazz, int state) {
        Plugin plugin = InstabugCore.getXPlugin(clazz);
        if (plugin != null) {
            void var1_1;
            plugin.setState((int)var1_1);
        }
    }

    public static long getLastSeenTimestamp() {
        return SettingsManager.getInstance().getLastSeenTimestamp();
    }

    public static void setLastSeenTimestamp(long currentTimeMillis) {
        long l10;
        SettingsManager.getInstance().setLastSeenTimestamp(l10);
    }

    public static void setInitialScreenShotAllowed(boolean initialScreenShotAllowed) {
        SettingsManager.setInitialScreenShotAllowed(initialScreenShotAllowed);
    }

    public static void isInitialScreenShotAllowed() {
        SettingsManager.isInitialScreenShotAllowed();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static HashMap<String, String> retrieveAllSDKAttributes() {
        return UserAttributeCacheManager.retrieveAllSDKAttributes();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static com.instabug.library.internal.servicelocator.e getApplicationScopeServiceLocator() {
        return b.a();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void doOnBackground(@NonNull Runnable runnable) {
        Runnable runnable2;
        if (runnable == null) {
            return;
        }
        ActionsOrchestrator.obtainOrchestrator().addWorkerThreadAction(new Action(){

            @Override
            public void run() throws Exception {
                runnable2.run();
            }
        }).orchestrate();
    }

    public static boolean isFirstRunAfterEncryptorUpdate() {
        return SettingsManager.getInstance().isFirstRunAfterEncryptorUpdate();
    }

    public static void setFirstRunAfterEncryptorUpdate(boolean isFirstRun) {
        boolean bl;
        SettingsManager.getInstance().setFirstRunAfterEncryptorUpdate(bl);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void setPushNotificationToken(String token) {
        SettingsManager.setPushNotificationToken(token);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getPushNotificationToken() {
        return SettingsManager.getPushNotificationToken();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void setPushNotificationTokenSent(boolean isSent) {
        SettingsManager.setPushNotificationTokenSent(isSent);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isPushNotificationTokenSent() {
        return SettingsManager.isPushNotificationTokenSent();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static boolean isUsersPageEnabled() {
        return SettingsManager.getInstance().isUsersPageEnabled();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Session getRunningSession() {
        Session session = f.y().a();
        if (session != null) {
            return session;
        }
        return a0.e().c();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getLatestV3SessionId() {
        return i.a.j();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static IBGInMemorySession getRunningV3Session() {
        return i.a.e();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static IBGInMemorySession getLatestV3Session() {
        return i.a.i();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static IBGSessionCrashesConfigurations getV3SessionCrashesConfigurations() {
        return f.s();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void setTemporaryDisabled() {
        InstabugSDKLogger.d("IBG-Core", "setTemporaryDisabled disable the SDK internally");
        o.c().i();
        Method method = v.b(Instabug.class, "disableInternal");
        if (method != null) {
            try {
                method.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getCurrentView() {
        int n10 = SettingsManager.getInstance().getCurrentPlatform();
        if (n10 != 4 && n10 != 8 && n10 != 7) {
            return CoreServiceLocator.getActiveScreenEvaluator().a(CoreServiceLocator.getScreensRoot());
        }
        return g.b().a();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Report.OnReportCreatedListener getOnReportCreatedListener() {
        return SettingsManager.getInstance().getOnReportCreatedListener();
    }

    @Platform
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static int getPlatform() {
        return SettingsManager.getInstance().getCurrentPlatform();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isAPMEnabled() {
        block3: {
            Plugin plugin = c.a(Class.forName("com.instabug.apm.APMPlugin"));
            if (plugin == null) break block3;
            try {
                return plugin.isFeatureEnabled();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isCrashReportingEnabled() {
        block3: {
            Plugin plugin = c.a(Class.forName("com.instabug.crash.CrashPlugin"));
            if (plugin == null) break block3;
            try {
                return plugin.isFeatureEnabled();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return false;
    }

    public static Locale getLocale(@Nullable Context context) {
        Context context2;
        return SettingsManager.getInstance().getInstabugLocale(context2);
    }

    public static int getEncryptorVersion() {
        com.instabug.library.settings.f f10 = com.instabug.library.settings.f.s();
        if (f10 != null) {
            return f10.g();
        }
        return 1;
    }

    public static void saveEncryptorVersion(int version) {
        com.instabug.library.settings.f f10 = com.instabug.library.settings.f.s();
        if (f10 != null) {
            int n10;
            f10.c(n10);
        }
    }

    public static Feature.State getEncryptionState() {
        return SettingsManager.getInstance().getFeatureState("ENCRYPTION", false);
    }

    public static long getFirstSeen() {
        return SettingsManager.getInstance().getFirstSeen();
    }

    /*
     * WARNING - void declaration
     */
    public static void reportError(Throwable error, String message) {
        void var1_1;
        IBGDiagnostics.reportNonFatal(error, (String)var1_1);
    }

    public static boolean isDbEncryptionEnabled() {
        return o.c().a() == Feature.State.ENABLED;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean canPrintLog(int logLevel) {
        int n10;
        int n11 = SettingsManager.getInstance().getLogLevel();
        return n11 != 0 && n10 <= n11;
    }

    @Nullable
    @WorkerThread
    public static List<String> getExperiments(float percentage) {
        a a10 = com.instabug.library.experiments.di.a.c();
        if (a10 != null) {
            float f10;
            return a10.a(f10);
        }
        return null;
    }

    public static boolean isLastSDKStateEnabled(@NonNull Context context) {
        Context context2;
        return new d(context2).c();
    }

    public static void cleanVisualUserSteps() {
        CoreServiceLocator.getReproStepsProxy().f();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isV3SessionEnabled() {
        return f.r().e();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void notifyV3SessionDataReadiness(SessionBatchingFilter batchingFilter) {
        SessionBatchingFilter sessionBatchingFilter;
        f.B().a(sessionBatchingFilter);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void forceV3SessionsEvaluation(SessionBatchingFilter batchingFilter) {
        SessionBatchingFilter sessionBatchingFilter;
        e.a.a(sessionBatchingFilter);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static ComposeLifeCycleMonitor getComposeLifeCycleMonitor() {
        return CoreServiceLocator.getComposeLifeCycleMonitor();
    }

    public static void handlePbiFooter(@Nullable View view) {
        j.a(view);
    }

    /*
     * WARNING - void declaration
     */
    public static void handlePbiFooterThemeColor(@Nullable View view, @ColorRes int lightColor, @ColorRes int darkColor) {
        void var2_2;
        void var1_1;
        Object object = (int)var1_1;
        j.a(view, (Integer)object, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void setPbiFooterThemeColor(@Nullable View view, @ColorInt int targetColor) {
        void var1_1;
        j.a(view, (int)var1_1);
    }

    public static boolean isFullScreen() {
        return SettingsManager.getInstance().isFullscreen();
    }
}

