/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.internal.orchestrator.ActionsOrchestrator;
import com.instabug.library.internal.orchestrator.l;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.internal.video.f;
import com.instabug.library.model.common.Session;
import com.instabug.library.model.session.NullSessionException;
import com.instabug.library.model.session.SessionLocalEntity;
import com.instabug.library.model.session.SessionMapper;
import com.instabug.library.model.session.SessionState;
import com.instabug.library.o;
import com.instabug.library.session.h;
import com.instabug.library.sessioncontroller.a;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.s0;
import com.instabug.library.user.g;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.z;
import io.reactivexport.b;
import io.reactivexport.schedulers.Schedulers;
import io.reactivexport.u;
import io.reactivexport.v;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class a0 {
    @Nullable
    private static a0 d;
    private final SettingsManager a;
    @Nullable
    @VisibleForTesting
    IBGDisposable b;
    @Nullable
    private com.instabug.library.model.common.a c;

    private a0(SettingsManager settingsManager) {
        a0 a02 = this;
        a02.a = settingsManager;
        a02.p();
    }

    public static synchronized a0 e() {
        a0 a02 = d;
        if (a02 == null) {
            a0 a03;
            a02 = a03;
            d = new a0(SettingsManager.getInstance());
        }
        return a02;
    }

    public static synchronized void a(SettingsManager settingsManager) {
        if (d == null) {
            d = new a0(settingsManager);
        }
    }

    private void i() {
        if (this.a.getSessionStartedAt() != 0L) {
            com.instabug.library.model.common.a a10 = this.c;
            if (a10 != null) {
                a0 a02 = this;
                a02.a(a10);
                a02.l();
                a02.m();
                a02.a(SessionState.FINISH);
            }
        } else {
            InstabugSDKLogger.d("IBG-Core", "Instabug is enabled after session started, Session ignored");
        }
        this.n();
    }

    private void n() {
        this.c(null);
    }

    private void m() {
        long l10 = System.currentTimeMillis();
        InstabugCore.setLastSeenTimestamp(l10);
        ActionsOrchestrator.obtainOrchestrator(PoolProvider.getSingleThreadExecutor("last-seen-record")).addWorkerThreadAction(new l(g.i(), l10)).orchestrate();
    }

    private void a(@NonNull com.instabug.library.model.common.a a10) {
        if (SettingsManager.getInstance().isSessionEnabled()) {
            this.b(a10).a((Object sessionLocalEntity) -> {
                if (sessionLocalEntity != null) {
                    return new h().a((SessionLocalEntity)sessionLocalEntity);
                }
                return io.reactivexport.b.a(new NullSessionException("sessionLocalEntity can't be null!"));
            }).a(Schedulers.io()).a(new z(this));
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private u b(@NonNull com.instabug.library.model.common.a a10) {
        return u.a((v v10) -> {
            Context context = Instabug.getApplicationContext();
            boolean bl = InstabugCore.isUsersPageEnabled();
            if (context != null) {
                v10.onSuccess(new SessionLocalEntity.Factory().create(context, a10, bl));
            }
        });
    }

    private void q() {
        long l10 = System.currentTimeMillis() / 1000L;
        ((a0)((Object)string)).a.setSessionStartedAt(l10);
        if (SettingsManager.getInstance().isFirstRun()) {
            ((a0)((Object)string)).a.setIsFirstRun(false);
        }
        if (SettingsManager.getInstance().getFirstRunAt().getTime() == 0L) {
            ((a0)((Object)string)).a.setFirstRunAt(System.currentTimeMillis());
        }
        ((a0)((Object)string)).a.incrementSessionsCount();
        String string = g.i();
        ActionsOrchestrator.obtainOrchestrator().addWorkerThreadAction(new l(string, l10 *= 1000L)).orchestrate();
    }

    private void l() {
        if (SettingsManager.getInstance().isFirstDismiss()) {
            SettingsManager.getInstance().setIsFirstDismiss(false);
        }
    }

    private void a(SessionState sessionState) {
        if (sessionState.equals((Object)SessionState.FINISH)) {
            SettingsManager.getInstance().setIsAppOnForeground(false);
            IBGCoreEventPublisher.post(IBGSdkCoreEvent.Session.SessionFinished.INSTANCE);
        } else {
            SettingsManager.getInstance().setIsAppOnForeground(true);
            IBGCoreEventPublisher.post(IBGSdkCoreEvent.Session.SessionStarted.INSTANCE);
        }
        SessionStateEventBus.getInstance().post(sessionState);
    }

    private void p() {
        this.b = CurrentActivityLifeCycleEventBus.INSTANCE.subscribe(activityLifeCycleEvent -> {
            if (activityLifeCycleEvent == ActivityLifeCycleEvent.STOPPED) {
                this.h();
            } else if (activityLifeCycleEvent == ActivityLifeCycleEvent.DESTROYED && this.f() == 0 && this.c != null) {
                this.h();
            }
        });
    }

    private int f() {
        return s0.b().getCount();
    }

    private void b(boolean bl) {
        SettingsManager.getInstance().setIsFirstSession(bl);
    }

    @NonNull
    private com.instabug.library.model.common.a a() {
        Object object = this.c;
        if (object != null) {
            return object;
        }
        this.q();
        object = Instabug.getApplicationContext();
        String string = UUID.randomUUID().toString();
        String string2 = DeviceStateProvider.getOS();
        String string3 = g.i();
        object = object != null ? DeviceStateProvider.getAppVersion((Context)object) : null;
        long l10 = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        long l11 = System.nanoTime();
        boolean bl = this.k();
        return SessionMapper.toSession(string, string2, string3, (String)object, l10, l11, bl);
    }

    private void c(@Nullable com.instabug.library.model.common.a a10) {
        this.c = a10;
    }

    private boolean k() {
        if (!o.c().h()) {
            return false;
        }
        long l10 = SettingsManager.getInstance().getSessionStitchingTimeoutInSeconds(1800);
        long l11 = this.g();
        if (l11 != -1L && l11 <= l10) {
            InstabugSDKLogger.v("IBG-Core", "session stitched");
            return false;
        }
        InstabugSDKLogger.v("IBG-Core", "started new billable session");
        return true;
    }

    private long g() {
        long l10 = SettingsManager.getInstance().geLastForegroundTime();
        if (l10 != -1L) {
            return (System.currentTimeMillis() - l10) / 1000L;
        }
        return l10;
    }

    static /* synthetic */ void a(a0 a02, boolean bl) {
        a02.b(bl);
    }

    public long d() {
        if (this.a.getSessionStartedAt() == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() / 1000L - this.a.getSessionStartedAt();
    }

    public synchronized void b() {
        if (o.c().b((Object)"INSTABUG") == Feature.State.ENABLED) {
            SettingsManager.getInstance().setInBackground(true);
            if (o.c().h()) {
                SettingsManager.getInstance().setLastForegroundTime(System.currentTimeMillis());
            }
            this.i();
        }
    }

    public synchronized void o() {
        InstabugSDKLogger.d("IBG-Core", "Instabug is disabled during app session, ending current session");
        SettingsManager.getInstance().setInBackground(false);
        this.i();
    }

    public synchronized void j() {
        this.a(false);
    }

    public synchronized void a(boolean bl) {
        if (com.instabug.library.sessioncontroller.a.d() && !bl) {
            return;
        }
        if (!InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.BUILDING)) {
            a0 a02 = this;
            a02.c(a02.a());
            a02.a(SessionState.START);
            if (SettingsManager.getInstance().isAutoScreenRecordingEnabled()) {
                InternalAutoScreenRecorderHelper.getInstance().start();
            }
        }
    }

    @VisibleForTesting
    void h() {
        Context context = Instabug.getApplicationContext();
        if (context != null) {
            o.c().g(context);
        } else {
            InstabugSDKLogger.e("IBG-Core", "unable to saveFeaturesToSharedPreferences due to null appContext");
        }
        if (this.f() == 0 && Instabug.getApplicationContext() != null && f.a(Instabug.getApplicationContext())) {
            PoolProvider.postIOTask(this::b);
        }
    }

    @Nullable
    public synchronized Session c() {
        return this.c;
    }
}

