/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.settings.SettingsManager;

public class StatusBarUtils {
    public static void setStatusBar(Activity activity) {
        Activity activity2;
        int n10 = Build.VERSION.SDK_INT;
        if (n10 >= 21) {
            Window window = activity2.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(SettingsManager.getInstance().getStatusBarColor());
        }
        if (n10 >= 23) {
            activity2 = activity2.getWindow().getDecorView();
            if (SettingsManager.getInstance().getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                activity2.setSystemUiVisibility(8192);
            } else {
                activity2.setSystemUiVisibility(0);
            }
        }
    }

    public static void setStatusBarForDialog(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Activity activity2;
            Activity activity3 = activity2;
            Window window = activity3.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(activity2.getResources().getColor(17170445));
            View view = activity3.getWindow().getDecorView();
            view.setSystemUiVisibility(view.getSystemUiVisibility() | 0x1000);
        }
    }

    public static void setStatusBarColorForPrompt(Activity activity) {
        Activity activity2;
        if (activity == null) {
            return;
        }
        int n10 = Build.VERSION.SDK_INT;
        if (n10 >= 19 && activity2.getWindow() != null) {
            if (n10 >= 21) {
                activity2.getWindow().addFlags(Integer.MIN_VALUE);
            }
            Activity activity3 = activity2;
            activity3.getWindow().clearFlags(0x4000000);
            activity3.getWindow().addFlags(0x8000000);
            activity3.getWindow().clearFlags(0x4000000);
            if (n10 >= 21) {
                activity2.getWindow().setStatusBarColor(0);
            }
        }
    }

    public static void darkenStatusBarColor(@NonNull Activity activity, int color2) {
        Activity activity2;
        int n10;
        n10 = InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight ? StatusBarUtils.darkenColor(n10) : StatusBarUtils.darkenColor(ContextCompat.getColor((Context)activity2, (int)R.color.instabug_toolbar_color_dark));
        int n11 = Build.VERSION.SDK_INT;
        if (n11 >= 21) {
            Window window = activity2.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(n10);
        }
        if (n11 >= 23) {
            activity2.getWindow().getDecorView().setSystemUiVisibility(0);
        }
    }

    private static int darkenColor(int color2) {
        int n10;
        float[] fArray = new float[3];
        Color.colorToHSV((int)n10, (float[])fArray);
        fArray[2] = fArray[2] * 0.8f;
        return Color.HSVToColor((float[])fArray);
    }

    public static void setTranslucent(@NonNull Activity activity, boolean translucent) {
        if (Build.VERSION.SDK_INT >= 21) {
            Activity activity2;
            int n10;
            void v02 = n10;
            n10 = 0x4000000;
            if (v02 != false) {
                int n11 = n10;
                activity2.getWindow().setFlags(n11, n11);
            } else {
                activity2.getWindow().clearFlags(n10);
            }
        }
    }

    public static int getStatusBarHeight(Activity activity) {
        Activity activity2;
        Rect rect;
        Rect rect2 = rect;
        rect2();
        activity2.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.top;
    }
}

