/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.logging.d;
import com.instabug.library.sessionreplay.di.o;
import com.instabug.library.sessionreplay.model.a;
import com.instabug.library.sessionreplay.model.b;
import com.instabug.library.t;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import org.json.JSONException;
import org.json.JSONObject;

public class InstabugLog {
    public static final String LOG_MESSAGE_DATE_FORMAT = "MM-dd HH:mm:ss.SSS";
    public static final int INSTABUG_LOG_LIMIT = 1000;

    public static void v(String logMessage) {
        String string2;
        PoolProvider.getSingleThreadExecutor("Database-Logging").execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugLog.isInstabugLogsDisabled()) {
                    return;
                }
                InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(g.V).setLogMessageDate(InstabugLog.getDate()));
            }
        });
    }

    public static void d(String logMessage) {
        String string2;
        PoolProvider.getSingleThreadExecutor("Database-Logging").execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugLog.isInstabugLogsDisabled()) {
                    return;
                }
                InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(g.D).setLogMessageDate(InstabugLog.getDate()));
            }
        });
    }

    public static void i(String logMessage) {
        String string2;
        PoolProvider.getSingleThreadExecutor("Database-Logging").execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugLog.isInstabugLogsDisabled()) {
                    return;
                }
                InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(g.I).setLogMessageDate(InstabugLog.getDate()));
            }
        });
    }

    public static void e(String logMessage) {
        String string2;
        PoolProvider.getSingleThreadExecutor("Database-Logging").execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugLog.isInstabugLogsDisabled()) {
                    return;
                }
                InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(g.E).setLogMessageDate(InstabugLog.getDate()));
            }
        });
    }

    public static void w(String logMessage) {
        String string2;
        PoolProvider.getSingleThreadExecutor("Database-Logging").execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugLog.isInstabugLogsDisabled()) {
                    return;
                }
                InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(g.W).setLogMessageDate(InstabugLog.getDate()));
            }
        });
    }

    public static void wtf(String logMessage) {
        String string2;
        PoolProvider.getSingleThreadExecutor("Database-Logging").execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugLog.isInstabugLogsDisabled()) {
                    return;
                }
                InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(g.WTF).setLogMessageDate(InstabugLog.getDate()));
            }
        });
    }

    public static void clearLogs() {
        InstabugLog.clearLogMessages();
    }

    public static void trimLogs(int trimmingLimit) {
        d.d(trimmingLimit);
    }

    public static String getLogs() {
        return InstabugLog.getLogs(1.0f);
    }

    public static String getLogs(float percentage) {
        return InstabugLog.getLogMessages(percentage);
    }

    private static synchronized void addLog(LogMessage logMessage) {
        LogMessage logMessage2;
        o.c().invoke(logMessage2);
    }

    private static void clearLogMessages() {
        d.a(InstabugLog.getInstabugLogsLimit());
    }

    private static String getLogMessages(float percentage) {
        String string2 = "[]";
        try {
            string2 = d.a(percentage, InstabugLog.getInstabugLogsLimit()).toString();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = outOfMemoryError;
            InstabugCore.reportError(outOfMemoryError, "Couldn't parse Instabug logs due to an OOM");
            InstabugSDKLogger.e("IBG-Core", "Couldn't parse Instabug logs due to an OOM", outOfMemoryError2);
        }
        return string2;
    }

    private static long getDate() {
        return InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds();
    }

    private static boolean isInstabugLogsDisabled() {
        return t.c().b((Object)"INSTABUG_LOGS") == Feature.State.DISABLED;
    }

    private static int getInstabugLogsLimit() {
        return CoreServiceLocator.getLimitConstraintApplier().applyConstraints(1000);
    }

    public static class LogMessage
    implements a {
        static final String KEY_LOG_MESSAGE = "log_message";
        static final String KEY_LOG_MESSAGE_LEVEL = "log_message_level";
        static final String KEY_LOG_MESSAGE_DATE = "log_message_date";
        public static final String FAILED_TO_PARSE_INSTABUG_LOG_TO_JSON = "Failed to parse Instabug Log to JSON:";
        public static final String TRIMMING_SUSFIX = "...";
        public static final String NULL_LOG = "null";
        @Nullable
        private String logMessage;
        @Nullable
        private g logMessageLevel;
        private long logMessageDate;

        @NonNull
        private String validateSize(@Nullable String logMessage) {
            String string2;
            if (logMessage == null) {
                return NULL_LOG;
            }
            int n10 = b.a(this);
            if (string2.length() > n10) {
                string2 = string2.substring(0, n10) + TRIMMING_SUSFIX;
            }
            return string2;
        }

        @Nullable
        String getLogMessage() {
            return this.logMessage;
        }

        /*
         * WARNING - void declaration
         */
        LogMessage setLogMessage(String logMessage) {
            void var1_1;
            LogMessage logMessage2 = this;
            logMessage2.logMessage = logMessage2.validateSize((String)var1_1);
            return logMessage2;
        }

        @Nullable
        g getLogMessageLevel() {
            return this.logMessageLevel;
        }

        /*
         * WARNING - void declaration
         */
        LogMessage setLogMessageLevel(g logMessageLevel) {
            void var1_1;
            this.logMessageLevel = var1_1;
            return this;
        }

        long getLogMessageDate() {
            return this.logMessageDate;
        }

        /*
         * WARNING - void declaration
         */
        LogMessage setLogMessageDate(long logMessageDate) {
            void var1_1;
            this.logMessageDate = var1_1;
            return this;
        }

        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public JSONObject toJson() {
            JSONObject jSONObject;
            block8: {
                JSONObject jSONObject2;
                jSONObject = jSONObject2;
                jSONObject();
                String string2 = KEY_LOG_MESSAGE;
                jSONObject2.put(string2, (Object)((LogMessage)((Object)this_)).getLogMessage());
                if (((LogMessage)((Object)this_)).getLogMessageLevel() == null) break block8;
                jSONObject.put(KEY_LOG_MESSAGE_LEVEL, (Object)((LogMessage)((Object)this_)).getLogMessageLevel().toString());
            }
            JSONObject jSONObject3 = jSONObject;
            LogMessage logMessage = this_;
            String this_ = KEY_LOG_MESSAGE_DATE;
            long l10 = logMessage.getLogMessageDate();
            try {
                jSONObject3.put(this_, l10);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e("IBG-Core", "Error while parsing instabug logs", jSONException);
            }
            return jSONObject;
        }

        public long getTimestamp() {
            return this.getLogMessageDate();
        }

        @Override
        @NonNull
        public String getLogType() {
            return "IBG_LOG";
        }

        @Override
        @Nullable
        public JSONObject getSrJsonRep() {
            String string2;
            LogMessage logMessage;
            JSONObject jSONObject;
            JSONObject jSONObject2;
            try {
                JSONObject jSONObject3 = ((LogMessage)((Object)this_)).toJson();
                jSONObject2 = jSONObject3;
                jSONObject = jSONObject3;
                logMessage = this_;
                string2 = "log_type";
            }
            catch (JSONException jSONException) {
                IBGDiagnostics.reportNonFatalAndLog(jSONException, FAILED_TO_PARSE_INSTABUG_LOG_TO_JSON, "IBG-Core");
                return null;
            }
            JSONObject jSONObject4 = jSONObject2.put(string2, (Object)logMessage.getLogType());
            LogMessage logMessage2 = this_;
            String this_ = "timestamp";
            long l10 = logMessage2.getTimestamp();
            jSONObject4.put(this_, l10);
            return jSONObject;
        }
    }

    static final class g
    extends Enum {
        public static final /* enum */ g V;
        public static final /* enum */ g D;
        public static final /* enum */ g I;
        public static final /* enum */ g E;
        public static final /* enum */ g W;
        public static final /* enum */ g WTF;
        private static final /* synthetic */ g[] $VALUES;
        private final String level;

        public static g[] values() {
            return (g[])$VALUES.clone();
        }

        public static g valueOf(String name) {
            String string2;
            return Enum.valueOf(g.class, string2);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private g() {
            void var3_2;
            void var2_-1;
            void var1_-1;
            this.level = var3_2;
        }

        static {
            g g10;
            g g11;
            g g12;
            g g13;
            g g14;
            g g15;
            g g16 = g15;
            V = new g("V", 0, "v");
            g g17 = g14;
            D = new g("D", 1, "d");
            g g18 = g13;
            I = new g("I", 2, "i");
            g g19 = g12;
            E = new g("E", 3, "e");
            g g20 = g11;
            W = new g("W", 4, "w");
            g g21 = g10;
            WTF = new g("WTF", 5, "wtf");
            $VALUES = new g[]{g16, g17, g18, g19, g20, g21};
        }

        @NonNull
        public String toString() {
            return this.level;
        }
    }
}

