/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Property;
import android.util.TypedValue;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.library.ui.custom.MaterialMenu;

@RequiresApi(api=14)
public class MaterialMenuDrawable
extends Drawable
implements MaterialMenu,
Animatable {
    public static final int DEFAULT_COLOR = -1;
    public static final int DEFAULT_SCALE = 1;
    public static final int DEFAULT_TRANSFORM_DURATION = 800;
    public static final boolean DEFAULT_VISIBLE = true;
    private static final int BASE_DRAWABLE_WIDTH = 40;
    private static final int BASE_DRAWABLE_HEIGHT = 40;
    private static final int BASE_ICON_WIDTH = 20;
    private static final int BASE_CIRCLE_RADIUS = 18;
    private static final float ARROW_MID_LINE_ANGLE = 180.0f;
    private static final float ARROW_TOP_LINE_ANGLE = 135.0f;
    private static final float ARROW_BOT_LINE_ANGLE = 225.0f;
    private static final float X_TOP_LINE_ANGLE = 44.0f;
    private static final float X_BOT_LINE_ANGLE = -44.0f;
    private static final float X_ROTATION_ANGLE = 90.0f;
    private static final float CHECK_MIDDLE_ANGLE = 135.0f;
    private static final float CHECK_BOTTOM_ANGLE = -90.0f;
    private static final float TRANSFORMATION_START = 0.0f;
    private static final float TRANSFORMATION_MID = 1.0f;
    private static final float TRANSFORMATION_END = 2.0f;
    private static final int DEFAULT_CIRCLE_ALPHA = 200;
    private final float diph;
    private final float dip1;
    private final float dip2;
    private final float dip3;
    private final float dip4;
    private final float dip8;
    private final int width;
    private final int height;
    private final float strokeWidth;
    private final float iconWidth;
    private final float topPadding;
    private final float sidePadding;
    private final float circleRadius;
    private final Stroke stroke;
    private final Object lock;
    private final Paint iconPaint;
    private final Paint circlePaint;
    private float transformationValue;
    private boolean transformationRunning;
    private IconState currentIconState;
    private AnimationState animationState;
    @Nullable
    private IconState animatingIconState;
    private boolean visible;
    private boolean rtlEnabled;
    private ObjectAnimator transformation;
    @Nullable
    private Animator.AnimatorListener animatorListener;
    private MaterialMenuState materialMenuState;
    private Property<MaterialMenuDrawable, Float> transformationProperty;

    /*
     * WARNING - void declaration
     */
    public MaterialMenuDrawable(Context context, int color2, Stroke stroke) {
        this((Context)var1_1, (int)var2_2, (Stroke)var3_3, 1, 800);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MaterialMenuDrawable(Context context, int color2, Stroke stroke, int transformDuration) {
        this((Context)var1_1, (int)var2_2, (Stroke)var3_3, 1, (int)var4_4);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MaterialMenuDrawable(Context context, int color2, Stroke stroke, int scale, int transformDuration) {
        void var5_9;
        void var2_3;
        float f10;
        int n10;
        void var3_5;
        float f11;
        float f12;
        int n11;
        Resources resources;
        MaterialMenuDrawable materialMenuDrawable = this;
        this.lock = new Object();
        this.iconPaint = new Paint();
        this.circlePaint = new Paint();
        this.transformationValue = 0.0f;
        this.transformationRunning = false;
        this.currentIconState = IconState.BURGER;
        this.animationState = AnimationState.BURGER_ARROW;
        this.transformationProperty = new Property<MaterialMenuDrawable, Float>(this, Float.class, "transformation"){
            final /* synthetic */ MaterialMenuDrawable this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((Class)var2_2, (String)var3_3);
            }

            public Float get(MaterialMenuDrawable object) {
                return object.getTransformationValue();
            }

            /*
             * WARNING - void declaration
             */
            public void set(MaterialMenuDrawable object, Float value) {
                void var2_2;
                object.setTransformationValue((Float)var2_2);
            }
        };
        resources = resources.getResources();
        MaterialMenuDrawable materialMenuDrawable2 = this;
        float f13 = n11;
        this.dip1 = f12 = MaterialMenuDrawable.dpToPx(resources, 1.0f) * f13;
        this.dip2 = MaterialMenuDrawable.dpToPx(resources, 2.0f) * f13;
        this.dip3 = f11 = MaterialMenuDrawable.dpToPx(resources, 3.0f) * f13;
        this.dip4 = MaterialMenuDrawable.dpToPx(resources, 4.0f) * f13;
        this.dip8 = MaterialMenuDrawable.dpToPx(resources, 8.0f) * f13;
        this.diph = f12 / 2.0f;
        materialMenuDrawable2.stroke = var3_5;
        materialMenuDrawable2.visible = true;
        this.width = n10 = (int)(MaterialMenuDrawable.dpToPx(resources, 40.0f) * f13);
        this.height = n11 = (int)(MaterialMenuDrawable.dpToPx(resources, 40.0f) * f13);
        this.iconWidth = f10 = MaterialMenuDrawable.dpToPx(resources, 20.0f) * f13;
        this.circleRadius = MaterialMenuDrawable.dpToPx(resources, 18.0f) * f13;
        materialMenuDrawable.strokeWidth = MaterialMenuDrawable.dpToPx(resources, ((Stroke)var3_5).strokeWidth) * f13;
        materialMenuDrawable.sidePadding = ((float)n10 - f10) / 2.0f;
        materialMenuDrawable.topPadding = ((float)n11 - f11 * 5.0f) / 2.0f;
        this.initPaint((int)var2_3);
        this.initAnimations((int)var5_9);
        this.materialMenuState = new MaterialMenuState();
    }

    /*
     * WARNING - void declaration
     */
    private MaterialMenuDrawable(int color2, Stroke stroke, long transformDuration, int width, int height, float iconWidth, float circleRadius, float strokeWidth, float dip1) {
        void var3_4;
        void var1_1;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var2_3;
        void var10_10;
        this.lock = new Object();
        this.iconPaint = new Paint();
        this.circlePaint = new Paint();
        this.transformationValue = 0.0f;
        this.transformationRunning = false;
        this.currentIconState = IconState.BURGER;
        this.animationState = AnimationState.BURGER_ARROW;
        this.transformationProperty = new /* invalid duplicate definition of identical inner class */;
        this.dip1 = var10_10;
        this.dip2 = var10_10 * 2.0f;
        void var1_2 = var10_10 * 3.0f;
        this.dip3 = var1_2;
        this.dip4 = var10_10 * 4.0f;
        this.dip8 = var10_10 * 8.0f;
        this.diph = var10_10 / 2.0f;
        this.stroke = var2_3;
        this.width = var5_5;
        this.height = var6_6;
        this.iconWidth = var7_7;
        this.circleRadius = var8_8;
        this.strokeWidth = var9_9;
        this.sidePadding = ((float)var5_5 - var7_7) / 2.0f;
        this.topPadding = ((float)var6_6 - var1_2 * 5.0f) / 2.0f;
        this.initPaint((int)var1_1);
        this.initAnimations((int)var3_4);
        this.materialMenuState = new MaterialMenuState();
    }

    private void initPaint(int color2) {
        int n10;
        MaterialMenuDrawable materialMenuDrawable = this;
        materialMenuDrawable.iconPaint.setAntiAlias(true);
        materialMenuDrawable.iconPaint.setStyle(Paint.Style.STROKE);
        materialMenuDrawable.iconPaint.setStrokeWidth(this.strokeWidth);
        materialMenuDrawable.iconPaint.setColor(n10);
        materialMenuDrawable.circlePaint.setAntiAlias(true);
        materialMenuDrawable.circlePaint.setStyle(Paint.Style.FILL);
        materialMenuDrawable.circlePaint.setColor(n10);
        materialMenuDrawable.circlePaint.setAlpha(200);
        int n11 = materialMenuDrawable.width;
        n10 = materialMenuDrawable.height;
        materialMenuDrawable.setBounds(0, 0, n11, n10);
    }

    /*
     * WARNING - void declaration
     */
    private void drawMiddleLine(Canvas canvas, float ratio) {
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this_;
        void v12 = var1_1;
        v12.restore();
        v12.save();
        float f10 = 0.0f;
        int n10 = materialMenuDrawable.width;
        float f11 = (float)n10 / 2.0f;
        float f12 = (float)n10 / 2.0f;
        float f13 = materialMenuDrawable.sidePadding;
        float f14 = materialMenuDrawable.topPadding;
        float f15 = f14;
        float f16 = this_.dip3;
        float f17 = f15 + f16 / 2.0f * 5.0f;
        f15 = (float)n10 - f13;
        f16 = f14 + f16 / 2.0f * 5.0f;
        int n11 = 255;
        switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$AnimationState[this_.animationState.ordinal()]) {
            default: {
                break;
            }
            case 6: {
                float f18;
                void v32 = f18;
                void v42 = f18;
                void v52 = f18;
                n11 = (int)(v52 * 255.0f);
                f10 = v52 * 135.0f;
                f18 = this_.dip3;
                f13 += v42 * (this_.dip4 + f18 / 2.0f);
                f15 += v32 * this_.dip1;
                f11 = (float)this_.width / 2.0f + f18 + this_.diph;
                break;
            }
            case 5: {
                float f18;
                void v62 = f18;
                void v72 = f18;
                f10 = f18 * 135.0f;
                f18 = this_.dip3;
                f13 += v72 * (this_.dip4 + f18 / 2.0f);
                f15 += v62 * this_.dip1;
                f11 = (float)this_.width / 2.0f + f18 + this_.diph;
                break;
            }
            case 4: {
                float f18;
                f10 = this_.isMorphingForward() ? f18 * 135.0f : 135.0f - (1.0f - f18) * 135.0f;
                f11 = this_.dip3;
                f13 += f11 / 2.0f + this_.dip4 - (1.0f - f18) * this_.dip2;
                f15 += f18 * this_.dip1;
                f11 = (float)this_.width / 2.0f + f11 + this_.diph;
                break;
            }
            case 3: {
                float f18;
                float f19 = 1.0f - f18;
                n11 = (int)(f19 * 255.0f);
                f13 += f19 * this_.dip2;
                break;
            }
            case 2: {
                float f18;
                n11 = (int)((1.0f - f18) * 255.0f);
                break;
            }
            case 1: {
                float f18;
                f10 = this_.isMorphingForward() ? f18 * 180.0f : (1.0f - f18) * 180.0f + 180.0f;
                f15 -= f18 * this_.resolveStrokeModifier(f18) / 2.0f;
            }
        }
        MaterialMenuDrawable materialMenuDrawable2 = this_;
        this_.iconPaint.setAlpha(n11);
        var1_1.rotate(f10, f11, f12);
        MaterialMenuDrawable this_ = this_.iconPaint;
        var1_1.drawLine(f13, f17, f15, f16, (Paint)this_);
        materialMenuDrawable2.iconPaint.setAlpha(255);
    }

    /*
     * WARNING - void declaration
     */
    private void drawTopLine(Canvas canvas, float ratio) {
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this_;
        var1_1.save();
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        int n10 = materialMenuDrawable.width;
        float f14 = (float)n10 / 2.0f + this_.dip3 / 2.0f;
        float f15 = materialMenuDrawable.topPadding;
        float f16 = this_.dip2;
        float f17 = f15 + f16;
        float f18 = this_.sidePadding;
        float f19 = f15 + f16;
        float f20 = (float)n10 - f18;
        f16 = f15 + f16;
        int n11 = 255;
        switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$AnimationState[this_.animationState.ordinal()]) {
            default: {
                break;
            }
            case 6: {
                float f21;
                MaterialMenuDrawable materialMenuDrawable2 = this_;
                f10 = 44.0f;
                f13 = 90.0f;
                f11 = materialMenuDrawable2.sidePadding + this_.dip4;
                f12 = this_.dip3;
                float f22 = materialMenuDrawable2.topPadding + f12;
                f21 = 1.0f - f21;
                float f23 = f12;
                f20 += f23 - f23 * f21;
                f18 += f12;
                int n12 = (int)(f21 * 255.0f);
                f12 = f22;
                n11 = n12;
                break;
            }
            case 5: {
                float f21;
                n11 = (int)((1.0f - f21) * 255.0f);
                break;
            }
            case 4: {
                float f21;
                MaterialMenuDrawable materialMenuDrawable3 = this_;
                n11 = (int)((1.0f - f21) * 255.0f);
                f10 = 225.0f;
                f11 = (float)materialMenuDrawable3.width / 2.0f;
                f12 = (float)materialMenuDrawable3.height / 2.0f;
                f20 -= materialMenuDrawable3.resolveStrokeModifier(1.0f);
                f18 += this_.dip3;
                break;
            }
            case 3: {
                float f21;
                MaterialMenuDrawable materialMenuDrawable4 = this_;
                void v62 = f21;
                f10 = v62 * -181.0f + 225.0f;
                f13 = v62 * 90.0f;
                int n13 = materialMenuDrawable4.width;
                f11 = (float)n13 / 2.0f + (this_.sidePadding + this_.dip4 - (float)n13 / 2.0f) * f21;
                int n14 = materialMenuDrawable4.height;
                f12 = (float)n14 / 2.0f + (this_.topPadding + this_.dip3 - (float)n14 / 2.0f) * f21;
                f20 -= this_.resolveStrokeModifier(f21);
                f18 += this_.dip3;
                break;
            }
            case 2: {
                float f21;
                float f24 = f18;
                MaterialMenuDrawable materialMenuDrawable5 = this_;
                void v92 = f21;
                f10 = v92 * 44.0f;
                f13 = v92 * 90.0f;
                f11 = materialMenuDrawable5.sidePadding + this_.dip4;
                f12 = materialMenuDrawable5.topPadding;
                f18 = materialMenuDrawable5.dip3;
                f12 += f18;
                f18 = f24 + f18 * f21;
                break;
            }
            case 1: {
                float f21;
                f10 = this_.isMorphingForward() ? f21 * 225.0f : (1.0f - f21) * 135.0f + 225.0f;
                MaterialMenuDrawable materialMenuDrawable6 = this_;
                f11 = (float)materialMenuDrawable6.width / 2.0f;
                f12 = (float)materialMenuDrawable6.height / 2.0f;
                f20 -= this_.resolveStrokeModifier(f21);
                f18 += this_.dip3 * f21;
            }
        }
        MaterialMenuDrawable materialMenuDrawable7 = this_;
        this_.iconPaint.setAlpha(n11);
        var1_1.rotate(f10, f11, f12);
        var1_1.rotate(f13, f14, f17);
        MaterialMenuDrawable this_ = this_.iconPaint;
        var1_1.drawLine(f18, f19, f20, f16, (Paint)this_);
        materialMenuDrawable7.iconPaint.setAlpha(255);
    }

    /*
     * WARNING - void declaration
     */
    private void drawBottomLine(Canvas canvas, float ratio) {
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this_;
        void v12 = var1_1;
        v12.restore();
        v12.save();
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        int n10 = materialMenuDrawable.width;
        float f14 = (float)n10 / 2.0f + this_.dip3 / 2.0f;
        int n11 = materialMenuDrawable.height;
        float f15 = this_.topPadding;
        float f16 = this_.dip2;
        float f17 = (float)n11 - f15 - f16;
        float f18 = materialMenuDrawable.sidePadding;
        float f19 = (float)n11 - f15 - f16;
        float f20 = (float)n10 - f18;
        f15 = (float)n11 - f15 - f16;
        switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$AnimationState[this_.animationState.ordinal()]) {
            default: {
                break;
            }
            case 6: {
                float f21;
                float f22 = f20;
                MaterialMenuDrawable materialMenuDrawable2 = this_;
                f10 = 1.0f - f21;
                f13 = f10 * -90.0f;
                f11 = f21 * 89.0f + -44.0f;
                f12 = materialMenuDrawable2.sidePadding;
                f20 = this_.dip4;
                f16 = this_.dip3;
                f12 = f12 + f20 + ((float)this_.width / 2.0f + f16 - f12 - f20) * f21;
                int n12 = materialMenuDrawable2.height;
                float f23 = this_.topPadding;
                f21 = (float)n12 - f23 - f16 + (f23 + (float)n12 / 2.0f - (float)n12) * f21;
                f18 += materialMenuDrawable2.dip8 - (f20 + this_.dip1) * f10;
                f20 = f22 - this_.resolveStrokeModifier(f10);
                float f24 = f11;
                float f25 = f12;
                f12 = f21;
                f11 = f25;
                f10 = f24;
                break;
            }
            case 5: {
                float f21;
                MaterialMenuDrawable materialMenuDrawable3 = this_;
                f10 = f21 * 45.0f;
                f11 = this_.dip3;
                f12 = (float)materialMenuDrawable3.width / 2.0f + f11 * f21;
                f11 = (float)materialMenuDrawable3.height / 2.0f - f11 * f21;
                f18 += materialMenuDrawable3.dip8 * f21;
                f20 -= this_.resolveStrokeModifier(f21);
                float f26 = f12;
                f12 = f11;
                f11 = f26;
                break;
            }
            case 4: {
                float f21;
                MaterialMenuDrawable materialMenuDrawable4 = this_;
                f10 = f21 * -90.0f + 135.0f;
                f11 = this_.dip3;
                f12 = (float)materialMenuDrawable4.width / 2.0f + f11 * f21;
                f11 = (float)materialMenuDrawable4.height / 2.0f - f11 * f21;
                f20 -= materialMenuDrawable4.resolveStrokeModifier(1.0f);
                f18 += this_.dip3 + (this_.dip4 + this_.dip1) * f21;
                float f27 = f12;
                f12 = f11;
                f11 = f27;
                break;
            }
            case 3: {
                float f21;
                MaterialMenuDrawable materialMenuDrawable5 = this_;
                void v11 = f21;
                f10 = v11 * 181.0f + 135.0f;
                f13 = v11 * -90.0f;
                int n13 = materialMenuDrawable5.width;
                f11 = (float)n13 / 2.0f + (this_.sidePadding + this_.dip4 - (float)n13 / 2.0f) * f21;
                int n14 = materialMenuDrawable5.height;
                f12 = (float)n14 / 2.0f + ((float)n14 / 2.0f - this_.topPadding - this_.dip3) * f21;
                f20 -= this_.resolveStrokeModifier(f21);
                f18 += this_.dip3;
                break;
            }
            case 2: {
                float f21;
                f13 = this_.isMorphingForward() ? (f10 = f21 * -90.0f) : (f10 = f21 * 90.0f);
                MaterialMenuDrawable materialMenuDrawable6 = this_;
                f10 = f21 * -44.0f;
                f11 = materialMenuDrawable6.sidePadding + this_.dip4;
                f12 = (float)materialMenuDrawable6.height - this_.topPadding;
                f16 = materialMenuDrawable6.dip3;
                f12 -= f16;
                f18 += f16 * f21;
                break;
            }
            case 1: {
                float f21;
                f10 = this_.isMorphingForward() ? f21 * 135.0f : (1.0f - f21) * 225.0f + 135.0f;
                MaterialMenuDrawable materialMenuDrawable7 = this_;
                int n15 = materialMenuDrawable7.width;
                f11 = (float)n15 / 2.0f;
                f12 = (float)this_.height / 2.0f;
                f20 = (float)n15 - this_.sidePadding - this_.resolveStrokeModifier(f21);
                f18 = materialMenuDrawable7.sidePadding + this_.dip3 * f21;
            }
        }
        void v15 = var1_1;
        v15.rotate(f10, f11, f12);
        v15.rotate(f13, f14, f17);
        MaterialMenuDrawable this_ = this_.iconPaint;
        var1_1.drawLine(f18, f19, f20, f15, (Paint)this_);
    }

    private boolean isMorphingForward() {
        return this.transformationValue <= 1.0f;
    }

    /*
     * WARNING - void declaration
     */
    private float resolveStrokeModifier(float ratio) {
        void var1_2;
        int n10 = 3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$Stroke[this.stroke.ordinal()];
        if (n10 != 1) {
            if (n10 != 2) {
                if (n10 != 3) {
                    return 0.0f;
                }
                AnimationState animationState = this.animationState;
                if (animationState != AnimationState.ARROW_X && animationState != AnimationState.X_CHECK) {
                    return (float)(var1_2 * this.dip4);
                }
                return this.dip4 - (this.dip3 + this.dip1) * var1_2;
            }
            AnimationState animationState = this.animationState;
            if (animationState != AnimationState.ARROW_X && animationState != AnimationState.X_CHECK) {
                return (float)(var1_2 * (this.dip3 + this.diph));
            }
            float f10 = this.dip3;
            float f11 = this.diph;
            return f10 + f11 - (f10 + f11) * var1_2;
        }
        AnimationState animationState = this.animationState;
        if (animationState != AnimationState.ARROW_X && animationState != AnimationState.X_CHECK) {
            return (float)(var1_2 * this.dip3);
        }
        float f12 = this.dip3;
        return f12 - f12 * var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private void initAnimations(int transformDuration) {
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this;
        this.transformation = ObjectAnimator.ofFloat((Object)materialMenuDrawable, materialMenuDrawable.transformationProperty, (float[])new float[]{0.0f});
        this.transformation.setInterpolator((TimeInterpolator)new DecelerateInterpolator(3.0f));
        materialMenuDrawable.transformation.setDuration((long)var1_1);
        materialMenuDrawable.transformation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ MaterialMenuDrawable this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void onAnimationEnd(Animator animation) {
                2 v02 = this;
                MaterialMenuDrawable.access$202(v02.this$0, false);
                MaterialMenuDrawable materialMenuDrawable = v02.this$0;
                materialMenuDrawable.setIconState(materialMenuDrawable.animatingIconState);
            }
        });
    }

    private boolean resolveTransformation() {
        IconState iconState = this.currentIconState;
        IconState iconState2 = IconState.BURGER;
        boolean bl = iconState == iconState2;
        IconState iconState3 = IconState.ARROW;
        boolean bl2 = iconState == iconState3;
        IconState iconState4 = IconState.X;
        boolean bl3 = iconState == iconState4;
        IconState iconState5 = iconState;
        iconState = IconState.CHECK;
        boolean bl4 = iconState5 == iconState;
        IconState iconState6 = this.animatingIconState;
        boolean bl5 = iconState6 == iconState2;
        boolean bl6 = iconState6 == iconState3;
        boolean bl7 = iconState6 == iconState4;
        boolean bl8 = iconState6 == iconState;
        if (bl && bl6 || bl2 && bl5) {
            this.animationState = AnimationState.BURGER_ARROW;
            return bl;
        }
        if (bl2 && bl7 || bl3 && bl6) {
            this.animationState = AnimationState.ARROW_X;
            return bl2;
        }
        if (bl && bl7 || bl3 && bl5) {
            this.animationState = AnimationState.BURGER_X;
            return bl;
        }
        if (bl2 && bl8 || bl4 && bl6) {
            this.animationState = AnimationState.ARROW_CHECK;
            return bl2;
        }
        if (bl && bl8 || bl4 && bl5) {
            this.animationState = AnimationState.BURGER_CHECK;
            return bl;
        }
        if (bl3 && bl8 || bl4 && bl7) {
            this.animationState = AnimationState.X_CHECK;
            return bl3;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.currentIconState;
        objectArray[1] = this.animatingIconState;
        throw new IllegalStateException(String.format("Animating from %s to %s is not supported", objectArray2));
    }

    /*
     * WARNING - void declaration
     */
    static float dpToPx(Resources resources, float dp) {
        void var1_1;
        Resources resources2 = resources.getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)var1_1, (DisplayMetrics)resources2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$202(MaterialMenuDrawable x02, boolean x12) {
        void var1_1;
        var0.transformationRunning = var1_1;
        return x12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void draw(Canvas canvas) {
        v0 = this;
        var2_2 = v0.lock;
        synchronized (var2_2) {
            if (v0.visible) ** GOTO lbl10
            return;
lbl10:
            // 1 sources

            var3_3 = this.transformationValue;
            if (!(v2 <= 1.0f)) {
                var3_3 = 2.0f - var3_3;
            }
            if (!this.rtlEnabled) ** GOTO lbl27
            v3 = var1_1;
            v4 = this;
            v5 = var1_1;
            v6 = v5;
            v5.save();
            v6.scale(-1.0f, 1.0f, 0.0f, 0.0f);
            v7 = -v4.getIntrinsicWidth();
            v3.translate(v7, 0.0f);
lbl27:
            // 2 sources

            v8 = this;
            this.drawTopLine((Canvas)var1_1, var3_3);
            this.drawMiddleLine((Canvas)var1_1, var3_3);
            v8.drawBottomLine((Canvas)var1_1, var3_3);
            if (!v8.rtlEnabled) ** GOTO lbl34
            var1_1.restore();
lbl34:
            // 2 sources

            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAlpha(int alpha) {
        void var1_1;
        this.iconPaint.setAlpha((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void setColorFilter(@Nullable ColorFilter cf) {
        void var1_1;
        this.iconPaint.setColorFilter((ColorFilter)var1_1);
    }

    public int getOpacity() {
        return -2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColor(int color2) {
        void var1_1;
        MaterialMenuDrawable materialMenuDrawable = this;
        materialMenuDrawable.iconPaint.setColor((int)var1_1);
        materialMenuDrawable.circlePaint.setColor((int)var1_1);
        materialMenuDrawable.invalidateSelf();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresApi(api=11)
    public void setTransformationDuration(int duration) {
        void var1_1;
        this.transformation.setDuration((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setInterpolator(Interpolator interpolator) {
        void var1_1;
        this.transformation.setInterpolator((TimeInterpolator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAnimationListener(Animator.AnimatorListener listener) {
        void var1_1;
        Animator.AnimatorListener animatorListener = this.animatorListener;
        if (animatorListener != null) {
            this.transformation.removeListener(animatorListener);
        }
        if (var1_1 != null) {
            this.transformation.addListener((Animator.AnimatorListener)var1_1);
        }
        this.animatorListener = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setIconState(@Nullable IconState iconState) {
        MaterialMenuDrawable materialMenuDrawable = this;
        Object object = materialMenuDrawable.lock;
        synchronized (object) {
            void var1_1;
            if (materialMenuDrawable.transformationRunning) {
                this.transformation.cancel();
                this.transformationRunning = false;
            }
            if (var1_1 != null && this.currentIconState != var1_1) {
                switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$IconState[var1_1.ordinal()]) {
                    default: {
                        break;
                    }
                    case 4: {
                        MaterialMenuDrawable materialMenuDrawable2 = this;
                        materialMenuDrawable2.animationState = AnimationState.BURGER_CHECK;
                        materialMenuDrawable2.transformationValue = 1.0f;
                        break;
                    }
                    case 3: {
                        MaterialMenuDrawable materialMenuDrawable3 = this;
                        materialMenuDrawable3.animationState = AnimationState.BURGER_X;
                        materialMenuDrawable3.transformationValue = 1.0f;
                        break;
                    }
                    case 2: {
                        MaterialMenuDrawable materialMenuDrawable4 = this;
                        materialMenuDrawable4.animationState = AnimationState.BURGER_ARROW;
                        materialMenuDrawable4.transformationValue = 1.0f;
                        break;
                    }
                    case 1: {
                        MaterialMenuDrawable materialMenuDrawable5 = this;
                        materialMenuDrawable5.animationState = AnimationState.BURGER_ARROW;
                        materialMenuDrawable5.transformationValue = 0.0f;
                    }
                }
                this.currentIconState = var1_1;
                this.invalidateSelf();
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void animateIconState(IconState state) {
        MaterialMenuDrawable materialMenuDrawable = this;
        Object object = materialMenuDrawable.lock;
        synchronized (object) {
            void var1_1;
            if (materialMenuDrawable.transformationRunning) {
                this.transformation.end();
            }
            this.animatingIconState = var1_1;
            this.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IconState setTransformationOffset(AnimationState animationState, float offset) {
        void var2_2;
        void cfr_temp_0;
        int n10;
        if (!(offset < 0.0f) && (n10 = (cfr_temp_0 = var2_2 - 2.0f) == 0 ? 0 : (cfr_temp_0 > 0 ? 1 : -1)) <= 0) {
            Object object = objectArray2.lock;
            synchronized (object) {
                IconState iconState;
                objectArray2.animationState = iconState;
                n10 = var2_2 < 1.0f || !n10;
                IconState iconState2 = n10 != 0 ? ((AnimationState)((Object)iconState)).getFirstState() : ((AnimationState)((Object)iconState)).getSecondState();
                objectArray2.currentIconState = iconState2;
                iconState = n10 != 0 ? ((AnimationState)((Object)iconState)).getSecondState() : ((AnimationState)((Object)iconState)).getFirstState();
                objectArray2.animatingIconState = iconState;
                objectArray2.setTransformationValue(Float.valueOf((float)var2_2));
                return objectArray2.currentIconState;
            }
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Float.valueOf(0.0f);
        objectArray[1] = Float.valueOf(2.0f);
        throw new IllegalArgumentException(String.format("Value must be between %s and %s", objectArray2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setVisible(boolean visible) {
        void var1_1;
        this.visible = var1_1;
        this.invalidateSelf();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setRTLEnabled(boolean rtlEnabled) {
        void var1_1;
        this.rtlEnabled = var1_1;
        this.invalidateSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IconState getIconState() {
        MaterialMenuDrawable materialMenuDrawable = this_;
        Object this_ = materialMenuDrawable.lock;
        synchronized (this_) {
            return materialMenuDrawable.currentIconState;
        }
    }

    public boolean isDrawableVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getTransformationValue() {
        MaterialMenuDrawable materialMenuDrawable = this_;
        Object this_ = materialMenuDrawable.lock;
        synchronized (this_) {
            return Float.valueOf(materialMenuDrawable.transformationValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setTransformationValue(Float value) {
        Object object = this.lock;
        synchronized (object) {
            void var1_1;
            this.transformationValue = var1_1.floatValue();
            this.invalidateSelf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void start() {
        v0 = this;
        var1_1 = v0.lock;
        synchronized (var1_1) {
            if (!v0.transformationRunning) ** GOTO lbl10
            return;
lbl10:
            // 1 sources

            var2_2 = this.animatingIconState;
            if (var2_2 == null) ** GOTO lbl32
            if (var2_2 == this.currentIconState) ** GOTO lbl32
            this.transformationRunning = true;
            var2_3 = this.resolveTransformation();
            var3_4 = this.transformation;
            var4_5 = new float[2];
            var5_6 = 0;
            var6_8 = var2_3 != 0 ? 0.0f : 1.0f;
            v2 = var2_3;
            var4_5[var5_6] = var6_8;
            var2_3 = 1;
            var5_7 = v2 != 0 ? 1.0f : 2.0f;
            var4_5[var2_3] = var5_7;
            var3_4.setFloatValues(var4_5);
            this.transformation.start();
lbl32:
            // 3 sources

            this.invalidateSelf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        MaterialMenuDrawable materialMenuDrawable = this;
        Object object = materialMenuDrawable.lock;
        synchronized (object) {
            if (materialMenuDrawable.isRunning() && this.transformation.isRunning()) {
                this.transformation.end();
            } else {
                this.transformationRunning = false;
                this.invalidateSelf();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        MaterialMenuDrawable materialMenuDrawable = this_;
        Object this_ = materialMenuDrawable.lock;
        synchronized (this_) {
            return materialMenuDrawable.transformationRunning;
        }
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public Drawable.ConstantState getConstantState() {
        MaterialMenuDrawable materialMenuDrawable = this;
        MaterialMenuState.access$402(materialMenuDrawable.materialMenuState, this.getChangingConfigurations());
        return materialMenuDrawable.materialMenuState;
    }

    public Drawable mutate() {
        MaterialMenuState materialMenuState;
        MaterialMenuState materialMenuState2 = materialMenuState;
        materialMenuState = new MaterialMenuState();
        this.materialMenuState = materialMenuState2;
        return this;
    }

    private final class MaterialMenuState
    extends Drawable.ConstantState {
        private int changingConfigurations;

        private MaterialMenuState() {
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$402(MaterialMenuState x02, int x12) {
            void var1_1;
            var0.changingConfigurations = var1_1;
            return x12;
        }

        public Drawable newDrawable() {
            MaterialMenuDrawable materialMenuDrawable;
            MaterialMenuDrawable materialMenuDrawable2 = materialMenuDrawable;
            MaterialMenuState materialMenuState = this;
            Enum enum_ = materialMenuState.MaterialMenuDrawable.this.stroke;
            long l10 = materialMenuState.MaterialMenuDrawable.this.transformation.getDuration();
            int n10 = materialMenuState.MaterialMenuDrawable.this.width;
            int n11 = materialMenuState.MaterialMenuDrawable.this.height;
            float f10 = materialMenuState.MaterialMenuDrawable.this.iconWidth;
            float f11 = materialMenuState.MaterialMenuDrawable.this.circleRadius;
            float f12 = materialMenuState.MaterialMenuDrawable.this.strokeWidth;
            float f13 = materialMenuState.MaterialMenuDrawable.this.dip1;
            materialMenuDrawable = new MaterialMenuDrawable(MaterialMenuDrawable.this.circlePaint.getColor(), (Stroke)enum_, l10, n10, n11, f10, f11, f12, f13);
            enum_ = MaterialMenuDrawable.this.animatingIconState != null ? MaterialMenuDrawable.this.animatingIconState : MaterialMenuDrawable.this.currentIconState;
            MaterialMenuDrawable materialMenuDrawable3 = materialMenuDrawable2;
            materialMenuDrawable2.setIconState((IconState)enum_);
            materialMenuDrawable2.setVisible(MaterialMenuDrawable.this.visible);
            materialMenuDrawable3.setRTLEnabled(MaterialMenuDrawable.this.rtlEnabled);
            return materialMenuDrawable3;
        }

        public int getChangingConfigurations() {
            return this.changingConfigurations;
        }
    }

    public static final class Stroke
    extends Enum<Stroke> {
        public static final /* enum */ Stroke REGULAR;
        public static final /* enum */ Stroke THIN;
        public static final /* enum */ Stroke EXTRA_THIN;
        private static final /* synthetic */ Stroke[] $VALUES;
        private final int strokeWidth;

        public static Stroke[] values() {
            return (Stroke[])$VALUES.clone();
        }

        public static Stroke valueOf(String name) {
            String string2;
            return Enum.valueOf(Stroke.class, string2);
        }

        /*
         * WARNING - void declaration
         */
        private Stroke(int strokeWidth) {
            void var3_3;
            this.strokeWidth = var3_3;
        }

        protected static Stroke valueOf(int strokeWidth) {
            if (strokeWidth != 1) {
                int n10;
                if (n10 != 2) {
                    if (n10 != 3) {
                        return THIN;
                    }
                    return REGULAR;
                }
                return THIN;
            }
            return EXTRA_THIN;
        }

        static {
            Stroke stroke;
            Stroke stroke2;
            Stroke stroke3;
            Stroke stroke4 = stroke3;
            REGULAR = new Stroke(3);
            Stroke stroke5 = stroke2;
            THIN = new Stroke(2);
            Stroke stroke6 = stroke;
            EXTRA_THIN = new Stroke(1);
            $VALUES = new Stroke[]{stroke4, stroke5, stroke6};
        }
    }

    public static final class AnimationState
    extends Enum<AnimationState> {
        public static final /* enum */ AnimationState BURGER_ARROW;
        public static final /* enum */ AnimationState BURGER_X;
        public static final /* enum */ AnimationState ARROW_X;
        public static final /* enum */ AnimationState ARROW_CHECK;
        public static final /* enum */ AnimationState BURGER_CHECK;
        public static final /* enum */ AnimationState X_CHECK;
        private static final /* synthetic */ AnimationState[] $VALUES;

        public static AnimationState[] values() {
            return (AnimationState[])$VALUES.clone();
        }

        public static AnimationState valueOf(String name) {
            String string2;
            return Enum.valueOf(AnimationState.class, string2);
        }

        static {
            AnimationState animationState;
            AnimationState animationState2;
            AnimationState animationState3;
            AnimationState animationState4;
            AnimationState animationState5;
            AnimationState animationState6;
            AnimationState animationState7 = animationState6;
            BURGER_ARROW = new AnimationState();
            AnimationState animationState8 = animationState5;
            BURGER_X = new AnimationState();
            AnimationState animationState9 = animationState4;
            ARROW_X = new AnimationState();
            AnimationState animationState10 = animationState3;
            ARROW_CHECK = new AnimationState();
            AnimationState animationState11 = animationState2;
            BURGER_CHECK = new AnimationState();
            AnimationState animationState12 = animationState;
            X_CHECK = new AnimationState();
            $VALUES = new AnimationState[]{animationState7, animationState8, animationState9, animationState10, animationState11, animationState12};
        }

        @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
        public IconState getFirstState() {
            switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$AnimationState[this.ordinal()]) {
                default: {
                    return null;
                }
                case 6: {
                    return IconState.X;
                }
                case 5: {
                    return IconState.BURGER;
                }
                case 4: {
                    return IconState.ARROW;
                }
                case 3: {
                    return IconState.ARROW;
                }
                case 2: {
                    return IconState.BURGER;
                }
                case 1: 
            }
            return IconState.BURGER;
        }

        @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
        public IconState getSecondState() {
            switch (3.$SwitchMap$com$instabug$library$ui$custom$MaterialMenuDrawable$AnimationState[this.ordinal()]) {
                default: {
                    return null;
                }
                case 6: {
                    return IconState.CHECK;
                }
                case 5: {
                    return IconState.CHECK;
                }
                case 4: {
                    return IconState.CHECK;
                }
                case 3: {
                    return IconState.X;
                }
                case 2: {
                    return IconState.X;
                }
                case 1: 
            }
            return IconState.ARROW;
        }
    }

    public static final class IconState
    extends Enum<IconState> {
        public static final /* enum */ IconState BURGER;
        public static final /* enum */ IconState ARROW;
        public static final /* enum */ IconState X;
        public static final /* enum */ IconState CHECK;
        private static final /* synthetic */ IconState[] $VALUES;

        public static IconState[] values() {
            return (IconState[])$VALUES.clone();
        }

        public static IconState valueOf(String name) {
            String string2;
            return Enum.valueOf(IconState.class, string2);
        }

        static {
            IconState iconState;
            IconState iconState2;
            IconState iconState3;
            IconState iconState4;
            IconState iconState5 = iconState4;
            BURGER = new IconState();
            IconState iconState6 = iconState3;
            ARROW = new IconState();
            IconState iconState7 = iconState2;
            X = new IconState();
            IconState iconState8 = iconState;
            CHECK = new IconState();
            $VALUES = new IconState[]{iconState5, iconState6, iconState7, iconState8};
        }
    }
}

