/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.encryption;

import androidx.annotation.VisibleForTesting;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.util.InstabugSDKLogger;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StaticKeyProvider {
    @NotNull
    public static final StaticKeyProvider a = new StaticKeyProvider();

    private StaticKeyProvider() {
    }

    @JvmStatic
    @Nullable
    public static final Key a() {
        SecretKeySpec secretKeySpec;
        SecretKeySpec secretKeySpec2 = secretKeySpec;
        try {
            byte[] byArray = StaticKeyProvider.getKeyString().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            secretKeySpec = new SecretKeySpec(byArray, "AES");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            InstabugSDKLogger.e("IBG-Core", "Error loading native library while getting static encryption key");
            secretKeySpec2 = null;
        }
        return secretKeySpec2;
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final native String getKeyString();

    static {
        try {
            System.loadLibrary("ibg-native");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            InstabugSDKLogger.e("IBG-Core", "Error loading native library while getting static encryption key");
            IBGDiagnostics.reportNonFatal(unsatisfiedLinkError, "Error loading native library");
        }
    }
}

