/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.Toast;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.instacapture.d;
import com.instabug.library.internal.video.RequestPermissionActivityLauncher;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.screenshot.g;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.memory.MemoryUtils;
import java.util.concurrent.Callable;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScreenshotProvider {
    @NotNull
    public static final ScreenshotProvider a = new ScreenshotProvider();
    @Nullable
    private static Callable b;

    private ScreenshotProvider() {
    }

    @JvmStatic
    public static final void a(@Nullable Callable callable) {
        b = callable;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    public static final synchronized void a(@Nullable Activity object, @NotNull ScreenshotCapturingListener screenshotCapturingListener) {
        Exception exception;
        void var1_4;
        Intrinsics.checkNotNullParameter((Object)var1_4, (String)"screenshotCapturingListener");
        if (object != null && !object.isFinishing()) {
            if (MemoryUtils.isLowMemory((Context)object)) {
                Object object2 = object;
                InstabugSDKLogger.e("IBG-Core", "Couldn't take initial screenshot due to low memory");
                var1_4.onScreenshotCapturingFailed(new Throwable("Your activity is currently in low memory"));
                Toast.makeText((Context)object2, (CharSequence)LocaleUtils.getLocaleStringResource(InstabugCore.getLocale((Context)object2), R.string.instabug_str_capturing_screenshot_error, (Context)object), (int)0).show();
                return;
            }
            InstabugSDKLogger.d("IBG-Core", "start capture screenshot");
            try {
                Callable callable = b;
                if (callable == null) {
                    d.a(object).a(new g((ScreenshotCapturingListener)var1_4), R.id.instabug_decor_view, R.id.instabug_extra_screenshot_button, R.id.instabug_floating_button, R.id.instabug_in_app_notification, R.id.instabug_intro_dialog);
                    return;
                }
                InstabugSDKLogger.i("IBG-Core", "Using the supplied screenshotProvider to capture the screenshot");
                object.runOnUiThread(() -> ScreenshotProvider.a((ScreenshotCapturingListener)var1_4, callable));
                return;
            }
            catch (Exception exception2) {
                var1_4.onScreenshotCapturingFailed(exception2);
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                var1_4.onScreenshotCapturingFailed(outOfMemoryError);
                return;
            }
        }
        Exception exception3 = exception;
        exception = new Exception("Can't capture screenshot due to null activity");
        var1_4.onScreenshotCapturingFailed(exception3);
    }

    @JvmStatic
    public static final synchronized void a(boolean bl, @Nullable Activity activity, @NotNull ScreenshotCapturingListener screenshotCapturingListener) {
        Intrinsics.checkNotNullParameter((Object)screenshotCapturingListener, (String)"screenshotCapturingListener");
        InstabugSDKLogger.d("IBG-Core", "start capture screenshot Using MediaProjection");
        if (activity != null && !activity.isFinishing()) {
            if (SettingsManager.getInstance().isScreenCurrentlyRecorded()) {
                AutoScreenRecordingEventBus.getInstance().post(ScreenRecordingService.Action.STOP_TRIM_KEEP);
            }
            RequestPermissionActivityLauncher.start(activity, false, bl, screenshotCapturingListener);
        }
    }

    private static final void a(ScreenshotCapturingListener screenshotCapturingListener, Callable callable) {
        Callable callable2 = callable;
        Intrinsics.checkNotNullParameter((Object)screenshotCapturingListener, (String)"$screenshotCapturingListener");
        Intrinsics.checkNotNullParameter((Object)callable2, (String)"$it");
        Object v2 = callable2.call();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"it.call()");
        screenshotCapturingListener.onScreenshotCapturedSuccessfully((Bitmap)v2);
    }

    public static interface ScreenshotCapturingListener {
        public void onScreenshotCapturedSuccessfully(@NotNull Bitmap var1);

        public void onScreenshotCapturingFailed(@NotNull Throwable var1);
    }
}

