/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.UserEventsEventBus;
import com.instabug.library.e0;
import com.instabug.library.logging.e;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.f;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.Action;
import com.instabug.library.util.memory.MemoryGuard;
import com.instabug.library.util.memory.MemoryUtils;
import com.instabug.library.util.memory.predicate.MemoryNotLowPredicate;
import com.instabug.library.util.threading.PoolProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class InstabugUserEventLogger {
    private static volatile InstabugUserEventLogger instabugUserEventLogger;
    private static final int USER_EVENT_COUNT_LIMIT = 1000;
    private List<UserEvent> userEvents;
    private ConcurrentHashMap<String, Integer> userEventsCount;

    private InstabugUserEventLogger() {
        ConcurrentHashMap concurrentHashMap;
        CopyOnWriteArrayList copyOnWriteArrayList;
        Object this_ = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        v1.userEvents = this_;
        this_ = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.userEventsCount = this_;
    }

    public static synchronized InstabugUserEventLogger getInstance() {
        if (instabugUserEventLogger == null) {
            instabugUserEventLogger = new InstabugUserEventLogger();
        }
        return instabugUserEventLogger;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private void runInsertionHandler(String uuid, boolean anonymous) {
        Context context = Instabug.getApplicationContext();
        if (context != null && !MemoryUtils.isLowMemory(context)) {
            void var2_2;
            void var1_1;
            MemoryGuard.from(context).withPredicate(new MemoryNotLowPredicate()).forOperation("updating user events").doAction(new Action((String)var1_1, (boolean)var2_2){
                final /* synthetic */ String a;
                final /* synthetic */ boolean b;
                {
                    this.a = string2;
                    this.b = bl;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onAffirmed() {
                    try {
                        Iterator iterator = InstabugUserEventLogger.this.userEventsCount.entrySet().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                InstabugUserEventLogger.this.userEventsCount.clear();
                                return;
                            }
                            Object object = iterator.next();
                            b b2 = this;
                            Map.Entry entry = object;
                            object = (String)entry.getKey();
                            int n2 = (Integer)entry.getValue();
                            String string2 = b2.a;
                            boolean bl = b2.b;
                            InstabugUserEventLogger.access$300(InstabugUserEventLogger.this, (String)object, n2, string2, bl);
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        OutOfMemoryError outOfMemoryError2 = outOfMemoryError;
                        InstabugCore.reportError(outOfMemoryError2, "Error: " + outOfMemoryError.getMessage() + "while inserting user events");
                        if (outOfMemoryError2.getMessage() == null) return;
                        InstabugSDKLogger.e("IBG-Core", "Error: " + outOfMemoryError.getMessage() + "while inserting user events");
                    }
                }

                @Override
                public void onDenied() throws Throwable {
                    InstabugSDKLogger.e("IBG-Core", "Failed to update user events due to low memory");
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void incrementEventLoggingCount(@NonNull String eventIdentifier, int incrementBy, String uuid, boolean anonymous) {
        void var1_1;
        void var4_4;
        void var3_3;
        void var2_2;
        String string2 = eventIdentifier;
        e.a(string2, e.b(string2, f.k()) + var2_2, (String)var3_3, (boolean)var4_4);
        UserEventsEventBus.getInstance().post(new UserEvent().setEventIdentifier((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(InstabugUserEventLogger x0, String x1, boolean x2) {
        void var2_2;
        void var1_1;
        x0.runInsertionHandler((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(InstabugUserEventLogger x0, String x1, int x2, String x3, boolean x4) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        x0.incrementEventLoggingCount((String)var1_1, (int)var2_2, (String)var3_3, (boolean)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void logUserEvent(@NonNull String eventIdentifier, UserEventParam ... userEventParams) {
        void var2_2;
        void var1_1;
        PoolProvider.getUserActionsExecutor().execute(new Runnable((String)var1_1, (UserEventParam[])var2_2){
            final /* synthetic */ String a;
            final /* synthetic */ UserEventParam[] b;
            {
                this.a = string2;
                this.b = userEventParamArray;
            }

            @Override
            public void run() {
                if (e0.c().b((Object)Feature.USER_EVENTS) == Feature.State.ENABLED) {
                    Object object = new UserEvent().setEventIdentifier(this.a).setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
                    UserEventParam[] userEventParamArray = this.b;
                    int n2 = this.b.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ((UserEvent)object).addParam(userEventParamArray[i2]);
                    }
                    if (InstabugUserEventLogger.this.userEvents.size() >= 1000) {
                        InstabugUserEventLogger.this.userEvents.remove(0);
                    }
                    a a2 = this;
                    a2.InstabugUserEventLogger.this.userEvents.add(object);
                    object = (Integer)a2.InstabugUserEventLogger.this.userEventsCount.get(this.a);
                    if (object != null) {
                        InstabugUserEventLogger.this.userEventsCount.put(this.a, (Integer)object + 1);
                    } else {
                        InstabugUserEventLogger.this.userEventsCount.put(this.a, 1);
                    }
                    InstabugUserEventLogger.access$200(InstabugUserEventLogger.this, f.l(), f.p() ^ true);
                }
            }
        });
    }

    @VisibleForTesting
    int getLoggingEventCount(@NonNull String userEventIdentifier) {
        return e.b(userEventIdentifier, f.k());
    }

    public List<UserEvent> getUserEvents() throws IllegalStateException {
        return this.userEvents;
    }

    /*
     * WARNING - void declaration
     */
    public List<UserEvent> getUserEvents(float percentage) throws IllegalStateException {
        void var1_2;
        int n2 = Math.round((float)(var1_2 * 1000.0f));
        if (this.userEvents.size() <= n2) {
            return this.userEvents;
        }
        InstabugUserEventLogger instabugUserEventLogger = this;
        int n3 = instabugUserEventLogger.userEvents.size() - n2;
        List<UserEvent> list = instabugUserEventLogger.userEvents;
        return list.subList(n3, list.size());
    }

    public void clearAll() throws IllegalStateException {
        this.userEvents.clear();
    }

    public void clearLoggingData() throws IllegalStateException {
        e.a(f.k());
    }
}

