/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.MediaController;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import com.instabug.library.InstabugBaseFragment;
import com.instabug.library.R;
import com.instabug.library.internal.video.a;
import com.instabug.library.util.InstabugSDKLogger;

public class VideoPlayerFragment
extends InstabugBaseFragment
implements a.a {
    public static final String TAG = "VideoPlayerFragment";
    private static final String VIDEO_PATH = "video.uri";
    @Nullable
    private View videoViewToolbar;
    @Nullable
    private VideoView videoView;
    private int position = 0;
    @Nullable
    private ProgressDialog progressDialog;
    @Nullable
    private a mediaControls;
    @Nullable
    private String videoUri;

    public static VideoPlayerFragment newInstance(String videoUri) {
        String string2;
        Bundle bundle;
        VideoPlayerFragment videoPlayerFragment = new VideoPlayerFragment();
        Bundle bundle2 = bundle;
        new Bundle().putString(VIDEO_PATH, string2);
        videoPlayerFragment.setArguments(bundle2);
        return videoPlayerFragment;
    }

    /*
     * WARNING - void declaration
     */
    private void showToolbar(boolean shouldShow) {
        if ((this = this.getActivity()) != null && (this = ((AppCompatActivity)this).getSupportActionBar()) != null) {
            void var1_1;
            if (var1_1 != false) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_lyt_video_view;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        void var2_2;
        Object object;
        super.onViewCreated((View)object, (Bundle)var2_2);
        this.videoView = (VideoView)object.findViewById(R.id.video_view);
        this.videoViewToolbar = object = view.findViewById(R.id.ib_core_toolbar_video);
        if (object != null) {
            View.OnClickListener onClickListener;
            View view2 = object;
            object = onClickListener;
            onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    if (VideoPlayerFragment.this.getActivity() != null) {
                        VideoPlayerFragment.this.getActivity().onBackPressed();
                    }
                }
            };
            view2.setOnClickListener((View.OnClickListener)object);
        }
    }

    @Override
    public void onResume() {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onResume();
        videoPlayerFragment.showToolbar(false);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        FragmentActivity fragmentActivity;
        VideoPlayerFragment videoPlayerFragment = this;
        super.onActivityCreated((Bundle)fragmentActivity);
        fragmentActivity = videoPlayerFragment.getActivity();
        if (fragmentActivity != null) {
            block7: {
                if (this.mediaControls == null) {
                    a a2;
                    a a3 = a2;
                    a2 = new a((Context)fragmentActivity, this);
                    this.mediaControls = a3;
                }
                VideoPlayerFragment videoPlayerFragment2 = this;
                this.progressDialog = new ProgressDialog((Context)fragmentActivity);
                this.progressDialog.setMessage((CharSequence)"Loading...");
                videoPlayerFragment2.progressDialog.setCancelable(false);
                videoPlayerFragment2.progressDialog.show();
                fragmentActivity = videoPlayerFragment2.videoView;
                if (fragmentActivity == null) break block7;
                if (this.videoUri == null) break block7;
                try {
                    fragmentActivity.setMediaController((MediaController)this.mediaControls);
                    this.videoView.setVideoURI(Uri.parse((String)this.videoUri));
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("IBG-Core", "Couldn't play video due to: ", exception);
                }
            }
            if ((fragmentActivity = this.videoView) != null) {
                VideoPlayerFragment videoPlayerFragment3 = this;
                fragmentActivity.requestFocus();
                videoPlayerFragment3.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    @SuppressLint(value={"NULL_DEREFERENCE"})
                    public void onPrepared(MediaPlayer mediaPlayer) {
                        if (VideoPlayerFragment.this.progressDialog != null) {
                            VideoPlayerFragment.this.progressDialog.dismiss();
                        }
                        if (VideoPlayerFragment.this.videoView != null) {
                            b b2 = this;
                            b2.VideoPlayerFragment.this.videoView.seekTo(VideoPlayerFragment.this.position);
                            if (b2.VideoPlayerFragment.this.position == 0) {
                                b b3 = this;
                                b3.VideoPlayerFragment.this.videoView.start();
                                if (b3.VideoPlayerFragment.this.mediaControls != null) {
                                    VideoPlayerFragment.this.mediaControls.show();
                                }
                            } else {
                                VideoPlayerFragment.this.videoView.pause();
                            }
                        }
                    }
                });
                videoPlayerFragment3.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                    @SuppressLint(value={"NULL_DEREFERENCE"})
                    public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                        if (VideoPlayerFragment.this.progressDialog != null) {
                            VideoPlayerFragment.this.progressDialog.dismiss();
                        }
                        return false;
                    }
                });
            }
        }
    }

    @Override
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    protected String getTitle() {
        return this.getLocalizedString(R.string.instabug_str_video_player);
    }

    public void onDestroy() {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onDestroy();
        videoPlayerFragment.showToolbar(true);
    }

    @Override
    protected void consumeNewInstanceSavedArguments() {
        String string2 = this.getArguments() == null ? null : this.getArguments().getString(VIDEO_PATH);
        this.videoUri = string2;
    }

    @Override
    protected void restoreState(Bundle savedInstanceState) {
        VideoView videoView;
        int n2;
        this.position = n2 = videoView.getInt("Position");
        videoView = this.videoView;
        if (videoView != null) {
            videoView.seekTo(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void saveState(Bundle outState) {
        VideoView videoView = this.videoView;
        if (videoView != null) {
            void var1_1;
            var1_1.putInt("Position", videoView.getCurrentPosition());
            this.videoView.pause();
        }
    }

    public void onDestroyView() {
        this.mediaControls = null;
        this.videoView = null;
        this.videoViewToolbar = null;
        super.onDestroyView();
    }

    @Override
    public void isVisible(boolean isVisible) {
        VideoPlayerFragment this_ = this_.videoViewToolbar;
        if (this_ != null) {
            int n2;
            n2 = n2 != 0 ? 0 : 8;
            this_.setVisibility(n2);
        }
    }
}

