/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.d;
import com.instabug.library.invocation.invoker.FloatingButtonInvoker;
import com.instabug.library.invocation.invoker.a;
import com.instabug.library.invocation.invoker.r;
import com.instabug.library.invocation.invoker.v;
import com.instabug.library.invocation.invoker.x;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class InvocationManager {
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings;
    private AtomicReferenceArray<InstabugInvocationEvent> currentInstabugInvocationEvents;
    private List<a> currentInvokersList;
    @Nullable
    private AtomicReferenceArray<a> currentInvokers;
    @Nullable
    private AtomicReference<a> lastUsedInvoker;
    private Disposable currentActivityLifeCycleDisposable;
    private AtomicBoolean isInvocationAvailable;
    @Nullable
    private AtomicReference<d> invocationRequestListenerImp;

    private InvocationManager() {
        InvocationManager invocationManager = this;
        invocationManager.currentInvokersList = new ArrayList<a>();
        invocationManager.lastUsedInvoker = new AtomicReference();
        invocationManager.isInvocationAvailable = new AtomicBoolean(true);
        invocationManager.currentInvocationSettings = new InvocationSettings();
        this.currentInstabugInvocationEvents = new AtomicReferenceArray<InstabugInvocationEvent>(1);
        this.currentInstabugInvocationEvents.set(0, InstabugInvocationEvent.SHAKE);
        invocationManager.currentInvokers = new AtomicReferenceArray<a>(this.createInvokersList());
        invocationManager.subscribeToCarenActivityLifeCycle();
        invocationManager.invocationRequestListenerImp = new AtomicReference<d>(new d());
    }

    @NonNull
    private a[] createInvokersList() {
        this.currentInvokersList = new ArrayList<a>();
        return this.currentInvokersList.toArray(new a[this.currentInvokersList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private void addToCurrentInvokers(a invoker) {
        void var1_1;
        this.currentInvokersList.add((a)var1_1);
        List<a> list = this.currentInvokersList;
        this.currentInvokers = new AtomicReferenceArray<a>(list.toArray(new a[list.size()]));
    }

    public static synchronized void init() {
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else if (!SettingsManager.getInstance().isInBackground()) {
            INSTANCE.listen();
        }
    }

    public static synchronized InvocationManager getInstance() {
        if (INSTANCE == null) {
            InvocationManager.init();
        }
        return INSTANCE;
    }

    private void subscribeToCarenActivityLifeCycle() {
        this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                int n2 = c.b[activityLifeCycleEvent.ordinal()];
                if (n2 != 1) {
                    if (n2 == 2) {
                        InvocationManager.this.sleep();
                    }
                } else {
                    InvocationManager.this.listen();
                }
            }
        });
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    @Nullable
    private FloatingButtonInvoker getFloatingButtonInvoker() {
        FloatingButtonInvoker floatingButtonInvoker = null;
        if (this.currentInvokers != null) {
            for (int i2 = 0; i2 < this.currentInvokers.length(); ++i2) {
                a a2 = this.currentInvokers.get(i2);
                if (!(a2 instanceof FloatingButtonInvoker)) continue;
                floatingButtonInvoker = (FloatingButtonInvoker)a2;
                break;
            }
        }
        return floatingButtonInvoker;
    }

    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static void tearDown() {
        INSTANCE = null;
    }

    public void release() {
        Disposable disposable = this.currentActivityLifeCycleDisposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
        this.invocationRequestListenerImp = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEvent) {
        int n2;
        void var1_1;
        if (instabugInvocationEvent == null) {
            InstabugSDKLogger.e("IBG-Core", "Passed invocation events has null value, no change will take effect to the previous set invocation events");
            return;
        }
        InvocationManager invocationManager = this;
        invocationManager.currentInstabugInvocationEvents = invocationManager.removeDuplicates((InstabugInvocationEvent[])var1_1);
        if (invocationManager.currentInvokers != null) {
            for (n2 = 0; n2 < this.currentInvokers.length(); ++n2) {
                this.currentInvokers.get(n2).sleep();
            }
            this.currentInvokers = new AtomicReferenceArray<a>(this.createInvokersList());
        }
        block7: for (n2 = 0; n2 < this.currentInstabugInvocationEvents.length(); ++n2) {
            Object object = this.currentInstabugInvocationEvents.get(n2);
            InstabugSDKLogger.v("IBG-Core", "set instabug invocation event: " + (Object)object);
            if (object == InstabugInvocationEvent.NONE && ((void)var1_1).length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                this.currentInvokers = new AtomicReferenceArray<a>(this.createInvokersList());
            }
            Context context = Instabug.getApplicationContext();
            if (this.invocationRequestListenerImp == null) continue;
            switch (c.a[object.ordinal()]) {
                default: {
                    continue block7;
                }
                case 4: {
                    if (this.currentInvokers == null || this.invocationRequestListenerImp.get() == null) continue block7;
                    this.addToCurrentInvokers(new r(this.invocationRequestListenerImp.get()));
                    continue block7;
                }
                case 3: {
                    if (context != null && this.invocationRequestListenerImp.get() != null) {
                        x x2;
                        object = x2;
                        x2 = new x(context, this.invocationRequestListenerImp.get());
                        if (this.currentInvokers == null) continue block7;
                        this.addToCurrentInvokers((a)object);
                        continue block7;
                    }
                    InstabugSDKLogger.e("IBG-Core", "did not add TwoFingerSwipeLeftInvoker due to null appContext");
                    continue block7;
                }
                case 2: {
                    if (this.currentInvokers == null || this.invocationRequestListenerImp.get() == null) continue block7;
                    this.addToCurrentInvokers(new FloatingButtonInvoker(this.invocationRequestListenerImp.get()));
                    continue block7;
                }
                case 1: {
                    if (context != null && this.invocationRequestListenerImp.get() != null) {
                        v v2;
                        object = v2;
                        ((v)object)(context, this.invocationRequestListenerImp.get());
                        v2.a(this.currentInvocationSettings.getShakeThreshold());
                        if (this.currentInvokers == null) continue block7;
                        this.addToCurrentInvokers((a)object);
                        continue block7;
                    }
                    InstabugSDKLogger.e("IBG-Core", "did not add ShakeInvoker due to null appContext");
                }
            }
        }
        if (this.currentInvokers != null) {
            InvocationManager invocationManager2 = this;
            invocationManager2.setLastUsedInvoker(null);
            invocationManager2.listen();
        }
    }

    @VisibleForTesting
    AtomicReferenceArray<InstabugInvocationEvent> removeDuplicates(InstabugInvocationEvent[] events) {
        InstabugInvocationEvent[] instabugInvocationEventArray;
        HashSet<void> hashSet;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        HashSet<void> hashSet2 = hashSet;
        hashSet = new HashSet<void>();
        int n2 = events.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var5_5 = instabugInvocationEventArray[i2];
            if (hashSet2.contains(var5_5)) continue;
            arrayList2.add(var5_5);
            hashSet2.add(var5_5);
        }
        instabugInvocationEventArray = new InstabugInvocationEvent[arrayList2.size()];
        return new AtomicReferenceArray<InstabugInvocationEvent>(arrayList2.toArray(instabugInvocationEventArray));
    }

    @Nullable
    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        InstabugInvocationEvent[] instabugInvocationEventArray = (InstabugInvocationEvent[])com.instabug.library.invocation.util.a.a(this.currentInstabugInvocationEvents, InstabugInvocationEvent.class);
        if (instabugInvocationEventArray != null) {
            return Arrays.copyOf(instabugInvocationEventArray, this.currentInstabugInvocationEvents.length());
        }
        return null;
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    @Nullable
    List<a> getCurrentInvokers() {
        a[] this_ = (a[])com.instabug.library.invocation.util.a.a(this_.currentInvokers, a.class);
        if (this_ == null) {
            return null;
        }
        return Arrays.asList(this_);
    }

    @Nullable
    public a getLastUsedInvoker() {
        AtomicReference<a> this_ = ((InvocationManager)((Object)this_)).lastUsedInvoker;
        if (this_ == null) {
            return null;
        }
        return (a)this_.get();
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void setLastUsedInvoker(@Nullable a lastUsedInvoker) {
        AtomicReference<a> this_ = ((InvocationManager)((Object)this_)).lastUsedInvoker;
        if (this_ != null) {
            void var1_1;
            this_.set((a)var1_1);
        }
    }

    public void listen() {
        if (Instabug.isEnabled() && this.isInvocationAvailable.get() && this.isPromptOptionsAvailable() && this.currentInvokers != null && InstabugCore.getTargetActivity() != null && !SettingsManager.getInstance().isProcessingForeground()) {
            for (int i2 = 0; i2 < this.currentInvokers.length(); ++i2) {
                a a2 = this.currentInvokers.get(i2);
                if (a2.isActive()) continue;
                a2.listen();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handle(MotionEvent motionEvent) {
        if (this.currentInvokers == null) {
            return;
        }
        if (InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.ENABLED) && !InstabugCore.isForegroundBusy()) {
            for (int i2 = 0; i2 < this.currentInvokers.length(); ++i2) {
                void var1_1;
                a a2 = this.currentInvokers.get(i2);
                if (!(a2 instanceof x)) continue;
                a2.handle(var1_1);
                break;
            }
        }
    }

    public void sleep() {
        if (this.currentInvokers != null) {
            for (int i2 = 0; i2 < this.currentInvokers.length(); ++i2) {
                a a2 = this.currentInvokers.get(i2);
                if (!a2.isActive()) continue;
                a2.sleep();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable.set(false);
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable.set(true);
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        return com.instabug.library.core.plugin.c.f();
    }

    public void notifyPrimaryColorChanged() {
        if (Instabug.isEnabled() && this.currentInvokers != null) {
            for (int i2 = 0; i2 < this.currentInvokers.length(); ++i2) {
                final a a2 = this.currentInvokers.get(i2);
                if (InstabugCore.getTargetActivity() == null || !(a2 instanceof FloatingButtonInvoker)) continue;
                PoolProvider.postMainThreadTask(new Runnable(this){

                    @Override
                    public void run() {
                        b b2 = this;
                        b2.a2.sleep();
                        b2.a2.listen();
                    }
                });
            }
        }
    }

    public void notifyInvocationOptionChanged() {
        InvocationManager invocationManager = this;
        boolean bl = invocationManager.isPromptOptionsAvailable() ^ true;
        FloatingButtonInvoker floatingButtonInvoker = invocationManager.getFloatingButtonInvoker();
        if (floatingButtonInvoker != null) {
            if (bl) {
                floatingButtonInvoker.sleep();
            } else {
                floatingButtonInvoker.updateButtonLocation();
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void show() {
        AtomicReference<Object> atomicReference;
        AtomicReference<d> atomicReference2 = ((InvocationManager)((Object)this_)).invocationRequestListenerImp;
        if (atomicReference2 != null && atomicReference2.get() != null) {
            ((InvocationManager)((Object)this_)).invocationRequestListenerImp.get().a();
        }
        InvocationManager invocationManager = this_;
        AtomicReference<Object> this_ = atomicReference;
        atomicReference = new AtomicReference<Object>(null);
        invocationManager.lastUsedInvoker = this_;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(int invocationMode) {
        AtomicReference<d> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            void var1_1;
            this.invocationRequestListenerImp.get().b((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void forceInvoke(int invocationMode) {
        AtomicReference<d> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            void var1_1;
            this.invocationRequestListenerImp.get().a((int)var1_1);
        }
    }
}

