/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import com.instabug.library.Feature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.OnUserUUIDReadyCallback;
import com.instabug.library.Platform;
import com.instabug.library.annotation.utility.b;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.c;
import com.instabug.library.c0;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventPublisher;
import com.instabug.library.f0;
import com.instabug.library.internal.contentprovider.a;
import com.instabug.library.internal.video.customencoding.VideoEncoderConfig;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.Report;
import com.instabug.library.s0;
import com.instabug.library.screenshot.ScreenshotProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.settings.d;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.tracking.v;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.f;
import com.instabug.library.util.InstabugDeprecationLogger;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.State;
import com.instabug.library.visualusersteps.z;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

public class Instabug {
    @Nullable
    private static volatile Instabug INSTANCE;
    private static Context appContext;
    private c0 delegate;

    /*
     * WARNING - void declaration
     */
    private Instabug(@NonNull c0 delegate) {
        void var1_1;
        this.delegate = var1_1;
    }

    @Deprecated
    public static void setDebugEnabled(boolean isDebugEnabled) {
    }

    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public static int getPrimaryColor() {
        Integer n2 = 0;
        return APIChecker.checkAndGet("Instabug.getPrimaryColor", () -> SettingsManager.getInstance().getPrimaryColor(), n2);
    }

    public static void setPrimaryColor(@ColorInt int primaryColorValue) {
        int n2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().setPrimaryColor(n2);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setPrimaryColor", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public static InstabugColorTheme getTheme() {
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            public InstabugColorTheme a() {
                return SettingsManager.getInstance().getTheme();
            }
        };
        InstabugColorTheme instabugColorTheme = InstabugColorTheme.InstabugColorThemeLight;
        return APIChecker.checkAndGet("Instabug.getTheme", returnableRunnable2, instabugColorTheme);
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) {
        void var1_1;
        Uri uri;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string;
            }

            @Override
            public void run() {
                if (uri == null) {
                    InstabugSDKLogger.w("IBG-Core", "fileUri object passed to Instabug.addFileAttachment() is null");
                    return;
                }
                if (this.b == null) {
                    InstabugSDKLogger.w("IBG-Core", "fileNameWithExtension passed to Instabug.addFileAttachment() is null");
                    return;
                }
                g0 g02 = this;
                Uri uri2 = g02.uri;
                SettingsManager.getInstance().addExtraAttachmentFile(uri2, g02.b);
                InstabugSDKLogger.d("IBG-Core", "addFileAttachment file uri: " + uri);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addFileAttachment", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) {
        void var1_1;
        byte[] byArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string;
            }

            @Override
            public void run() {
                if (object.byArray == null) {
                    InstabugSDKLogger.w("IBG-Core", "data object passed to Instabug.addFileAttachment() is null");
                    return;
                }
                if (object.b == null) {
                    InstabugSDKLogger.w("IBG-Core", "fileNameWithExtension  passed to Instabug.addFileAttachment() is null");
                    return;
                }
                k0 k02 = object;
                Object object = k02.byArray;
                SettingsManager.getInstance().addExtraAttachmentFile((byte[])object, k02.b);
                InstabugSDKLogger.d("IBG-Core", "addFileAttachment bytes");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addFileAttachment", voidRunnable2);
    }

    public static void clearFileAttachment() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().clearExtraAttachmentFiles();
                InstabugSDKLogger.d("IBG-Core", "clearFileAttachment");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearFileAttachment", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserData() {
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            public String a() {
                return SettingsManager.getInstance().getUserData();
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserData", returnableRunnable2, "");
    }

    public static void setUserData(@NonNull String userData) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (f0.c().b((Object)Feature.USER_DATA) == Feature.State.ENABLED) {
                    SettingsManager.getInstance().setUserData(StringUtility.trimString(string, 1000));
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setUserData", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserEmail() {
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            public String a() {
                return f.h();
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserEmail", returnableRunnable2, "");
    }

    public static void getUserUUID(@NonNull OnUserUUIDReadyCallback callback) {
        OnUserUUIDReadyCallback onUserUUIDReadyCallback;
        try {
            APIChecker.checkAndRunOrThrow("Instabug.getUserUUID", () -> PoolProvider.postIOTask(() -> PoolProvider.postMainThreadTask(() -> Instabug.lambda$getUserUUID$1(onUserUUIDReadyCallback, f.k()))));
        }
        catch (Exception exception) {
            PoolProvider.postMainThreadTaskWithoutCheck(() -> onUserUUIDReadyCallback.onUserUUIDReady(null));
        }
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getAppToken() {
        return SettingsManager.getInstance().getAppToken();
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void identifyUser(@NonNull String username, @NonNull String email) {
        void var1_1;
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string2;
            }

            @Override
            public void run() {
                if (Instabug.getApplicationContext() != null) {
                    p0 p02 = object;
                    String string2 = p02.string;
                    f.a(Instabug.getApplicationContext(), string2, p02.b);
                    string2 = object.string;
                    string2 = string2 != null && !string2.isEmpty() ? "non-empty-username" : "empty_username";
                    Object object = object.b;
                    object = object != null && !((String)object).isEmpty() ? "non-empty-email" : "empty-email";
                    InstabugSDKLogger.i("IBG-Core", "identifyUser username: " + string2 + " email: " + (String)object);
                } else {
                    InstabugSDKLogger.e("IBG-Core", "identifyUser failed to execute due to null app context");
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.identifyUser", voidRunnable2);
    }

    @Nullable
    public static Context getApplicationContext() {
        Object object = appContext;
        if (object != null) {
            return object;
        }
        object = a.b();
        if (object != null) {
            return ((a)object).a();
        }
        return null;
    }

    @Nullable
    private static Instabug getInstance() {
        Object object = a.b();
        if (INSTANCE == null && object != null) {
            object = c0.a(((a)object).a());
            INSTANCE = new Instabug((c0)object);
        }
        return INSTANCE;
    }

    public static void logoutUser() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                f.s();
                InstabugSDKLogger.d("IBG-Core", "logoutUser");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.logoutUser", voidRunnable2);
    }

    public static boolean isBuilt() {
        return INSTANCE != null && InstabugStateProvider.getInstance().getState() != InstabugState.NOT_BUILT && InstabugStateProvider.getInstance().getState() != InstabugState.BUILDING;
    }

    public static boolean isEnabled() {
        if (!Instabug.isBuilt()) {
            return false;
        }
        Feature feature = Feature.INSTABUG;
        return f0.c().c((Object)feature) && f0.c().b((Object)feature) == Feature.State.ENABLED;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static synchronized void enable() {
        if (com.instabug.library.internal.utils.memory.a.a()) {
            return;
        }
        PoolProvider.getApiExecutor().execute(new Runnable(){

            @Override
            public void run() {
                com.instabug.library.b b2;
                com.instabug.library.b b3 = b2;
                b2 = new com.instabug.library.b(this);
                APIChecker.checkBuilt("Instabug.enable", b3);
            }
        });
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static synchronized void disable() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.N();
                }
                InstabugSDKLogger.d("IBG-Core", "disable");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.disable", voidRunnable2);
    }

    public static void pauseSdk() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.v();
                }
                InstabugSDKLogger.d("IBG-Core", "pauseSdk");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.pauseSdk", voidRunnable2);
    }

    public static void resumeSdk() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.B();
                }
                InstabugSDKLogger.d("IBG-Core", "resumeSdk");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.resumeSdk", voidRunnable2);
    }

    public static void setLocale(@NonNull Locale locale) {
        Locale locale2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (locale2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "locale object passed to Instabug.setLocale is null");
                    return;
                }
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.a(locale2);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setLocale", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static Locale getLocale(@Nullable Context context) {
        Object object;
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable((Context)object){
            final /* synthetic */ Context a;
            {
                this.a = context;
            }

            @Nullable
            public Locale a() {
                return SettingsManager.getInstance().getInstabugLocale(this.a);
            }
        };
        object = Locale.getDefault();
        return (Locale)APIChecker.checkAndGet("Instabug.getLocale", returnableRunnable2, object);
    }

    public static void addTags(String ... tags) {
        String[] stringArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().addTags(StringUtility.trimStrings(stringArray));
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addTags", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static ArrayList<String> getTags() {
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            @Nullable
            public ArrayList a() {
                return SettingsManager.getInstance().getTags();
            }
        };
        return APIChecker.checkAndGet("Instabug.getTags", returnableRunnable2, null);
    }

    public static void resetTags() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().resetTags();
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.resetTags", voidRunnable2);
    }

    public static void setCustomTextPlaceHolders(@NonNull InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (instabugCustomTextPlaceHolder2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "instabugCustomTextPlaceHolder object passed to Instabug.setCustomTextPlaceHolders() is null");
                    return;
                }
                SettingsManager.getInstance().setCustomPlaceHolders(instabugCustomTextPlaceHolder2);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setCustomTextPlaceHolders", voidRunnable2);
    }

    @Nullable
    public static HashMap<String, String> getAllUserAttributes() {
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            public HashMap a() {
                if (Instabug.getInstance() != null) {
                    return Instabug.getInstance().delegate.j();
                }
                return new HashMap();
            }
        };
        return APIChecker.checkAndGet("Instabug.getAllUserAttributes", returnableRunnable2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void setUserAttribute(@NonNull String key, @NonNull String value) {
        void var1_1;
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string2;
            }

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    n n2 = string2;
                    String string2 = n2.string;
                    Instabug.getInstance().delegate.a(string2, n2.b);
                }
                InstabugSDKLogger.d("IBG-Core", "setUserAttribute");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setUserAttribute", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserAttribute(@NonNull String key) {
        String string;
        ReturnableRunnable returnableRunnable;
        ReturnableRunnable returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable(){

            @Nullable
            public String a() {
                if (Instabug.getInstance() != null) {
                    return Instabug.getInstance().delegate.a(string);
                }
                return null;
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserAttribute", returnableRunnable2, null);
    }

    public static void removeUserAttribute(@NonNull String key) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.b(string);
                }
                InstabugSDKLogger.d("IBG-Core", "removeUserAttribute");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removeUserAttribute", voidRunnable2);
    }

    public static void clearAllUserAttributes() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.e();
                }
                InstabugSDKLogger.d("IBG-Core", "clearAllUserAttributes");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearAllUserAttributes", voidRunnable2);
    }

    public static Date getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    public static void setWelcomeMessageState(@NonNull WelcomeMessage.State welcomeMessageState) {
        WelcomeMessage.State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state == null) {
                    InstabugSDKLogger.w("IBG-Core", "welcomeMessageState object passed to Instabug.setWelcomeMessageState() is null");
                    return;
                }
                PoolProvider.postIOTaskWithCheck(new c(this));
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setWelcomeMessageState", voidRunnable2);
    }

    public static void showWelcomeMessage(@NonNull WelcomeMessage.State welcomeMessageState) {
        WelcomeMessage.State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state == null) {
                    InstabugSDKLogger.w("IBG-Core", "welcomeMessageState object passed to Instabug.showWelcomeMessage() is null");
                    return;
                }
                if (!InstabugCore.isForegroundBusy() && Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.c(state);
                }
                InstabugSDKLogger.i("IBG-Core", "showWelcomeMessage: " + state.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.showWelcomeMessage", voidRunnable2);
    }

    public static void setSessionProfilerState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "state object passed to Instabug.setSessionProfilerState() is null");
                    return;
                }
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.a(state2);
                }
                InstabugSDKLogger.d("IBG-Core", "setSessionProfilerState: " + state2.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setSessionProfilerState", voidRunnable2);
    }

    public static void setTrackingUserStepsState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "state object passed to Instabug.setTrackingUserStepsState() is null");
                    return;
                }
                Feature feature = Feature.TRACK_USER_STEPS;
                f0.c().a(feature, state2);
                InstabugSDKLogger.d("IBG-Core", "setTrackingUserStepsState: " + state2.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setTrackingUserStepsState", voidRunnable2);
    }

    public static void setReproStepsState(State reproStepsState) {
        State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                z.a(state);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setReproStepsState", voidRunnable2);
    }

    public static void setColorTheme(@NonNull InstabugColorTheme instabugTheme) {
        InstabugColorTheme instabugColorTheme;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().setTheme(instabugColorTheme);
                int n2 = j0.a[instabugColorTheme.ordinal()];
                if (n2 != 1) {
                    if (n2 == 2) {
                        SettingsManager.getInstance().setPrimaryColor(-15893761);
                        SettingsManager.getInstance().setStatusBarColor(-3815737);
                    }
                } else {
                    SettingsManager.getInstance().setPrimaryColor(-9580554);
                    SettingsManager.getInstance().setStatusBarColor(-16119286);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setColorTheme", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    public static void setCustomBrandingImage(@DrawableRes int lightLogoVariant, @DrawableRes int darkLogoVariant) {
        void var1_1;
        APIChecker.checkAndRunInExecutor("Instabug.setCustomBrandingImage", () -> Instabug.lambda$setCustomBrandingImage$5(lightLogoVariant, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static void setCustomBrandingImage(Bitmap lightLogoVariant, Bitmap darkLogoVariant) {
        void var1_1;
        APIChecker.checkAndRunInExecutor("Instabug.setCustomBrandingImage", () -> Instabug.lambda$setCustomBrandingImage$6(lightLogoVariant, (Bitmap)var1_1));
    }

    public static void logUserEvent(@NonNull String eventIdentifier) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                InstabugUserEventLogger.getInstance().logUserEvent(string, new UserEventParam[0]);
                InstabugSDKLogger.d("IBG-Core", "logUserEvent: " + string);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.logUserEvent", voidRunnable2);
    }

    public static void onReportSubmitHandler(Report.OnReportCreatedListener listener) {
        Report.OnReportCreatedListener onReportCreatedListener;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().setOnReportCreatedListener(onReportCreatedListener);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.onReportSubmitHandler", voidRunnable2);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingAudioCapturingEnabled(Feature.State isASRAudioEnabled) {
        Feature.State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state != null) {
                    SettingsManager.getInstance().setAutoScreenRecordingAudioCapturingState(state);
                    InstabugSDKLogger.d("IBG-Core", "setAutoScreenRecordingAudioCapturingEnabled: " + state.name());
                }
                InstabugSDKLogger.w("IBG-Core", "isASRAudioEnabled object passed to Instabug.setAutoScreenRecordingAudioCapturingEnabled() is null");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setAutoScreenRecordingAudioCapturingEnabled", voidRunnable2);
    }

    public static void show() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                InvocationManager.getInstance().show();
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.show", voidRunnable2);
    }

    public static void addPrivateViews(View ... views) {
        View[] viewArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
                    Instabug.getInstance().delegate.a(viewArray);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addPrivateViews", voidRunnable2);
    }

    public static void removePrivateViews(View ... views) {
        View[] viewArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
                    Instabug.getInstance().delegate.b(viewArray);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removePrivateViews", voidRunnable2);
    }

    public static boolean isBuilding() {
        return InstabugStateProvider.getInstance().getState() == InstabugState.BUILDING;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private static void disableInternal() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.N();
                    InstabugSDKLogger.d("IBG-Core", "disableInternal");
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.disableInternal", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportScreenChange(@Nullable Bitmap screenshot, @NonNull String screenName) {
        if (!Instabug.isBuilt()) {
            return;
        }
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            void var1_1;
            Bitmap bitmap;
            Instabug.getInstance().delegate.a(bitmap, (String)var1_1);
            return;
        }
    }

    private static void setCurrentPlatform(@Platform int platform) {
        int n2;
        SettingsManager.getInstance().setCurrentPlatform(n2);
    }

    public static void addExperiments(@NonNull List<String> experiments) {
        List<String> list;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() throws Exception {
                Instabug instabug = Instabug.getInstance();
                if (instabug != null) {
                    instabug.delegate.a(list);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addExperiments", voidRunnable2);
    }

    public static void removeExperiments(@NonNull List<String> experiments) {
        List<String> list;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() throws Exception {
                Instabug instabug = Instabug.getInstance();
                if (instabug != null) {
                    instabug.delegate.b(list);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removeExperiments", voidRunnable2);
    }

    public static void clearAllExperiments() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() throws Exception {
                Instabug instabug = Instabug.getInstance();
                if (instabug != null) {
                    instabug.delegate.d();
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearAllExperiments", voidRunnable2);
    }

    @RequiresApi(value=18)
    public static void setVideoEncoderConfig(@NonNull VideoEncoderConfig config) {
        SettingsManager.setVideoEncoderConfig(config);
    }

    public static void setScreenshotProvider(@NonNull Callable<Bitmap> provider) {
        APIChecker.checkAndRunInExecutor("Instabug.setScreenshotProvider", () -> {
            IllegalStateException illegalStateException;
            if (SettingsManager.getInstance().getCurrentPlatform() == 2) {
                IllegalStateException illegalStateException2;
                illegalStateException = illegalStateException2;
                illegalStateException2 = new IllegalStateException("setScreenshotProvider should not be called from the native Android SDK");
                InstabugSDKLogger.e("IBG-Core", "IllegalState in Instabug.setScreenshotProvider", illegalStateException);
                return;
            }
            ScreenshotProvider.a((Callable)((Object)illegalStateException));
        });
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$setCustomBrandingImage$6(Bitmap lightLogoVariant, Bitmap darkLogoVariant) throws Exception {
        void var1_1;
        Bitmap bitmap;
        SettingsManager.getInstance().setLightCustomBrandingLogo(bitmap);
        SettingsManager.getInstance().setDarkCustomBrandingLogo((Bitmap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$setCustomBrandingImage$5(int lightLogoVariant, int darkLogoVariant) throws Exception {
        void var1_1;
        int n2;
        Instabug.setCustomBrandingImage(b.a(ContextCompat.getDrawable((Context)appContext, (int)n2)), b.a(ContextCompat.getDrawable((Context)appContext, (int)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$getUserUUID$1(OnUserUUIDReadyCallback callback, String uuid) {
        void var1_1;
        callback.onUserUUIDReady((String)var1_1);
    }

    public static class Builder {
        private static volatile boolean isBuildCalled = false;
        private String applicationToken;
        private Context applicationContext;
        @Nullable
        private Application application;
        private int instabugStatusBarColor;
        private InstabugInvocationEvent[] instabugInvocationEvents;
        private Feature.State userDataState;
        private Feature.State consoleLogState;
        private Feature.State instabugLogState;
        private Feature.State inAppMessagingState;
        private Feature.State pushNotificationState;
        private Feature.State trackingUserStepsState;
        private State reproStepsState;
        private Feature.State viewHierarchyState;
        private Feature.State surveysState;
        private Feature.State userEventsState;
        private Feature.State anrDefaultState;
        private boolean emailFieldRequired;
        private boolean emailFieldVisibility;
        private boolean commentFieldRequired;
        private boolean introMessageEnabled;
        private boolean shouldPlaySounds;
        private boolean successDialogEnabled;
        private InstabugFloatingButtonEdge instabugFloatingButtonEdge;
        private int shakingThreshold;
        private int floatingButtonOffsetFromTop;
        private boolean isSurveysAutoShowing;
        private boolean chatPromptOptionEnable;
        private boolean bugPromptOptionEnable;
        private boolean feedbackPromptOptionEnable;
        private List<Integer> deprecatedMethodsToBeLogedAfterBuild;

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Application application, @NonNull String applicationToken) {
            void var2_2;
            void var1_1;
            InstabugInvocationEvent[] instabugInvocationEventArray = this_;
            InstabugInvocationEvent[] instabugInvocationEventArray2 = new InstabugInvocationEvent[1];
            InstabugInvocationEvent[] this_ = instabugInvocationEventArray2;
            instabugInvocationEventArray2[0] = InstabugInvocationEvent.SHAKE;
            super((Application)var1_1, (String)var2_2, this_);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Application application, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvent) {
            this(var1_1.getApplicationContext(), (String)var2_2, (InstabugInvocationEvent[])var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.application = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        Builder(@NonNull Context applicationContext, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvents) {
            void var2_2;
            void var3_3;
            void var1_1;
            Builder builder = this_;
            Builder builder2 = this_;
            Builder builder3 = this_;
            this_.instabugStatusBarColor = -3815737;
            this_.instabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
            Object this_ = f0.e;
            v3.userDataState = this_;
            v3.consoleLogState = this_;
            v3.instabugLogState = this_;
            v3.inAppMessagingState = this_;
            v3.pushNotificationState = this_;
            v3.trackingUserStepsState = this_;
            v3.reproStepsState = State.ENABLED;
            v3.viewHierarchyState = Feature.State.DISABLED;
            v3.surveysState = this_;
            v3.userEventsState = this_;
            v3.anrDefaultState = this_;
            v3.emailFieldRequired = true;
            v3.emailFieldVisibility = true;
            v3.commentFieldRequired = false;
            v3.introMessageEnabled = true;
            v3.shouldPlaySounds = false;
            v3.successDialogEnabled = true;
            v3.instabugFloatingButtonEdge = InstabugFloatingButtonEdge.RIGHT;
            v3.shakingThreshold = 650;
            v3.floatingButtonOffsetFromTop = -1;
            v3.isSurveysAutoShowing = true;
            v3.chatPromptOptionEnable = true;
            v3.bugPromptOptionEnable = true;
            v3.feedbackPromptOptionEnable = true;
            v3.deprecatedMethodsToBeLogedAfterBuild = new ArrayList<Integer>();
            builder3.applicationContext = var1_1;
            builder2.instabugInvocationEvents = var3_3;
            builder.applicationToken = var2_2;
        }

        private void startVitalComponents() {
            if (this.application != null) {
                v.a().b();
                InstabugInternalTrackingDelegate.init(this.application);
            }
        }

        private void updateFeaturesStates() {
            InstabugCore.setFeatureState(Feature.USER_DATA, this.userDataState);
            InstabugCore.setFeatureState(Feature.CONSOLE_LOGS, this.consoleLogState);
            InstabugCore.setFeatureState(Feature.INSTABUG_LOGS, this.instabugLogState);
            InstabugCore.setFeatureState(Feature.IN_APP_MESSAGING, this.inAppMessagingState);
            InstabugCore.setFeatureState(Feature.PUSH_NOTIFICATION, this.pushNotificationState);
            InstabugCore.setFeatureState(Feature.TRACK_USER_STEPS, this.trackingUserStepsState);
            z.a(this.reproStepsState);
            InstabugCore.setFeatureState(Feature.VIEW_HIERARCHY_V2, this.viewHierarchyState);
            InstabugCore.setFeatureState(Feature.SURVEYS, this.surveysState);
            InstabugCore.setFeatureState(Feature.USER_EVENTS, this.userEventsState);
        }

        private void logDeprecatedApis() {
            Iterator<Integer> this_ = ((Builder)((Object)this_)).deprecatedMethodsToBeLogedAfterBuild.iterator();
            while (this_.hasNext()) {
                InstabugDeprecationLogger.getInstance().log((Integer)this_.next());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void logFeaturesStates(Boolean isInstabugEnabled) {
            void var1_1;
            InstabugSDKLogger.v("IBG-Core", "User data feature state is set to " + (Object)((Object)this.userDataState));
            InstabugSDKLogger.v("IBG-Core", "Console log feature state is set to " + (Object)((Object)this.consoleLogState));
            InstabugSDKLogger.v("IBG-Core", "Instabug logs feature state is set to " + (Object)((Object)this.instabugLogState));
            InstabugSDKLogger.v("IBG-Core", "In-App messaging feature state is set to" + (Object)((Object)this.inAppMessagingState));
            InstabugSDKLogger.v("IBG-Core", "Push notification feature state is set to " + (Object)((Object)this.pushNotificationState));
            InstabugSDKLogger.v("IBG-Core", "Tracking user steps feature state is set to " + (Object)((Object)this.trackingUserStepsState));
            InstabugSDKLogger.v("IBG-Core", "Repro steps feature state is set to " + (Object)((Object)this.reproStepsState));
            InstabugSDKLogger.v("IBG-Core", "View hierarchy feature state is set to " + (Object)((Object)this.viewHierarchyState));
            InstabugSDKLogger.v("IBG-Core", "Surveys feature state is set to " + (Object)((Object)this.surveysState));
            InstabugSDKLogger.v("IBG-Core", "User events feature state is set to " + (Object)((Object)this.userEventsState));
            InstabugSDKLogger.v("IBG-Core", "Instabug overall state is set to " + var1_1);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private /* synthetic */ void lambda$buildInBG$0(Feature.State instabugInitialState) {
            if (this.application == null) {
                return;
            }
            String string = this.applicationToken;
            if (string != null && !string.trim().isEmpty()) {
                void var2_6;
                c0 c02;
                void v0 = c02;
                Builder builder = this;
                InstabugSDKLogger.d("IBG-Core", "Building Instabug From BG thread, thread name: " + Thread.currentThread().getName());
                c02 = c0.a(builder.application);
                INSTANCE = new Instabug(c02);
                InstabugSDKLogger.initLogger(builder.applicationContext);
                Feature.State state = Feature.State.ENABLED;
                boolean bl = v0 == state;
                Object object = f0.c();
                Feature feature = Feature.INSTABUG;
                if (!bl) {
                    Feature.State state2 = Feature.State.DISABLED;
                }
                Builder builder2 = this;
                ((f0)object).a(feature, (Feature.State)var2_6);
                c02.a(InstabugState.BUILDING);
                builder2.logDeprecatedApis();
                String string2 = SettingsManager.getInstance().getAppToken();
                object = builder2.applicationToken;
                if (object != null && string2 != null && !((String)object).equals(string2)) {
                    f.s();
                }
                Builder builder3 = this;
                SettingsManager.getInstance().setAppToken(this.applicationToken);
                com.instabug.library.core.plugin.c.a(builder3.applicationContext);
                new d(this.applicationContext).a(bl);
                s0.a(SettingsManager.getInstance());
                try {
                    c02.a(builder3.applicationContext);
                    InstabugState instabugState = bl ? InstabugState.ENABLED : InstabugState.DISABLED;
                    c0 c03 = c02;
                    c03.a(instabugState);
                    c03.H();
                    InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(this.instabugFloatingButtonEdge);
                    InvocationManager.getInstance().notifyPrimaryColorChanged();
                    InvocationManager.getInstance().setInstabugInvocationEvent(this.instabugInvocationEvents);
                    if (this.floatingButtonOffsetFromTop != -1) {
                        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(this.floatingButtonOffsetFromTop);
                    }
                    SDKCoreEventPublisher.post(new SDKCoreEvent("sdk_state", "built"));
                    this.updateFeaturesStates();
                    this.logFeaturesStates(bl);
                    InstabugSDKLogger.d("IBG-Core", "SDK Built");
                    return;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("IBG-Core", "Error while building the sdk: ", exception);
                }
                return;
            }
            InstabugSDKLogger.w("IBG-Core", "Invalid application token. Abort building the SDK");
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEvents) {
            void var1_1;
            this.instabugInvocationEvents = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTrackingUserStepsState(@NonNull Feature.State state) {
            void var1_1;
            this.trackingUserStepsState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setReproStepsState(State state) {
            void var1_1;
            this.reproStepsState = var1_1;
            return this;
        }

        @Deprecated
        public Builder setDebugEnabled(boolean isDebugEnabled) {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSdkDebugLogsLevel(int level) {
            void var1_1;
            SettingsManager.getInstance().setLogLevel((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConsoleLogState(@NonNull Feature.State state) {
            void var1_1;
            this.consoleLogState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInstabugLogState(@NonNull Feature.State state) {
            void var1_1;
            this.instabugLogState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserDataState(@NonNull Feature.State state) {
            void var1_1;
            this.userDataState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInAppMessagingState(@NonNull Feature.State state) {
            void var1_1;
            this.inAppMessagingState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setViewHierarchyState(@NonNull Feature.State state) {
            void var1_1;
            this.viewHierarchyState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserEventsState(@NonNull Feature.State state) {
            void var1_1;
            this.userEventsState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder ignoreFlagSecure(boolean shouldBeIgnored) {
            void var1_1;
            SettingsManager.getInstance().setIgnoreFlagSecure((boolean)var1_1);
            return this;
        }

        @Nullable
        public void build() {
            appContext = this.applicationContext;
            InstabugSDKLogger.d("IBG-Core", "building sdk with default state ");
            if (isBuildCalled) {
                InstabugSDKLogger.v("IBG-Core", "isBuildCalled true returning..");
                return;
            }
            isBuildCalled = true;
            this.buildInBG(Feature.State.ENABLED);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public void build(Feature.State instabugInitialState) {
            void var1_1;
            String string;
            appContext = this.applicationContext;
            if (instabugInitialState == Feature.State.DISABLED && ((string = this.applicationToken) == null || string.isEmpty())) {
                this.startVitalComponents();
                return;
            }
            InstabugSDKLogger.d("IBG-Core", "building sdk with state " + var1_1);
            if (isBuildCalled) {
                InstabugSDKLogger.v("IBG-Core", "isBuildCalled true returning..");
                return;
            }
            isBuildCalled = true;
            this.buildInBG((Feature.State)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        void buildInBG(Feature.State instabugInitialState) {
            void var1_1;
            PoolProvider.getApiExecutor().execute(() -> this.lambda$buildInBG$0((Feature.State)var1_1));
        }
    }
}

