/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.view.MotionEvent;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import com.instabug.library.Feature;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.CurrentFragmentLifeCycleEventBus;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.g0;
import com.instabug.library.sessionV3.manager.l;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.FragmentLifeCycleEvent;
import com.instabug.library.tracking.a;
import com.instabug.library.tracking.b;
import com.instabug.library.tracking.f;
import com.instabug.library.tracking.j;
import com.instabug.library.tracking.m;
import com.instabug.library.tracking.n;
import com.instabug.library.tracking.o;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.y;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class InstabugInternalTrackingDelegate {
    private static volatile InstabugInternalTrackingDelegate INSTANCE;
    private static final String FRAGMENT_NAV_HOST_NAME = "androidx.navigation.fragment.NavHostFragment";
    private boolean isRegistered;
    private final a currentActivityMonitor;
    private final f activityLifecycleListener;
    @Nullable
    private WeakReference<Fragment> lastResumedFragment;
    @Nullable
    private WeakReference<Activity> currentActivity;
    @Nullable
    private WeakReference<Activity> currentRealActivity;
    private final o navigableViewsTrackingDelegate;

    public static void init(@NonNull Application application) {
        if (INSTANCE == null) {
            Application application2;
            INSTANCE = new InstabugInternalTrackingDelegate(application2);
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private InstabugInternalTrackingDelegate(@NonNull Application application) {
        o o2;
        void var1_1;
        f f2;
        a a2;
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
        instabugInternalTrackingDelegate.isRegistered = false;
        a a3 = a2;
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate2 = this_;
        a3();
        instabugInternalTrackingDelegate2.currentActivityMonitor = a3;
        Object this_ = f2;
        f2 = new f();
        instabugInternalTrackingDelegate2.activityLifecycleListener = this_;
        a2.a((Application)var1_1);
        instabugInternalTrackingDelegate.registerLifecycleListeners((Application)var1_1);
        this_ = o2;
        o2 = new o();
        instabugInternalTrackingDelegate.navigableViewsTrackingDelegate = this_;
    }

    /*
     * WARNING - void declaration
     */
    private void registerWindowCallbacksIfNeeded(Activity activity) {
        void var1_1;
        if (activity == null) {
            return;
        }
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = var1_1.getWindow();
        if (instabugInternalTrackingDelegate == null) {
            return;
        }
        if (!((instabugInternalTrackingDelegate = instabugInternalTrackingDelegate.getCallback()) instanceof n)) {
            InstabugSDKLogger.d("IBG-Core", "restore original window callback");
            var1_1.getWindow().setCallback((Window.Callback)new n((Window.Callback)instabugInternalTrackingDelegate));
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNavHostFragment(Fragment fragment) {
        void var1_1;
        if (fragment == null) {
            return false;
        }
        return FRAGMENT_NAV_HOST_NAME.equals(var1_1.getClass().getName());
    }

    private boolean isUserTrackingStepsEnable() {
        return g0.c().b((Object)Feature.TRACK_USER_STEPS) == Feature.State.ENABLED && InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.ENABLED);
    }

    private boolean isReproStepsEnable() {
        return g0.c().b((Object)Feature.REPRO_STEPS) == Feature.State.ENABLED && InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.ENABLED);
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return activity instanceof _InstabugActivity ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            void var1_1;
            InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " created");
            m.a().a(var1_1.getClass().getName(), "APPLICATION_CREATED");
        }
    }

    void handleActivityCreatedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", string2.getClass().getSimpleName() + " created");
                m.a().a(string2.getClass().getName(), "ACTIVITY_CREATED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable() && SettingsManager.getInstance().getCurrentPlatform() == 2) {
                void v0 = string2;
                String this_ = v0.getClass().getSimpleName();
                string2 = v0.getClass().getName();
                y.d().b("ACTIVITY_CREATED", this_, string2, null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.CREATED);
        }
    }

    void handleActivityStartedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", string2.getClass().getSimpleName() + " started");
                m.a().a(string2.getClass().getName(), "ACTIVITY_STARTED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable() && SettingsManager.getInstance().getCurrentPlatform() == 2) {
                void v0 = string2;
                String this_ = v0.getClass().getSimpleName();
                string2 = v0.getClass().getName();
                y.d().b("ACTIVITY_STARTED", this_, string2, null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STARTED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityResumedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " resumed");
                m.a().a(var1_1.getClass().getName(), "ACTIVITY_RESUMED");
            }
            if (this.isReproStepsEnable()) {
                void v0 = var1_1;
                String string2 = v0.getClass().getSimpleName();
                String string3 = v0.getClass().getName();
                y.d().b("ACTIVITY_RESUMED", string2, string3, null);
                this.navigableViewsTrackingDelegate.c((Activity)var1_1);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.RESUMED);
            this.registerWindowCallbacksIfNeeded((Activity)var1_1);
            b.c().b(var1_1.getClass().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentActivity(Activity activity) {
        void var1_1;
        ((InstabugInternalTrackingDelegate)((Object)this_)).currentRealActivity = new WeakReference<void>(var1_1);
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)var1_1)) {
            WeakReference<void> weakReference;
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            WeakReference<void> this_ = weakReference;
            weakReference = new WeakReference<void>(var1_1);
            instabugInternalTrackingDelegate.currentActivity = this_;
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityPausedEvent(Activity activity) {
        void var1_1;
        Object object = null;
        WeakReference<Activity> weakReference = this.currentActivity;
        if (weakReference != null) {
            object = (Activity)weakReference.get();
        }
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (object == null) {
                InstabugSDKLogger.w("IBG-Core", "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!var1_1.equals(object)) {
                InstabugSDKLogger.w("IBG-Core", "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " paused");
                m.a().a(var1_1.getClass().getName(), "ACTIVITY_PAUSED");
            }
            if (this.isReproStepsEnable()) {
                void v0 = var1_1;
                object = v0.getClass().getSimpleName();
                weakReference = v0.getClass().getName();
                y.d().b("ACTIVITY_PAUSED", (String)object, (String)((Object)weakReference), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.PAUSED);
        }
        this.navigableViewsTrackingDelegate.b((Activity)var1_1);
    }

    void handleActivityStoppedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", string2.getClass().getSimpleName() + " stopped");
                m.a().a(string2.getClass().getName(), "ACTIVITY_STOPPED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
                void v0 = string2;
                String this_ = v0.getClass().getSimpleName();
                string2 = v0.getClass().getName();
                y.d().b("ACTIVITY_STOPPED", this_, string2, null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STOPPED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityDestroyedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            Object object;
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " destroyed");
                m.a().a(var1_1.getClass().getName(), "ACTIVITY_DESTROYED");
            }
            if (this.isReproStepsEnable()) {
                void v0 = var1_1;
                object = v0.getClass().getSimpleName();
                String string2 = v0.getClass().getName();
                y.d().b("ACTIVITY_DESTROYED", (String)object, string2, null);
            }
            if (var1_1 != null && (object = this.currentActivity) != null && ((Reference)object).get() != null && var1_1 == this.currentActivity.get()) {
                this.currentActivity.clear();
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.DESTROYED);
        }
    }

    void onFragmentAttached(Fragment fragment) {
        String string2;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string3)).isNavHostFragment((Fragment)string2)) {
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string3)).currentActivity;
            if (activity != null && activity.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string3;
                activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m.a().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_ATTACHED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string3)).isReproStepsEnable()) {
                void v1 = string2;
                String string3 = v1.getClass().getSimpleName();
                string2 = v1.getClass().getName();
                y.d().b("FRAGMENT_ATTACHED", string3, string2, null);
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.ATTACHED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentViewCreated(Fragment fragment) {
        void var1_1;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string2)).isNavHostFragment((Fragment)var1_1)) {
            Object object = ((InstabugInternalTrackingDelegate)((Object)string2)).currentActivity;
            if (object != null && ((Reference)object).get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string2;
                object = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m.a().a(var1_1.getClass().getName(), object.getClass().getName(), "FRAGMENT_VIEW_CREATED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string2)).isReproStepsEnable()) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string2;
                void v2 = var1_1;
                String string2 = v2.getClass().getSimpleName();
                object = v2.getClass().getName();
                y.d().b("FRAGMENT_VIEW_CREATED", string2, (String)object, null);
                instabugInternalTrackingDelegate.navigableViewsTrackingDelegate.c((Fragment)var1_1);
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.VIEW_CREATED);
            return;
        }
    }

    void onFragmentStarted(Fragment fragment) {
        String string2;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string3)).isNavHostFragment((Fragment)string2)) {
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string3)).currentActivity;
            if (activity != null && activity.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string3;
                activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m.a().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_STARTED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string3)).isReproStepsEnable()) {
                void v1 = string2;
                String string3 = v1.getClass().getSimpleName();
                string2 = v1.getClass().getName();
                y.d().b("FRAGMENT_STARTED", string3, string2, null);
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.STARTED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentResumed(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            WeakReference<void> weakReference;
            WeakReference<Activity> weakReference2 = weakReference;
            weakReference = new WeakReference<void>(var1_1);
            this.lastResumedFragment = weakReference2;
            weakReference2 = this.currentActivity;
            if (weakReference2 != null && weakReference2.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
                weakReference2 = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m.a().a(var1_1.getClass().getName(), weakReference2.getClass().getName(), "FRAGMENT_RESUMED");
                }
            }
            if (this.isReproStepsEnable() && var1_1.getUserVisibleHint()) {
                weakReference2 = y.d();
                String string2 = var1_1 instanceof DialogFragment ? "DIALOG_FRAGMENT_RESUMED" : "FRAGMENT_RESUMED";
                WeakReference<Activity> weakReference3 = weakReference2;
                void v3 = var1_1;
                weakReference2 = v3.getClass().getSimpleName();
                ((y)((Object)weakReference3)).b(string2, (String)((Object)weakReference2), v3.getClass().getName(), null);
            }
            if (var1_1.getActivity() != null) {
                this.registerWindowCallbacksIfNeeded((Activity)var1_1.getActivity());
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.RESUMED);
            b.c().c(var1_1.getClass().getName());
            return;
        }
    }

    void onFragmentPaused(Fragment fragment) {
        String string2;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string3)).isNavHostFragment((Fragment)string2)) {
            ((InstabugInternalTrackingDelegate)((Object)string3)).lastResumedFragment = null;
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string3)).currentActivity;
            if (activity != null && activity.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string3;
                activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m.a().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_PAUSED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string3)).isReproStepsEnable()) {
                void v1 = string2;
                String string3 = v1.getClass().getSimpleName();
                string2 = v1.getClass().getName();
                y.d().b("FRAGMENT_PAUSED", string3, string2, null);
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.PAUSED);
            return;
        }
    }

    void onFragmentStopped(Fragment fragment) {
        String string2;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string3)).isNavHostFragment((Fragment)string2)) {
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string3)).currentActivity;
            if (activity != null && activity.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string3;
                activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m.a().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_STOPPED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string3)).isReproStepsEnable()) {
                void v1 = string2;
                String string3 = v1.getClass().getSimpleName();
                string2 = v1.getClass().getName();
                y.d().b("FRAGMENT_STOPPED", string3, string2, null);
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.STOPPED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentDetached(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Object object = this.currentActivity;
            if (object != null && ((Reference)object).get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
                object = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m.a().a(var1_1.getClass().getName(), object.getClass().getName(), "FRAGMENT_DETACHED");
                }
            }
            if (this.isReproStepsEnable()) {
                void v1 = var1_1;
                object = v1.getClass().getSimpleName();
                String string2 = v1.getClass().getName();
                y.d().b("FRAGMENT_DETACHED", (String)object, string2, null);
            }
            this.navigableViewsTrackingDelegate.b((Fragment)var1_1);
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.DETACHED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onFragmentVisibilityChanged(boolean isVisible, Fragment fragment) {
        void var2_3;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string2)).isNavHostFragment((Fragment)var2_3)) {
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string2)).currentActivity;
            if (activity != null && activity.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string2;
                activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    void var1_1;
                    m.a().a(var2_3.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + (boolean)var1_1, "FRAGMENT_VISIBILITY_CHANGED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string2)).isReproStepsEnable()) {
                void v1 = var2_3;
                String string2 = v1.getClass().getSimpleName();
                String string3 = v1.getClass().getName();
                y.d().b("FRAGMENT_VISIBILITY_CHANGED", string2, string3, null);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void trackTouchEvent(MotionEvent event) {
        void var1_1;
        j.a().a((MotionEvent)var1_1);
    }

    @Nullable
    public Activity getCurrentActivity() {
        WeakReference<Activity> this_ = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        return this_ == null ? null : (Activity)this_.get();
    }

    @Nullable
    public Activity getCurrentRealActivity() {
        WeakReference<Activity> this_ = ((InstabugInternalTrackingDelegate)((Object)this_)).currentRealActivity;
        return this_ == null ? null : (Activity)this_.get();
    }

    @Nullable
    public Activity getTargetActivity() {
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
        InstabugInternalTrackingDelegate this_ = null;
        Activity activity = null;
        WeakReference<Activity> weakReference = instabugInternalTrackingDelegate.currentActivity;
        if (weakReference != null) {
            activity = (Activity)weakReference.get();
        }
        if (activity != null && activity.getParent() != null) {
            this_ = activity.getParent();
            while (this_.getParent() != null) {
                this_ = this_.getParent();
            }
        } else if (activity != null) {
            this_ = activity;
        }
        return this_;
    }

    @Nullable
    public Object getLastSeenView() {
        WeakReference<Fragment> weakReference = this.lastResumedFragment;
        if (weakReference != null && weakReference.get() != null) {
            return this.lastResumedFragment.get();
        }
        return this.getTargetActivity();
    }

    /*
     * WARNING - void declaration
     */
    public void registerLifecycleListeners(Application application) {
        void var1_1;
        InstabugSDKLogger.d("IBG-Core", "Registering activity lifecycle listener");
        var1_1.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleListener);
        var1_1.registerComponentCallbacks((ComponentCallbacks)this.activityLifecycleListener);
        l.a.a((Application)var1_1);
        this.isRegistered = true;
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterLifecycleListeners(Application application) {
        void var1_1;
        InstabugSDKLogger.d("IBG-Core", "Unregistering activity lifecycle listener");
        var1_1.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleListener);
        var1_1.unregisterComponentCallbacks((ComponentCallbacks)this.activityLifecycleListener);
        l.a.b((Application)var1_1);
        this.isRegistered = false;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    /*
     * WARNING - void declaration
     */
    void handleConfigurationChanged(Configuration newConfig) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).getTargetActivity() == null) {
            return;
        }
        com.instabug.library.core.eventbus.a this_ = com.instabug.library.core.eventbus.a.a();
        this_.a((Configuration)var1_1);
        com.instabug.library.core.eventbus.a.a().post(this_);
    }
}

