/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.b;
import com.instabug.library.util.c;
import com.instabug.library.util.e;
import com.instabug.library.util.memory.Action;
import com.instabug.library.util.memory.MemoryGuard;
import com.instabug.library.util.memory.predicate.MemoryNotLowPredicate;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.util.threading.ThreadUtils;
import com.instabug.library.visualusersteps.VisualUserStepsHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    private static final String ICON_FILE_PREFIX = "icon";

    @Nullable
    public static Bitmap getBitmapFromUri(@NonNull Uri uri) {
        Uri uri2;
        block3: {
            uri2 = null;
            if (Instabug.getApplicationContext() == null) break block3;
            try {
                Uri uri3;
                uri2 = uri3 = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                InstabugSDKLogger.e("IBG-Core", "getBitmapFromFilePath returns null because of " + iOException.getMessage());
            }
        }
        return uri2;
    }

    /*
     * WARNING - void declaration
     */
    public static void compressBitmapAndSave(@NonNull Context context, @NonNull File originalImageFile) {
        void var1_1;
        if (context != null && var1_1 != null) {
            Context context2;
            MemoryGuard.from(context2).withPredicate(new MemoryNotLowPredicate()).forOperation("compressing a bitmap with size: " + var1_1.length()).doAction(new Action((File)var1_1){
                final /* synthetic */ File a;
                {
                    this.a = file;
                }

                @Override
                public void onAffirmed() throws Throwable {
                    BitmapUtils.compressBitmapAndSave(this.a);
                }

                @Override
                public void onDenied() throws Throwable {
                    InstabugSDKLogger.e("IBG-Core", "Not enough memory for compressing image");
                }
            });
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private static void compressBitmapAndSave(File originalImageFile) {
        var1_2 = v0;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        v1 = new FileInputStream(var0);
        v2 = v1;
        BitmapFactory.decodeStream((InputStream)v1, null, (BitmapFactory.Options)var1_2);
        v2.close();
        var2_3 = 1;
        while (true) {
            if (var1_2.outWidth / var2_3 / 2 < 900) break;
            if (var1_2.outHeight / var2_3 / 2 < 900) break;
            var2_3 *= 2;
            continue;
            break;
        }
        var1_2 = v3;
        new BitmapFactory.Options().inSampleSize = var2_3;
        var2_4 = v4;
        var1_2 = BitmapFactory.decodeStream((InputStream)new FileInputStream(var0), null, (BitmapFactory.Options)var1_2);
        var3_5 = v5;
        v5 = new FileOutputStream(var0);
        if (var1_2 == null) ** GOTO lbl35
        v6 = var1_2;
        v7 = v6;
        v6.compress(BitmapUtils.getImageMimeType(var0), 100, (OutputStream)var3_5);
        try {
            v7.recycle();
lbl35:
            // 2 sources

            var3_5.close();
            var2_4.close();
        }
        catch (Exception var0_1) {
            var0_1.printStackTrace();
            InstabugSDKLogger.e("IBG-Core", "bitmap doesn't compressed correctly " + var0_1.getMessage());
        }
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String localPath, ImageView imageView) {
        String string2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmapWithFallback(String localPath, ImageView imageView, @DrawableRes int fallbackDrawable) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (int)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight) {
        String string2;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(@NonNull String localPath, ImageView imageView, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (BitmapWorkerTask.OnImageLoadedListener)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var4_4;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3, (BitmapWorkerTask.OnImageLoadedListener)var4_4);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String imageFilePath) {
        String string2;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options) {
        BitmapFactory.Options options2;
        int n2 = options.outHeight;
        int n3 = options2.outWidth;
        int n4 = 1;
        int n5 = 500;
        int n6 = 500;
        if (n2 > n5 || n3 > n6) {
            int n7 = n3;
            n3 = n2 / 2;
            n2 = n7 / 2;
            while (n3 / n4 >= n5 && n2 / n4 >= n6) {
                n4 *= 2;
            }
        }
        return n4;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmapAsPNG(Bitmap bitmap, int quality, File directory, String fileNamePrefix, OnSaveBitmapCallback callback) {
        void var4_4;
        void var1_1;
        Bitmap bitmap2;
        void var3_3;
        void var2_2;
        PoolProvider.postBitmapTask(new Runnable((File)var2_2, (String)var3_3, bitmap2, (int)var1_1, (OnSaveBitmapCallback)var4_4){
            final /* synthetic */ File a;
            final /* synthetic */ String b;
            final /* synthetic */ Bitmap c;
            final /* synthetic */ int d;
            final /* synthetic */ OnSaveBitmapCallback e;
            {
                this.a = file;
                this.b = string2;
                this.c = bitmap;
                this.d = n2;
                this.e = onSaveBitmapCallback;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                BufferedOutputStream bufferedOutputStream;
                File file;
                File file2 = file;
                file = new File(this.a, this.b + "_" + System.currentTimeMillis() + ".png");
                BufferedOutputStream bufferedOutputStream2 = bufferedOutputStream;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
                    boolean bl = BitmapUtils.access$100(this.c, compressFormat, this.d, bufferedOutputStream2);
                    bufferedOutputStream2.close();
                    file2 = Uri.fromFile((File)file2);
                    if (bl && file2 != null) {
                        this.e.onSuccess((Uri)file2);
                        return;
                    }
                    this.e.onError(new Throwable("Uri equal null"));
                    return;
                }
                catch (IOException iOException) {
                    this.e.onError(iOException);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Context context, OnSaveBitmapCallback callback) {
        void var2_2;
        Bitmap bitmap2;
        void var1_1;
        PoolProvider.postBitmapTask(new Runnable((Context)var1_1, bitmap2, (OnSaveBitmapCallback)var2_2){
            final /* synthetic */ Context a;
            final /* synthetic */ Bitmap b;
            final /* synthetic */ OnSaveBitmapCallback c;
            {
                this.a = context;
                this.b = bitmap;
                this.c = onSaveBitmapCallback;
            }

            @Override
            public void run() {
                BufferedOutputStream bufferedOutputStream;
                File file;
                Object object = DiskUtils.getInstabugDirectory(this.a);
                File file2 = file;
                file = new File((File)object, "bug_" + System.currentTimeMillis() + "_.jpg");
                object = bufferedOutputStream;
                ((BufferedOutputStream)object)(new FileOutputStream(file2));
                boolean bl = BitmapUtils.access$100(this.b, Bitmap.CompressFormat.JPEG, 100, (OutputStream)object);
                bufferedOutputStream.close();
                file2 = Uri.fromFile((File)file);
                try {
                    new Handler(Looper.getMainLooper()).post((Runnable)new b(this, bl, (Uri)file2));
                }
                catch (IOException iOException) {
                    this.c.onError(iOException);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void saveDrawableBitmap(Drawable drawable2, long currentTime, OnSaveBitmapCallback callback) {
        void var3_2;
        Drawable drawable3;
        void var1_1;
        if (drawable2 == null) {
            return;
        }
        PoolProvider.postBitmapTask(new Runnable((long)var1_1, drawable3, (OnSaveBitmapCallback)var3_2){
            final /* synthetic */ long a;
            final /* synthetic */ Drawable b;
            final /* synthetic */ OnSaveBitmapCallback c;
            {
                this.a = l2;
                this.b = drawable2;
                this.c = onSaveBitmapCallback;
            }

            @Override
            public void run() {
                d d2 = this;
                d d3 = d2;
                File file = BitmapUtils.getIconTargetDirectory(d2.a);
                try {
                    BitmapUtils.access$200(d3.b, new c(this, file));
                }
                catch (Exception exception) {
                    this.c.onError(exception);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static void loadBitmapForAsset(@Nullable Context context, String fileUrl, AssetEntity.AssetType type, OnBitmapReady onBitmapReady) {
        if (context != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            Context context2;
            AssetsCacheManager.getAssetEntity(AssetsCacheManager.createEmptyEntity(context2, (String)var1_1, (AssetEntity.AssetType)var2_2), new AssetsCacheManager.OnDownloadFinished((OnBitmapReady)var3_3){
                final /* synthetic */ OnBitmapReady a;
                {
                    this.a = onBitmapReady;
                }

                @Override
                public void onSuccess(AssetEntity assetEntity) {
                    InstabugSDKLogger.d("IBG-Core", "Asset Entity downloaded: " + assetEntity.getFile().getPath());
                    if (ThreadUtils.isCurrentThreadMain()) {
                        PoolProvider.postBitmapTask(new com.instabug.library.util.d(this, assetEntity));
                    } else {
                        BitmapUtils.access$300(assetEntity, this.a);
                    }
                }

                @Override
                public void onFailed(Throwable throwable) {
                    InstabugSDKLogger.e("IBG-Core", "Asset Entity downloading got error", throwable);
                    this.a.onBitmapFailedToLoad();
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private static void decodeBitmap(AssetEntity assetEntity, OnBitmapReady onBitmapReady) {
        try {
            AssetEntity assetEntity2;
            onBitmapReady.onBitmapReady(BitmapFactory.decodeStream((InputStream)new FileInputStream(assetEntity2.getFile())));
        }
        catch (FileNotFoundException fileNotFoundException) {
            void var1_2;
            InstabugSDKLogger.e("IBG-Core", "Asset Entity downloading got FileNotFoundException error", fileNotFoundException);
            var1_2.onBitmapFailedToLoad();
        }
    }

    @WorkerThread
    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static File getIconTargetDirectory(long currentTime) {
        long l2;
        File file = VisualUserStepsHelper.getVisualUserStepsDirectory(Instabug.getApplicationContext());
        return new File(file, "icon_" + l2 + ".png");
    }

    /*
     * WARNING - void declaration
     */
    private static void drawableToBitmap(Drawable drawable2, OnBitmapReady onBitmapReady) {
        void var1_1;
        Drawable drawable3;
        Context context;
        if (drawable2 instanceof BitmapDrawable && (context = ((BitmapDrawable)drawable3).getBitmap()) != null) {
            var1_1.onBitmapReady(BitmapUtils.resizeBitmap((Bitmap)context, 24.0f, 24.0f));
            return;
        }
        context = Instabug.getApplicationContext();
        if (context != null) {
            int n2 = DisplayUtils.dpToPxIntRounded(context.getResources(), 72);
            final int n3 = drawable3.getIntrinsicWidth();
            final int n4 = drawable3.getIntrinsicHeight();
            if (n3 <= n2 && n4 <= n2) {
                Canvas canvas;
                Bitmap bitmap = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                final Canvas canvas2 = canvas;
                canvas = new Canvas(bitmap);
                if (drawable3.getConstantState() != null) {
                    drawable3 = drawable3.getConstantState().newDrawable();
                }
                PoolProvider.postMainThreadTask(new Runnable((OnBitmapReady)var1_1, bitmap){
                    final /* synthetic */ OnBitmapReady e;
                    final /* synthetic */ Bitmap f;
                    {
                        this.e = onBitmapReady;
                        this.f = bitmap;
                    }

                    @Override
                    public void run() {
                        f f2 = this;
                        f f3 = this;
                        int n2 = f3.canvas2.getWidth();
                        int n32 = f3.canvas2.getHeight();
                        f2.drawable3.setBounds(0, 0, n2, n32);
                        f2.drawable3.draw(canvas2);
                        PoolProvider.postBitmapTask(new e(this));
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static float[] getTargetDimensions(int realWidth, int realHeight) {
        void var1_1;
        int n2;
        float f2 = 24.0f;
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray[0] = f2;
        fArray[1] = f2;
        if (realHeight > n2) {
            fArray2[0] = (float)n2 / (float)var1_1 * f2;
        } else if (var1_1 < n2) {
            fArray2[1] = (float)var1_1 / (float)n2 * f2;
        }
        return fArray2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Bitmap resizeBitmap(Bitmap bitmap, float targetWidth, float targetHeight) {
        Paint paint;
        Matrix matrix;
        Canvas canvas;
        Bitmap bitmap2;
        void var2_3;
        void var1_1;
        if (bitmap == null) {
            return null;
        }
        if (var1_1 == 0.0f && var2_3 == 0.0f) {
            return bitmap2;
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)((int)var1_1), (int)((int)var2_3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap2.getWidth() < bitmap2.getHeight() && var1_1 > var2_3) {
            return bitmap2;
        }
        if (bitmap2.getWidth() > bitmap2.getHeight() && var1_1 < var2_3) {
            return bitmap2;
        }
        Canvas canvas2 = canvas;
        canvas = new Canvas(bitmap3);
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        if (bitmap2.getWidth() < bitmap2.getHeight()) {
            matrix2.setScale((float)(var1_1 /= (float)bitmap2.getWidth()), (float)(var2_3 / (float)bitmap2.getHeight()));
        } else {
            void v2 = var1_1;
            var1_1 = var2_3 / (float)bitmap2.getHeight();
            matrix2.setScale((float)var1_1, (float)(v2 / (float)bitmap2.getWidth()));
        }
        Paint paint2 = paint;
        paint = new Paint();
        canvas2.drawBitmap(bitmap2, matrix2, paint2);
        return bitmap3;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Uri imageUri, Context context, OnSaveBitmapCallback callback) {
        if (imageUri.getPath() != null) {
            void var3_3;
            Bitmap bitmap2;
            void var2_2;
            void var1_1;
            PoolProvider.postBitmapTask(new Runnable((Uri)var1_1, (Context)var2_2, bitmap2, (OnSaveBitmapCallback)var3_3){
                final /* synthetic */ Uri a;
                final /* synthetic */ Context b;
                final /* synthetic */ Bitmap c;
                final /* synthetic */ OnSaveBitmapCallback d;
                {
                    this.a = uri;
                    this.b = context;
                    this.c = bitmap;
                    this.d = onSaveBitmapCallback;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (this.a.getPath() == null) return;
                    g g2 = this;
                    Uri uri = Uri.fromFile((File)new File(this.a.getPath()));
                    OutputStream outputStream = g2.b.getContentResolver().openOutputStream(uri);
                    if (outputStream == null) return;
                    boolean bl = BitmapUtils.access$100(this.c, Bitmap.CompressFormat.PNG, 100, outputStream);
                    try {
                        new Handler(Looper.getMainLooper()).post((Runnable)new com.instabug.library.util.f(this, bl, uri));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (fileNotFoundException.getMessage() == null) return;
                        InstabugSDKLogger.e("IBG-Core", "Error while saving bitmap: " + fileNotFoundException.getMessage());
                    }
                    return;
                }
            });
        }
    }

    /*
     * Exception decompiling
     */
    public static void maskBitmap(@Nullable Activity activity, Bitmap bitmap, @NonNull SettingsManager settingsManager, @Nullable Canvas canvas) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[UNCONDITIONALDOLOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private static boolean compressQuietly(@NonNull Bitmap bitmap, @NonNull Bitmap.CompressFormat format, @IntRange(from=0L, to=100L) int quality, @NonNull OutputStream outputStream) {
        boolean bl;
        block4: {
            block3: {
                void var3_4;
                void var2_3;
                void var1_2;
                Bitmap bitmap2;
                try {
                    if (bitmap.isRecycled()) break block3;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("IBG-Core", "Error while compressing bitmap " + exception.getMessage());
                    return false;
                }
                if (!bitmap2.compress((Bitmap.CompressFormat)var1_2, (int)var2_3, (OutputStream)var3_4)) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$100(Bitmap x0, Bitmap.CompressFormat x1, int x2, OutputStream x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return BitmapUtils.compressQuietly(x0, (Bitmap.CompressFormat)var1_1, (int)var2_2, (OutputStream)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Drawable x0, OnBitmapReady x1) {
        void var1_1;
        BitmapUtils.drawableToBitmap(x0, (OnBitmapReady)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(AssetEntity x0, OnBitmapReady x1) {
        void var1_1;
        BitmapUtils.decodeBitmap(x0, (OnBitmapReady)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ float[] access$400(int x0, int x1) {
        void var1_1;
        return BitmapUtils.getTargetDimensions(x0, (int)var1_1);
    }

    @Keep
    public static interface OnBitmapReady {
        public void onBitmapReady(@Nullable Bitmap var1);

        public void onBitmapFailedToLoad();
    }

    public static interface OnSaveBitmapCallback {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

