/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.Context;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.internal.storage.cache.OnDiskCache;
import com.instabug.library.model.UserAttributes;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.HashMap;

public class UserAttributesCacheManager {
    public static final String USER_ATTRIBUTES_DISK_CACHE_FILE_NAME = "/user_attributes.cache";
    public static final String USER_ATTRIBUTES_DISK_CACHE_KEY = "user_attributes_disk_cache";
    public static final String USER_ATTRIBUTES_MEMORY_CACHE_KEY = "user_attributes_memory_cache";
    public static final String USER_ATTRIBUTES_CACHE_KEY = "attrs";

    @Nullable
    public static InMemoryCache<String, UserAttributes> getCache() {
        CacheManager.KeyExtractor<String, UserAttributes> keyExtractor;
        CacheManager.KeyExtractor<String, UserAttributes> keyExtractor2 = keyExtractor;
        keyExtractor = new CacheManager.KeyExtractor<String, UserAttributes>(){

            public String a(UserAttributes userAttributes) {
                return UserAttributesCacheManager.USER_ATTRIBUTES_CACHE_KEY;
            }
        };
        CacheManager.getInstance().migrateCache(USER_ATTRIBUTES_DISK_CACHE_KEY, USER_ATTRIBUTES_MEMORY_CACHE_KEY, keyExtractor2);
        return (InMemoryCache)CacheManager.getInstance().getCache(USER_ATTRIBUTES_MEMORY_CACHE_KEY);
    }

    @Nullable
    public static HashMap<String, String> getAll() {
        InMemoryCache<String, UserAttributes> inMemoryCache = UserAttributesCacheManager.getCache();
        inMemoryCache = inMemoryCache != null ? inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY) : null;
        return inMemoryCache != null && ((UserAttributes)((Object)inMemoryCache)).getMap() != null && !((UserAttributes)((Object)inMemoryCache)).getMap().isEmpty() ? ((UserAttributes)((Object)inMemoryCache)).getMap() : null;
    }

    public static void prepareCaches(Context context) {
        Context context2;
        PoolProvider.postIOTaskWithCheck(new Runnable(){

            @Override
            public void run() {
                UserAttributesCacheManager.prepareUserAttributesCache(context2);
            }
        });
    }

    private static void prepareUserAttributesCache(Context context) {
        Context context2;
        OnDiskCache<UserAttributes> onDiskCache;
        InstabugSDKLogger.v("IBG-Core", "Creating UserAttributes disk cache");
        OnDiskCache<UserAttributes> onDiskCache2 = onDiskCache;
        onDiskCache = new OnDiskCache<UserAttributes>(context2, USER_ATTRIBUTES_DISK_CACHE_KEY, USER_ATTRIBUTES_DISK_CACHE_FILE_NAME, UserAttributes.class);
        CacheManager.getInstance().addCache(onDiskCache2);
    }
}

