/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.OnSdkInvokedCallback;
import com.instabug.library.Platform;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.plugin.a;
import com.instabug.library.d;
import com.instabug.library.diagnostics.nonfatals.NonFatals;
import com.instabug.library.f;
import com.instabug.library.h;
import com.instabug.library.internal.orchestrator.Action;
import com.instabug.library.internal.orchestrator.ActionsOrchestrator;
import com.instabug.library.internal.storage.ProcessedBytes;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributeCacheManager;
import com.instabug.library.model.Report;
import com.instabug.library.model.common.Session;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.settings.c;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.tracking.b;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

public class InstabugCore {
    public static boolean isFeaturesFetchedBefore() {
        return d.c().f();
    }

    public static Feature.State getFeatureState(Feature feature) {
        Feature feature2;
        return d.c().b((Object)feature2);
    }

    public static boolean isFeatureAvailable(Feature feature) {
        Feature feature2;
        return d.c().c((Object)feature2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isDatabaseTransactionDisabled(@NonNull Context context) {
        Context context2;
        return d.c().d(context2);
    }

    public static boolean isExperimentalFeatureAvailable(Feature feature) {
        Feature feature2;
        return d.c().c(feature2);
    }

    @Nullable
    public static LinkedHashMap<Uri, String> getExtraAttachmentFiles() {
        return SettingsManager.getInstance().getExtraAttachmentFiles();
    }

    public static String getSDKVersion() {
        return "11.4.1";
    }

    public static int getStartedActivitiesCount() {
        return h.e().f();
    }

    public static int getPrimaryColor() {
        return SettingsManager.getInstance().getPrimaryColor();
    }

    public static InstabugColorTheme getTheme() {
        return SettingsManager.getInstance().getTheme();
    }

    public static String getIdentifiedUserEmail() {
        return com.instabug.library.user.b.h();
    }

    public static String getEnteredEmail() {
        return com.instabug.library.user.b.f();
    }

    public static void setEnteredEmail(String enteredEmail) {
        com.instabug.library.user.b.d(enteredEmail);
    }

    public static String getIdentifiedUsername() {
        return com.instabug.library.user.b.i();
    }

    public static String getUserData() {
        return SettingsManager.getInstance().getUserData();
    }

    public static void setIdentifiedUserEmail(String userEmail) {
        com.instabug.library.user.b.f(userEmail);
    }

    public static void setEnteredUsername(String enteredUsername) {
        com.instabug.library.user.b.e(enteredUsername);
    }

    public static String getEnteredUsername() {
        return com.instabug.library.user.b.g();
    }

    @Nullable
    public static OnSdkInvokedCallback getOnSdkInvokedCallback() {
        return SettingsManager.getInstance().getOnSdkInvokedCallback();
    }

    public static String getTagsAsString() {
        return SettingsManager.getInstance().getTagsAsString();
    }

    public static void setLastContactedAt(long time) {
        long l2;
        SettingsManager.getInstance().setLastContactedAt(l2);
    }

    public static boolean isUserLoggedOut() {
        return SettingsManager.getInstance().isUserLoggedOut();
    }

    public static boolean isForegroundBusy() {
        return SettingsManager.getInstance().isPromptOptionsScreenShown() || SettingsManager.getInstance().isRequestPermissionScreenShown() || SettingsManager.getInstance().isOnboardingShowing() || a.f();
    }

    /*
     * WARNING - void declaration
     */
    public static void setFeatureState(Feature feature, Feature.State state) {
        void var1_1;
        Feature feature2;
        d.c().a(feature2, (Feature.State)var1_1);
    }

    public static int getSessionCount() {
        return SettingsManager.getInstance().getSessionsCount();
    }

    public static long getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt().getTime();
    }

    public static Plugin getXPlugin(Class clazz) {
        return a.a(clazz);
    }

    public static boolean isReproStepsScreenshotEnabled() {
        return SettingsManager.getInstance().isReproStepsScreenshotEnabled();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    @Nullable
    public static Activity getTargetActivity() {
        return InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
    }

    @Nullable
    public static Object getLastSeenView() {
        return InstabugInternalTrackingDelegate.getInstance().getLastSeenView();
    }

    public static boolean isFeatureEnabled(Feature feature) {
        Feature feature2;
        return d.c().b((Object)feature2) == Feature.State.ENABLED;
    }

    public static void setPushNotificationState(Feature.State state) {
        Feature.State state2;
        d.c().a(Feature.PUSH_NOTIFICATION, state2);
    }

    public static void setBugReportingState(Feature.State state) {
        Feature.State state2;
        d.c().a(Feature.BUG_REPORTING, state2);
    }

    public static void setChatsState(Feature.State state) {
        Feature.State state2;
        d.c().a(Feature.CHATS, state2);
    }

    public static void setMessagingState(Feature.State state) {
        Feature.State state2;
        d.c().a(Feature.IN_APP_MESSAGING, state2);
    }

    public static void setRepliesState(Feature.State state) {
        Feature.State state2;
        d.c().a(Feature.REPLIES, state2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean encrypt(@NonNull String filePath) {
        void var0_3;
        try {
            return FileUtils.encryptFile(filePath);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        InstabugSDKLogger.e("IBG-Core", "Can't Encrypt attachment", (Throwable)var0_3);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean decrypt(@NonNull String filePath) {
        void var0_3;
        try {
            return FileUtils.decryptFile(filePath);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        InstabugSDKLogger.e("IBG-Core", "Can't Decrypt attachment", (Throwable)var0_3);
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProcessedBytes decryptOnTheFly(String filePath) {
        void var0_3;
        block5: {
            byte[] byArray;
            File file;
            Object object;
            try {
                if (FileUtils.isEncryptedFile(filePath)) {
                    return FileUtils.decryptOnTheFly((String)object);
                }
                File file2 = new File((String)object);
                file = file2;
                byArray = new byte[(int)file2.length()];
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                break block5;
            }
            catch (Exception exception) {
                // empty catch block
                break block5;
            }
            object = byArray;
            {
                FileUtils.read(file, byArray);
                return new ProcessedBytes((byte[])object, true);
            }
        }
        InstabugSDKLogger.e("IBG-Core", "Can't Decrypt attachment", (Throwable)var0_3);
        return new ProcessedBytes(new byte[0], false);
    }

    public static void setAutoScreenRecordingEnabled(boolean autoScreenRecordingEnabled) {
        boolean bl;
        SettingsManager.getInstance().setAutoScreenRecordingEnabled(bl);
    }

    public static boolean isAutoScreenRecordingEnabled() {
        return SettingsManager.getInstance().isAutoScreenRecordingEnabled();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Plugin> void setPluginState(Class<T> clazz, int state) {
        Plugin plugin = InstabugCore.getXPlugin(clazz);
        if (plugin != null) {
            void var1_1;
            plugin.setState((int)var1_1);
        }
    }

    public static long getLastSeenTimestamp() {
        return SettingsManager.getInstance().getLastSeenTimestamp();
    }

    public static void setLastSeenTimestamp(long currentTimeMillis) {
        long l2;
        SettingsManager.getInstance().setLastSeenTimestamp(l2);
    }

    public static void setInitialScreenShotAllowed(boolean initialScreenShotAllowed) {
        SettingsManager.setInitialScreenShotAllowed(initialScreenShotAllowed);
    }

    public static void isInitialScreenShotAllowed() {
        SettingsManager.isInitialScreenShotAllowed();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static HashMap<String, String> retrieveAllSDKAttributes() {
        return UserAttributeCacheManager.retrieveAllSDKAttributes();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static com.instabug.library.internal.servicelocator.c getApplicationScopeServiceLocator() {
        return com.instabug.library.internal.servicelocator.application.b.a();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void doOnBackground(@NonNull Runnable runnable) {
        Runnable runnable2;
        if (runnable == null) {
            return;
        }
        ActionsOrchestrator.obtainOrchestrator().addWorkerThreadAction(new Action(){

            @Override
            public void run() throws Exception {
                runnable2.run();
            }
        }).orchestrate();
    }

    public static boolean isFirstRunAfterEncryptorUpdate() {
        return SettingsManager.getInstance().isFirstRunAfterEncryptorUpdate();
    }

    public static void setFirstRunAfterEncryptorUpdate(boolean isFirstRun) {
        boolean bl;
        SettingsManager.getInstance().setFirstRunAfterEncryptorUpdate(bl);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void setPushNotificationToken(String token) {
        SettingsManager.setPushNotificationToken(token);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getPushNotificationToken() {
        return SettingsManager.getPushNotificationToken();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void setPushNotificationTokenSent(boolean isSent) {
        SettingsManager.setPushNotificationTokenSent(isSent);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isPushNotificationTokenSent() {
        return SettingsManager.isPushNotificationTokenSent();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static boolean isUsersPageEnabled() {
        return SettingsManager.getInstance().isUsersPageEnabled();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Session getRunningSession() {
        return h.e().c();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void setTemporaryDisabled() {
        InstabugSDKLogger.d("IBG-Core", "setTemporaryDisabled disable the SDK internally");
        d.c().h();
        Method method = f.b(Instabug.class, "disableInternal");
        if (method != null) {
            try {
                method.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getCurrentView() {
        int n2 = SettingsManager.getInstance().getCurrentPlatform();
        if (n2 != 4 && n2 != 8 && n2 != 7) {
            return b.c().b();
        }
        return b.c().a();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Report.OnReportCreatedListener getOnReportCreatedListener() {
        return SettingsManager.getInstance().getOnReportCreatedListener();
    }

    @Platform
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static int getPlatform() {
        return SettingsManager.getInstance().getCurrentPlatform();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isAPMEnabled() {
        block3: {
            Plugin plugin = a.a(Class.forName("com.instabug.apm.APMPlugin"));
            if (plugin == null) break block3;
            try {
                return plugin.isFeatureEnabled();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return false;
    }

    public static Locale getLocale(@Nullable Context context) {
        Context context2;
        return SettingsManager.getInstance().getInstabugLocale(context2);
    }

    public static int getEncryptorVersion() {
        c c2 = c.q();
        if (c2 != null) {
            return c2.e();
        }
        return 1;
    }

    public static void saveEncryptorVersion(int version) {
        c c2 = c.q();
        if (c2 != null) {
            int n2;
            c2.b(n2);
        }
    }

    public static Feature.State getEncryptionState() {
        return SettingsManager.getInstance().getFeatureState(Feature.ENCRYPTION, false);
    }

    public static long getFirstSeen() {
        return SettingsManager.getInstance().getFirstSeen();
    }

    /*
     * WARNING - void declaration
     */
    public static void reportError(Throwable error, String message) {
        void var1_1;
        NonFatals.reportNonFatal(error, (String)var1_1);
    }

    public static boolean isDbEncryptionEnabled() {
        return d.c().a() == Feature.State.ENABLED;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean canPrintLog(int logLevel) {
        int n2;
        int n3 = SettingsManager.getInstance().getLogLevel();
        return n3 != 0 && n2 <= n3;
    }

    @Nullable
    @WorkerThread
    public static List<String> getExperiments(float percentage) {
        com.instabug.library.experiments.a a2 = com.instabug.library.experiments.di.a.c();
        if (a2 != null) {
            float f2;
            return a2.a(f2);
        }
        return null;
    }

    public static boolean isLastSDKStateEnabled(@NonNull Context context) {
        Context context2;
        return new com.instabug.library.settings.a(context2).c();
    }

    public static void cleanVisualUserSteps() {
        com.instabug.library.visualusersteps.h.d().a();
    }
}

