/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util.threading;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.MainThreadExecutor;
import com.instabug.library.util.threading.PriorityThreadFactory;
import com.instabug.library.util.threading.ReturnableSingleThreadExecutor;
import com.instabug.library.util.threading.SingleThreadPoolExecutor;
import com.instabug.library.util.threading.d;
import com.instabug.library.util.threading.e;
import com.instabug.library.util.threading.f;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PoolProvider {
    public static final int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static PoolProvider INSTANCE;
    private static final Map<String, SingleThreadPoolExecutor> singleThreadPoolExecutorhMap;
    private static final Map<String, ReturnableSingleThreadExecutor> returnableSingleThreadPoolExecutorhMap;
    private static final Map<String, e> networkingSingleThreadExecutorhMap;
    private static final Map<String, d> monitoredSingleThreadExecutorMap;
    private final ThreadPoolExecutor forBitmapTasks;
    private final ThreadPoolExecutor forIOTasks;
    private final ThreadPoolExecutor forComputationTasks;
    private final ScheduledThreadPoolExecutor forScheduledTasks;
    private final Executor mainThreadExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PoolProvider getInstance() {
        if (INSTANCE == null) {
            Class<PoolProvider> clazz = PoolProvider.class;
            synchronized (PoolProvider.class) {
                INSTANCE = new PoolProvider();
            }
        }
        return INSTANCE;
    }

    @Nullable
    public static Context getContext() {
        try {
            return Instabug.getApplicationContext();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private PoolProvider() {
        MainThreadExecutor mainThreadExecutor;
        PriorityThreadFactory priorityThreadFactory;
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        PriorityThreadFactory priorityThreadFactory2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        ThreadPoolExecutor threadPoolExecutor;
        PriorityThreadFactory priorityThreadFactory3;
        LinkedBlockingQueue linkedBlockingQueue2;
        ThreadPoolExecutor threadPoolExecutor2;
        PriorityThreadFactory priorityThreadFactory4;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue3;
        ThreadPoolExecutor threadPoolExecutor3;
        Object this_ = threadPoolExecutor3;
        int n2 = NUMBER_OF_CORES;
        Object object = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue4 = linkedBlockingQueue3;
        linkedBlockingQueue3 = new LinkedBlockingQueue<Runnable>();
        Object object2 = priorityThreadFactory4;
        priorityThreadFactory4 = new PriorityThreadFactory("core-bitmap-executor", 10);
        int n3 = n2;
        threadPoolExecutor3 = new ThreadPoolExecutor(n3, n3, 10L, (TimeUnit)((Object)object), (BlockingQueue<Runnable>)linkedBlockingQueue4, (ThreadFactory)object2);
        v4.forBitmapTasks = this_;
        this_ = threadPoolExecutor2;
        int n4 = n2;
        int n5 = n4 * 2;
        object2 = linkedBlockingQueue2;
        linkedBlockingQueue2 = new LinkedBlockingQueue();
        PriorityThreadFactory priorityThreadFactory5 = priorityThreadFactory3;
        priorityThreadFactory3 = new PriorityThreadFactory("core-io-executor", 10);
        threadPoolExecutor2 = new ThreadPoolExecutor(n5, n4 * 2, 10L, (TimeUnit)((Object)object), (BlockingQueue<Runnable>)object2, priorityThreadFactory5);
        v4.forIOTasks = this_;
        this_ = threadPoolExecutor;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue5 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        object2 = priorityThreadFactory2;
        priorityThreadFactory2 = new PriorityThreadFactory("core-computation-executor", 10);
        threadPoolExecutor = new ThreadPoolExecutor(1, 2, 10L, (TimeUnit)((Object)object), (BlockingQueue<Runnable>)linkedBlockingQueue5, (ThreadFactory)object2);
        v4.forComputationTasks = this_;
        this_ = scheduledThreadPoolExecutor;
        object = priorityThreadFactory;
        priorityThreadFactory = new PriorityThreadFactory("core-scheduled-executor", 10);
        scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(n2 *= 2, (ThreadFactory)object);
        v4.forScheduledTasks = this_;
        this_ = mainThreadExecutor;
        mainThreadExecutor = new MainThreadExecutor();
        v4.mainThreadExecutor = this_;
    }

    public static void postBitmapTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().forBitmapTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't perform bitmap task", outOfMemoryError);
                }
            }
        });
    }

    public static void postIOTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().forIOTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    runnable2.run();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof OutOfMemoryError) {
                        InstabugSDKLogger.e("IBG-Core", "low memory, can't run i/o task", throwable);
                    }
                    InstabugSDKLogger.e("IBG-Core", "Error while running IO task", throwable);
                }
            }
        });
    }

    public static void postIOTaskWithCheck(Runnable runnable) {
        Runnable runnable2;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            PoolProvider.postIOTask(runnable2);
        } else {
            runnable2.run();
        }
    }

    public static void postComputationTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().forComputationTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    PoolProvider.getInstance().forComputationTasks.execute(runnable2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run computation task", outOfMemoryError);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void postDelayedTask(Runnable runnable, long delayMillis) {
        void var1_1;
        Object object;
        Runnable runnable2 = new Runnable((Runnable)object){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    this.a.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run delayed task", outOfMemoryError);
                }
            }
        };
        object = TimeUnit.MILLISECONDS;
        PoolProvider.getInstance().forScheduledTasks.schedule(runnable2, (long)var1_1, (TimeUnit)((Object)object));
    }

    public static void postMainThreadTaskWithoutCheck(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().mainThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run main thread task", outOfMemoryError);
                }
            }
        });
    }

    public static void postMainThreadTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().mainThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run main thread task", outOfMemoryError);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void postTask(Executor executor, Runnable runnable) {
        void var1_1;
        Runnable runnable2;
        Runnable runnable3 = runnable2;
        runnable2 = new Runnable((Runnable)var1_1){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    this.a.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run task", outOfMemoryError);
                }
            }
        };
        executor.execute(runnable3);
    }

    public static Executor newBackgroundExecutor(String identifier) {
        String string2;
        PriorityThreadFactory priorityThreadFactory;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        int n2 = NUMBER_OF_CORES;
        int n3 = n2 * 2;
        int n4 = n2 * 2 + 1;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        PriorityThreadFactory priorityThreadFactory2 = priorityThreadFactory;
        priorityThreadFactory = new PriorityThreadFactory(string2, 10);
        return new ThreadPoolExecutor(n3, n4, 60L, timeUnit, linkedBlockingQueue2, priorityThreadFactory2);
    }

    public static synchronized Executor getSingleThreadExecutor(String identifier) {
        SingleThreadPoolExecutor singleThreadPoolExecutor;
        String string2;
        Map<String, SingleThreadPoolExecutor> map = singleThreadPoolExecutorhMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        SingleThreadPoolExecutor singleThreadPoolExecutor2 = singleThreadPoolExecutor;
        singleThreadPoolExecutor2(string2);
        singleThreadPoolExecutor2.setIdentifier(string2).setThreadPoolIdleListener(new f(){

            @Override
            public void a(@Nullable String string2) {
                if (string2 != null) {
                    singleThreadPoolExecutorhMap.remove(string2);
                }
            }
        });
        map.put(string2, singleThreadPoolExecutor2);
        return singleThreadPoolExecutor;
    }

    public static synchronized Executor getNetworkingSingleThreadExecutor(String identifier) {
        e e2;
        String string2;
        Map<String, e> map = networkingSingleThreadExecutorhMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        e e3 = e2;
        e3(string2);
        e3.setIdentifier(string2).setThreadPoolIdleListener(new f(){

            @Override
            public void a(@Nullable String string2) {
                if (string2 != null) {
                    singleThreadPoolExecutorhMap.remove(string2);
                }
            }
        });
        map.put(string2, e3);
        return e2;
    }

    public static synchronized ReturnableSingleThreadExecutor getReturnableSingleThreadExecutor(String identifier) {
        ReturnableSingleThreadExecutor returnableSingleThreadExecutor;
        String string2;
        Map<String, ReturnableSingleThreadExecutor> map = returnableSingleThreadPoolExecutorhMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        ReturnableSingleThreadExecutor returnableSingleThreadExecutor2 = returnableSingleThreadExecutor;
        returnableSingleThreadExecutor2(string2);
        map.put(string2, returnableSingleThreadExecutor2);
        return returnableSingleThreadExecutor;
    }

    public static synchronized d getMonitoredSingleThreadExecutor(String identifier) {
        d d2;
        String string2;
        Map<String, d> map = monitoredSingleThreadExecutorMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        d d3 = d2;
        d3();
        map.put(string2, d3);
        return d2;
    }

    public static Executor getUserActionsExecutor() {
        return PoolProvider.getSingleThreadExecutor("user-actions-executor");
    }

    public static synchronized Executor getSyncExecutor() {
        return PoolProvider.getSingleThreadExecutor("sync-Executor");
    }

    public static ReturnableSingleThreadExecutor getApiExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("API-executor");
    }

    public static ReturnableSingleThreadExecutor getChatsCacheExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("chats-cache-executor");
    }

    public static ReturnableSingleThreadExecutor getSurveysDBExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("surveys-db-executor");
    }

    public static d getDatabaseExecutor() {
        return PoolProvider.getMonitoredSingleThreadExecutor("IBG-db-executor");
    }

    public static ReturnableSingleThreadExecutor getFilesEncryptionExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("Files-Encryption");
    }

    static {
        singleThreadPoolExecutorhMap = new HashMap<String, SingleThreadPoolExecutor>();
        returnableSingleThreadPoolExecutorhMap = new HashMap<String, ReturnableSingleThreadExecutor>();
        networkingSingleThreadExecutorhMap = new HashMap<String, e>();
        monitoredSingleThreadExecutorMap = new HashMap<String, d>();
    }

    public ThreadPoolExecutor getBackgroundExecutor() {
        return this.forIOTasks;
    }

    public ThreadPoolExecutor getIOExecutor() {
        return this.forIOTasks;
    }
}

